/*	%M%	%I%	%E%	*/

/*	Copyright Sun Microsystems 1983.  All rights reserved */

/*
 * 	Overview:	Defines the interface to the data structure called 
 *			a RectList which is a list of rectangles.
 */

/*	Includes		*/

#ifdef KERNEL
#include "../sundev/rect.h"
#else
#include <sundev/rect.h>
#endif

/*	RectList data structures	*/

typedef struct RectNode	{
	struct RectNode  *next;		/* Pointer to next RectNode	*/
	Rect	   rect;
	} RectNode;

typedef struct {
	coord	xOff, yOff;		/* Offset to apply to each rect
					   in list including bound	*/
	RectNode	*head;		/* Pointer to first RectNode	*/
	RectNode	*tail;		/* Pointer to last RectNode	*/
	Rect	 	bound;		/* Describes bounding rect of 
					   all rects in list		*/
	} RectList ;

/*	RectList constants	*/

extern RectNode nullRNode;
extern RectList nullRList;

/*	RectList geometry predicates and functions

bool	bvEmptyRectList();	/* (RectList *rl)
				 * returns TRUE if rl covers no area
				 */
bool	bvRLIncludesPoint();	/* (RectList *rl; coord x, y)
				 * returns whether any rectangle in rl
				 * contains point (x, y)
				 */
	intersectRLs();		/* (RectList *rl1, *rl2, *rl)
				 * Frees rl, then makes it contain
				 * intersection of rl1 and rl2.
				 */
	sortRL();		/* (RList *rl1, *rl; Direction direction)
				 * Used to order rl1 when about to scroll 
				 * (Diagonal scrolling not supported yet). */
	unionRLs();		/* Like intersectRLs but does union	*/
	difRLs();			/* Like intersectRLs but does rl1-rl2	*/

/*	RectList with Rect geometry predicates and functions	*/

bool	bvRectEqualsRL();	/* (Rect *r; RectList *rl)
				 * (bvEqualRects((r),&((rl)->bound) &&
				 * (rl)->head==(rl)->tail)
				 */
bool	bvRectInRLBound();	/* (Rect *r;  RectList *rl)
				 *  bvRectsIntersect(r,&rl->bound)
				 */
	rectIntersectRL();	/* (Rect *r; RectList *rl1, *rl)
				 * Like intersectRLs but with a rectangle
				 */
	rectUnionRL();		/* Like rectIntersectRL but does union*/
	rectDifRL();		/* Like rectIntersectRL but does rl1-rl*/

/*	RectList initialization functions	*/

	initRLWithRect();		/* (Rect *r; RectList *rl)
				 * assumes that rl is uninitialized.
				 * offsets set to 0	*/
	setRectList();		/* (RectList *rlFrom, *rlTo)
				 * simply sets, doesn't copy list
	 			 */

/*	Embedded RectList Transformations	*/

	passToChildARL();	/* (coord xChildInParent, yChildInParent;
				 *  RectList *rlWrtParent)
				 * Modifies parent relative rl offset so it's 
				 * relative to its own coordinate space.
				 */
	passToParentARL();	/* (coord xChildInParent, yChildInParent;
				 *  RectList *rlWrtChild)
				 * Modifies self relative rl offset so it's 
				 * relative to its parent's coordinate space.
				 */

/*	RectList List Memory Management functions	*/

	copyRectList();		/* (RectList *rl1, *rl)
				 * Copies rl1 to rl unless rl1==rl.
				 */
	freeRectList();		/* (RectList *rl)
				 * Frees up storage for list and sets 
				 * to nullRectList 
				 */

/*	RectList Offset Adjustment functions	*/

Rect	offsetRectAdjust();	/* (RectList *rl, Rect *r)
				 * returns rect computed by addingi
				 * the offsets in rl to r
				 */
	offsetCoordAdjust();	/* (RectList *rl, coord *x, *y)
				 * subt the offsets in rl from x and y
	 			 */
	normalizeRectList();	/* (RList *rl) do offsetRectAdjust on
				 * each rect in rl and set offsets to 0 */

/*	Debugging Utilities

	printRectList();	/* (RectList *rl; char *tag) attach tag to 
				 * front of formatted rl printout on std out
				 */

