.TH IsColor 1 "Release 5" "X Version 11"
.SH NAME
IsColor \- check type of display is color
.SH SYNOPSIS
.B IsColor
[
.BI \-v
]
[
.BI \-c
.I ColorClass
]
.SH DESCRIPTION
.PP
.I IsColor
by default
returns 0 when the associated X server and display are capable of
handling colors as opposed to greyscale or black 'n white.
Using \-v (verbose) displays information about the X server, such as
vendor, release, geometry, depth of bitplane.
Using \-c option will test on specific colorclasses.
.SH OPTIONS
.LP
.TP 15
.BI \-v
will display the parameters retrieved from the X server.
.TP
.BI \-c " ColorClass"
will test the CLASS parameter to be of value `ColorClass'.
Possible values are StaticGray,  GrayScale, StaticColor, PseudoColor,
TrueColor and DirectColor.
.TP
.BI default
will test the X server to have capabilities to handle colors.
.LP
.SH EXAMPLE
.PP
In resource files one may distinguish color displays by means of
testing the macro variable COLOR. This cannot be done in e.g. .xinitrc.
.B IsColor
uses
.I xrdb
to retrieve parameters from the X server and decide on its color capability.
.PP
The following shows part of .xinitrc to set the background:
.PP
.nf
if IsColor
then
        xsetroot -solid lightskyblue
else
        xsetroot -grey
fi;
.fi
.SH DIAGNOSTICS
Thou shallt have proper access to the X-server. Check $DISPLAY and
server access authorisation on failure.
.SH "SEE ALSO"
constype(1), xrdb(1)
.SH AUTHOR
Geert Rolf, Informatische Chemie & -Fysica, K.U. Nijmegen.
