.TH FIG2DEV 1 "1 Nov 1991"
.SH NAME
fig2dev \- translates Fig code to various graphics languages

.SH SYNOPSIS
.B fig2dev
.B \-L
.I language
[
.B \-m
.I mag
] [
.B \-f 
.I font
] [
.B \-s
.I fsize
] [
.I other options
] [
\fIfig-file\fR [ \fIout-file\fR ] ]

.SH DESCRIPTION
.I Fig2dev
translates fig code in the named
.I fig-file
into the specified graphics 
.I language
and puts them in
.I out-file.
The default
.I fig-file
and
.I out-file
are standard input and standard output, respectively
.LP
Fig (Facility for Interactive Generation of figures) is a screen-oriented
tool which allows the user to draw and manipulate objects interactively.
Various versions of Fig run under the Suntools/Sunview window environment
and under version 11 of the X Windows System.
Fig2dev is compatible with Fig versions 1.3, 1.4, 2.0, and 2.1.

.SH OPTIONS
.TP
.B \-L
Set the output graphics language.
Valid languages are
\fBbox, epic, eepic, eepicemu, ibmgl, latex, null, pic, pictex, ps, pstex, pstex_t,textyl,\fR
and
.B tpic.
.TP
.B \-m
Set the magnification at which the figure is rendered to
.I mag.
The default is 1.0.
.TP
.B \-f 
Set the default font used for text objects to
.I font.
The default is Roman; the format of this option depends on the graphics
.I language
in use.
In TeX-based languages, the font is the base of the name given in lfonts.tex,
for instance \"cmr\" for Roman, or \"tt\" for teletype.
In PostScript, it is any font name known to the printer or interpreter.
.TP
.B \-s
Set the default font size (in points) for text objects to
.I fsize.
The default is 11*mag, and thus is scaled by the \fB-m\fR option.
If there is no scaling, the default font is eleven point Roman."
.TP
.B \-V
Print the program version number only.
.TP
.I other options
The other options are specific to the choice of graphics
.I language,
as described below.

.SH EPIC OPTIONS
EPIC is an enhancement to LaTeX picture drawing environment.
It was developed by Sunil Podar of Department of Computer Science
in S.U.N.Y at Stony Brook.
.LP
EEPIC is an extension to EPIC and LaTeX picture drawing environment
which uses tpic specials as a graphics mechanism.
It was written by Conrad Kwok of Division of
Computer Science at University of California, Davis.
.LP
EEPIC-EMU is an EEPIC emulation package which does not use tpic specials.
.TP
.B \-l
Use "\fB\\thicklines\fR" when width of the line is wider than 
.I lwidth.
The default is 2.
.TP
.B \-v
Include comments in the output file.
.TP
.B \-P
Generate a complete LaTeX file. In other words, the output file can be
formatted without requiring any changes. The additional text inserted
in the beginning and at the end of the file is controlled by the
configuration parameter "Preamble" and "Postamble".
.TP
.B \-S
Set the scale to which the figure is rendered.
This option automatically sets the 
.I magnification
and size to
.I scale
/ 12 and 
.I scale
respectively.
.TP
.B \-W
Enable variable line width
.TP
.B \-w
Disable variable line width. Only "\fB\\thicklines\fR" and/or
"\fB\\thinlines\fR" commands will be generated in the output file.
.LP
When variable line width option is enabled, "\fB\\thinlines\fR"
command is still used when line width is less than
\fILineThick\fR. One potential problem is that the width of
"\fB\\thinlines\fR" is 0.4pt
but the resolution of Fig is 1/80 inch (approx. 1pt). If
\fILineThick\fR is set to 2, normal lines will be drawn in 0.4pt
wide lines but the next line width is already 2pt. One possible
solution is to set \fILineThick\fR to 1 and set the width of the
those lines you want to be drawn in "\fB\\thinlines\fR"  to 0.

Due to this problem, Variable line width \fIVarWidth\fR
is defaulted to be false.

.SH IBM-GL OPTIONS
IBM-GL (International Business Machines Graphics Language) is compatible
with HP-GL (Hewlett-Packard Graphics Language).
.TP
.B \-a
Select ISO A4 (ANSI A) paper size if the default is ANSI A (ISO A4) paper size.
.TP
.B \-c
Generate instructions for an IBM 6180 Color Plotter
with (without) an IBM Graphics Enhancement Cartridge (IBM-GEC).
.TP
.B \-d
Restrict plotting to a rectangular area of the plotter paper which has
a lower left hand corner at
.I (xll,yll)
and a upper right hand corner at
.I (xur,yur).
All four numbers are in inches and follow \fB-d\fR in a comma-sparated list -
.I xll,yll,xur,yur
- with no spaces between them.
.TP
.B \-f
Load text character specifications from the table in the
.I fonts
file.
The table must have 36 entries - one for each font plus a default.
Each entry consists of 5 numbers
which specify the
1.) standard character set (0 - 4, 6 - 9, 30 - 39),
2.) alternate character set (0 - 4, 6 - 9, 30 - 39),
3.) character slant angle (degrees),
4.) character width scale factor and
5.) character height scale factor.
.TP
.B \-l
Load area fill line patterns from the table in the
.I patterns
file.
The table must have 21 entries - one for each of the area fill patterns.
Each entry consists of 5 numbers which specify the
1.) pattern number (-1 - 6),
2.) pattern length (inches),
3.) fill type (1 - 5),
4.) fill spacing (inches) and
5.) fill angle (degrees).
.TP
.B \-m
The magnification may appear as the first element in a comma sepatated list -
.I mag,x0,y0
- where the second and third parameters specify an offset in inches.
.TP
.B \-p
Load plotter pen specifications from the table in the
.I pens
file.
The table must have 9 entries - one for each color plus a default.
Each entry consists of 2 numbers which specify the
1.) pen number (1 - 8) and
2.) pen thickness (millimeters).
.TP
.B \-P
Rotate the figure to portrait mode. The default is landscape mode.
.TP
.B \-S
Set the pen speed to
.I speed
(centimeters/second).
.TP
.B \-v
Plot the figure upside-down in portrait mode or backwards in landscape mode.
This allows you to write on the top surface of overhead transparencies without
disturbing the plotter ink on the bottom surface.
.LP
Fig2dev may be installed with either ANSI A or ISO A4 default paper size.
The \fB-a\fR option selects the alternate paper size.
Fig2dev does not fill closed splines.
The IBM-GEC is required to fill other polygons.
Fig2dev may be installed for plotters with or without the IBM-GEC.
The \fB-c\fR option selects the alternate instruction set.

.SH LATEX OPTIONS
.TP
.B \-l
Sets the threshold between LaTeX thin and thick lines to 
.I lwidth
pixels.
LaTeX supports only two different line width: \\thinlines and \\thicklines.
Lines of width greater than
.I lwidth
pixels are drawn as \\thicklines.
Also affects the size of dots in dotted line style.
The default is 0.
.TP
.B \-d
Set a separate magnification for the length of line dashes to
.I dmag.
.TP
.B \-v
Verbose mode.
.LP
LaTeX cannot accurately represent all the graphics objects which can
be described by Fig.
For example, the possible slopes which lines may have are limited.
Some objects, such as spline curves, cannot be drawn at all.
Fig2latex chooses the closest possible line slope, and prints error
messages when objects cannot be drawn accurately

.SH PIC OPTIONS
.TP
.B -p
Enables the use of certain PIC extensions which are known to work with
the groff package; compatibility with DWB PIC is unknown.
The extensions enabled by each option are:
.LP
.TP
.B arc
Allow ARC_BOX i.e. use rounded corners
.TP
.B line
Use the 'line_thickness' value
.TP
.B fill
Allow ellipses to be filled
.TP
.B all
Use all of the above
.TP
.B psfont
Don't convert Postscript fonts generic type (useful for files going to be
Ditroff'ed for and printed on PS printer). DWB-compatible.
.TP
.B allps
Use all of the above (i.e. "all" + "psfont")
.EP
.EP

.SH PICTEX OUTPUT
In order to include PiCTeX pictures into a document, it is necessary to
load the PiCTeX macros.
.LP
PiCTeX uses TeX integer register arithmetic to generate curves,
and so it is very slow.
PiCTeX draws curves by \fB\\put\fR-ing the \fIpsymbol\fR repeatedly,
and so requires a large amount of TeX's internal memory,
and generates large DVI files.
The size of TeX's memory limits the number of plot symbols in a picture.
As a result, it is best to use PiCTeX to generate small pictures.

.SH POSTSCRIPT OPTIONS
With PostScript, Fig can be used to create large posters. The figure
will be created by printing multiple pages which can be glued together.
Due to memory limitations of most laser printers, the figure should not
be too complicated. Great for text with very big letters.
.LP
Text can now include various ISO-character codes above 0x7f, which is
useful for language specific characters to be printed directly.
Not all ISO-characters are implemented.
.LP
Color support: Colored objects created by Fig can be printed
on a color postscript printer. Currently 8 colors are
supported: black, blue, green, cyan, red, magenta, yellow, white.
On a monochrome printer, colored objects will be mapped into different
grayscales.
Filled objects are printed using the given grayscale. If filled
with grayscale set to 100%, the object will be filled with the same
color as the enclosing line.
.TP
.B -c
option centers the figure on the page.
The centering may not be accurate if there are texts in the
.I fig_file
that extends too far to the right of other objects.
.TP
.B -l dummy_arg
Rotate figure to landscape mode.  The dummy argument is ignored,
but must appear on the command line for reasons of compatibility.
.TP
.B -P
indicates that the figure describes a full page which will not
necessarily be inserted into a document, but can be sent directly
to a PS printer.
This ensures that a showpage command is inserted at the end of
the figure, and inhibits translation of the figure coordinate system.
.LP

.SH PSTEX OPTIONS
.TP
The
.B pstex
language is a variant of
.B ps
which suppresses formatted (special) text.
The
.B pstex_t
language has the complementary behavior: it generates only LaTeX commands
necessary to position special text, and to overlay the
PostScript file generated using
.B pstex.
These two drivers can be used to generate a figure which combines the
flexibility of PostScript graphics with LaTeX text formatting of
special text.
.TP
The
.B pstex_t
option 
.B -p file
specifies the name of the PostScript file to be overlaid.
If not set or its value is null then no PS file will be inserted.
.LP

.SH TEXTYL OPTIONS
There are no TeXtyl-specific options.

.SH TPIC OPTIONS
There are no tpic-specific options.

.SH "SEE ALSO"
[x]fig(1),
pic(1)
pic2fig(1),
transfig(1)
.SH COPYRIGHT
Copyright (c) 1985 Supoj Sutantavibul
.br
Copyright (c) 1991 Micah Beck
.LP
Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation. The authors make no representations about the suitability 
of this software for any purpose.  It is provided "as is" without express 
or implied warranty.
.LP
THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
EVENT SHALL THE AUTHORS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
.SH AUTHORS
Micah Beck
.br
Cornell University
.br
Sept 28 1990
.sp
and Frank Schmuck (then of Cornell University)
.br
and Conrad Kwok (then of U.C. Davis).
.sp
drivers contributed by
.br
Jose Alberto Fernandez R. (U. of Maryland)
.br
and Gary Beihl (MCC)
.sp
Color support, ISO-character encoding and poster support by
.br
Herbert Bauer (heb@regent.e-technik.tu-muenchen.de)
.sp
Modified from f2p (fig to PIC), by the author of Fig
.br
Supoj Sutanthavibul (supoj@sally.utexas.edu)
.br
University of Texas at Austin. 

