.TH XFIG 1 "Release 2.0 (Protocol 1.4X)"
.SH NAME
xfig \- Facility for Interactive Generation of figures under X11
.SH SYNOPSIS
.B xfig
[ \fB-ri[ght]\fP ] 
[ \fB-le[ft]\fP ]
[ \fB-L[andscape]\fP ]
[ \fB-P[ortrait]\fP ]
[ \fB-pw[idth]\fP \fIunits\fP ]
[ \fB-ph[eight]\fP \fIunits\fP ]
[ \fB-not[rack]\fP ]
[ \fB-tr[ack]\fP ]
[ \fB-inc[hes]\fP ]
[ \fB-me[tric]\fP ]
[ \fB-inv[erse]\fP ]
[ \fB-de[bug]\fP ]
[ \fIfile\fP ]
[ \fB-normal[Font]\fP \fIfont\fP ]
[ \fB-bold[Font]\fP \fIfont\fP ]
.SH DESCRIPTION
.I Xfig 
is a menu-driven tool that allows the user to draw and manipulate objects
interactively in an X window.  It runs under X version 11 release 3 or 4 and
requires a three-button mouse.
.I File 
specifies the name of a file to be edited. The description of objects in
the file will be read at the start of \fIxfig\fP. 
.PP
The output from \fIxfig\fP can be printed in several ways:
.PP
.B Postscript -
fig2ps (\fIxfig\fP to \fIpostscript\fP translator) is used to produce a 
.I postscript
file from an \fIxfig\fP file.
The 
.I postscript
file can be sent directly to a postscript printer.
.PP
.B troff -
f2p (\fIxfig\fP to \fIpic\fP(1) translator, also known by its previous
name \fIf2fp\fP(1L)) is used to translate \fIxfig\fP files into
.IR pic (1)
language.
The resulting file may then be processed in the same manner as any other
.I pic
file.  Note that area fill, line thicknesses and multiple fonts are not
supported by \fIftop\fP.
.PP
.B LaTeX -
fig2latex (\fIxfig\fP to \fILaTeX\fP translator) produces a
.I LaTeX
file from an
.I xfig
file.
This file contains
.I LaTeX
picture environment commands and can be
processed along with other
.I LaTeX
commands.
This program is in the \fITransFig\fP package available from
svax.cs.cornell.edu via anonymous ftp.
.PP
.B PiCTeX -
fig2tex (\fIxfig\fP to \fIPiCTeX\fP translator) produces a
.I PiCTeX
file from an
.I xfig
file.  This file contains macros that can be
used with the
.I PiCTeX
environment under
.I TeX
or
.I LaTeX.
This is also available from the \fITransFig\fP package.
.SH OPTIONS
.TP
.B \-ri
Change the position of the side panel window to the right of the canvas window
(default: left).
.TP
.B \-le
Change the position of the side panel window to the left of the canvas window.
.TP
.B \-L
Make \fIxfig\fP come up in landscape mode (10" x 7.5").  This is the default.
.TP
.B \-P
Make \fIxfig\fP come up in portrait mode (7.5" x 10").
.TP
\fB-pw\fP \fIunits\fP
Make \fIxfig\fP come up \fIunits\fP wide (where units are either cm or in).
.TP
\fB-ph\fP \fIunits\fP
Make \fIxfig\fP come up \fIunits\fP high (where units are either cm or in).
.TP
\fB-tr\fP
Turn on cursor (mouse) tracking arrows.
.TP
\fB-no\fP
Turn off cursor (mouse) tracking arrows.
.TP
\fB-inc\fP
Make inches the unit of choice (default).
.TP
\fB-me\fP
Make centimeters the unit of choice.
.TP
\fB-inv\fP
Use inverse video (white on black).
.TP
\fB-de\fP
Turn on debugging mode.
.TP
\fB-normal\fP \fIfont\fP
Cause the font used for questions to be \fIfont\fP.
This font is also used on the canvas when the selected font is not available
in an X11 font.
.TP
\fB-bold\fP \fIfont\fP
Cause the font used for displaying messages to be \fIfont\fP.
.SH "GRAPHICAL OBJECTS"
The objects in \fIxfig\fP are divided into \fBprimitive objects\fP and
\fBcompound object\fP. The primitive objects are: \fIARC\fP, \fICIRCLE\fP,
\fICLOSED SPLINE\fP, \fIELLIPSE\fP, \fIPOLYLINE\fP, \fIPOLYGON\fP,
\fISPLINE\fP, and \fITEXT\fP.  A primitive can be moved, rotated,
flipped, copied or erased.
A compound object is composed of primitive objects. The primitive objects
that constitute a compound can not be individually modified, but they can
be manipulated as an entity; a compound can be moved, rotated, flipped,
copied or erased.  An extra function that can be applied to a compound
object is \fBscaling\fP, which is not available for primitive objects.
.SH "DISPLAY WINDOWS"
Nine windows comprise the display area of \fIxfig\fP: the 
top ruler, the side ruler, two panel windows, the message window,
three indicator windows showing current line thickness, area-fill gray
color and rounded box corner radius, and the canvas window. 
The main panel window can be placed to the left or right of the
the canvas window (default: left), and the second panel window 
is always below the message window.  It contains buttons for quick
access to some of the pop-up menu commands.
.SH "POP-UP MENU"
The pop-up menu appears when the right mouse button is pressed with the
cursor positioned within the canvas window.
Positioning the cursor over the desired menu entry and releasing the
button selects a menu entry.
.PP
There are a number of file accessing functions in the pop-up menu.
Most of the time when one of these functions is selected, the user
will be asked for a file name.  If the specified file can be located
and the access permission are granted, \fIxfig\fP will carry out
the function.  However in case things go wrong, \fIxfig\fP will
abort the function and printed the causes on the message window.
Most of the functions in the pop-up menu can be directly access with
the lower button panel.
.TP
.I Undo
Undo the last object creation or modification.
.TP
.I Redisplay
Redraw the canvas.
.TP
.I Remove all
Remove all objects on the canvas window (can be undone).
.TP
.I Edit file ...
The current contents of the canvas are cleared and objects
are read from the specified file.
The user will be asked for a file name.
This file will become the current file.
.TP
.I Save
Save the current contents of the canvas in the current file.
If no file is being edited, the user will be asked for a file
name as in the "Save in ..." function.
.TP
.I Read file ...
Read objects from the specified file and merge them with objects already
shown on the canvas.
(The user will be asked for a file name.)
.TP
.I Save in ...
Save objects on the screen into a file specified by the user.
(The user will be asked for a file name.)
If there is no current file name, it will be set to the name specified
in the save.
.TP
.I Status
Show the name of the current file and directory.
.TP
.I Change Directory
Change the working directory.  Any file name without a full path name
will employ the current working directory.
.TP
.I Save & Quit
Save the objects in the current file and exit from \fIxfig\fP.
If there is no current file, the user will be asked for a file name.
No confirmation will be asked.
.TP
.I Quit
Exit from \fIxfig\fP, discarding all objects. The user will be asked to 
confirm the action, by clicking the left button.
.SH "BOTTOM PANEL COMMAND FUNCTIONS"
Most of the buttons in the bottom panel are counterparts to the pop-up menu functions.
However, there are additional buttons for selecting font, font size, print orientation
(landscape or portrait) and the printer device itself.
.SH "BOTTOM PANEL WINDOW COMMAND DESCRIPTIONS"
.TP
.I CHANGE TEXT
Change existing text to current font, size and justification settings.
.TP
.I FONT SELECT
This button pops up a menu of 35 fonts available for most Apple 
Postscript printers.
The name of the font appears in the font itself so that one may see 
what that font looks like.
If a corresponding X11 font exists, new text is created 
on the canvas using that font.
\fIxfig\fP uses the size of X11 font closest to that selected 
by the font size button.
If the X11 font doesn't exist, \fIxfig\fP uses the font 
selected by the "-normal" option.
To abort selection of a font, click on the title of the menu.
.TP
.I FONT SIZE
The left button decreases the point size of font used on the canvas and printer.
The right button increases the point size.
.TP
.I LANDSCAPE/PORTRAIT
Select landscape or portrait mode of printing.
The default setting is that of the \fIxfig\fP canvas.
.TP
.I PRINTER SELECT
Toggle through a list of printers available for printing the figure. 
At present this list must be compiled into \fIxfig\fP.
.TP
.I TEXT JUSTIFICATION
Clicking this button cycles through selection of left, center and right justification
of text.
.SH "SIDE PANEL WINDOW MANIPULATION FUNCTIONS"
Icons in the side panel window represent object manipulation functions,
modes and other drawing or modification aids.
Manipulation functions are selected by positioning the cursor over it and
clicking the left mouse button.  The selected icon is highlighted, and
a message describing its function appears in the message window.
.PP
The left and middle buttons are used to creat and modify objects in the canvas
window.  Most actions start with clicking of the left button
and end with clicking of the middle button.
There is no need to hold down a button while positioning
the cursor.
.SH "SIDE PANEL WINDOW COMMAND DESCRIPTIONS"
Entries in the side panel window can be classified into two categories:
object creation/modification/removal commands (only one of which may be active
at any one time), and drawing aids (which act as toggle switches or settings).
There are two ways for drawing circles, two for ellipses, two for splines
and two for closed splines.
There are two basic splines.  One is the interpolated spline
in which the spline pass thorough the entered points (knots).
The other is the normal spline in which on control points are
passed by the spline (except for the two end points in the open spline).
.SH "OBJECT CREATION/MODIFICATION/REMOVAL"
Multiple commands are grouped thematically in the following
descriptions (which is listed alphabetically).
.TP
.I AREA-FILL ON/OFF
Turn on or off area-fill mode.  This will affect any arcs, boxes, 
polygons, circles, closed splines or ellipses created subsequently.
.TP
.I ADD/DELETE ARROWS
Add or delete arrow heads for \fIPOLYLINE\fP, \fIPOLYGON\fP, \fISPLINE\fP
or \fICLOSED SPLINE\fP objects (points of a \fIBOX\fP can not be added or
deleted).
.TP
.I ADD/DELETE POINTS
Add or delete points for \fIPOLYLINE\fP, \fIPOLYGON\fP, \fISPLINE\fP
or \fICLOSED SPLINE\fP objects (points of a \fIBOX\fP can not be added
or deleted).
.TP
.I ARC
Create an arc.  Specify three points using the left button.
.TP
.I BOX
Create rectangular boxes.  Start with the left button and terminate with
the middle button.
.TP
.I ROUNDED-CORNER BOX
Create rectangular boxes with rounded corners.  Start with the
left button and terminate with the middle button.  
The radius of the corners is selected by the INCREASE/DECREASE RADIUS button.
.TP
.I BREAK COMPOUND
Break  a compound object to allow manipulation of its component parts.
Click the left button on the bounding box of
the compound object.
.TP
.I CHANGE LINE STYLE OF EXISTING OBJECT
Click left button on an object and the line style will change to the currently
selected style.
.TP
.I CHANGE LINE THICKNESS OF EXISTING OBJECT
Click left button on an object and the line thickness will change 
to the currently selected thickness.
.TP
.I CIRCLE 
Create circles by specifying their radii or diameters.
Click the left button on the canvas window, move the cursor until the
desired radius or diameter is reached, then click the middle button to
terminate. The circle will be drawn after the pressing of the middle button.
.TP
.I CLOSED INTERPOLATED SPLINE
Create closed or periodic splines.  The function is similar
to \fIPOLYGON\fP except that a closed interpolated spline is drawn.
The spline will pass through the points (knots).
.TP
.I CLOSED SPLINE
Create closed or periodic spline objects.
The function is similar to \fIPOLYGON\fP
except that a closed spline will be drawn instead of polygon.
The entered points are just control points; i.e., the spline will
not pass any of these points.
.TP
.I COPY
Copy object.  Click the left button over part of the object to be
copied (for \fICIRCLE\fP and \fIELLIPSE\fP
objects, position on their circumferences).  Drag the object to the desired
position and click the middle button.
This function as well as the following three functions 
(\fIMOVE\fP, \fIMOVE POINT\fP, \fIREMOVE\fP)
will cause point markers (manipulation aids) to be shown on the canvas window.
There are no markers for \fICIRCLE\fP or \fIELLIPSE\fP objects.
.TP
.I DARKEN/LIGHTEN AREA-FILL COLOR
The left button lightens the area-fill color 
(black to white through 20 gray levels).  The right button darkens it.
The (approximate) current area fill color is shown in the right-most
indicator window.
.TP
.I ELLIPSE
Create ellipses using the same procedure as for the drawing of circles.
.TP
.I GLUE
Glue the objects within a bounding box into a compound object
(the bounding box itself is not part of the figure; 
it is a visual aid for manipulating the compound). 
.TP
.I INCREASE/DECREASE LINE THICKNESS
The left button decreases the line thickness by one pixel, the right
button increases it by one pixel.  The current line thickness
is shown in the left-most indicator window.
.TP
.I INCREASE/DECREASE RADIUS OF ROUNDED BOX CORNERS
The left button decreases the radius used in the corners of rounded boxes, 
the right button increases it. The current radius is shown in the middle
indicator window.
.TP
.I INTERPOLATED SPLINE
Create (cubic spline) spline objects.
Enter control vectors in the same way as for creation of a
\fIPOLYLINE\fP object.
At least three points (two control vectors) must be entered.
The spline will pass through the entered points.
.TP
.I MOVE
Move objects in the same way as in \fICOPY\fP.
.TP
.I MOVE POINT
Modify the position of points of \fIPOLYLINE\fP, \fIBOX\fP, \fIPOLYGON\fP,
\fIELLIPSE\fP, \fIARC\fP and \fISPLINE\fP
objects.  Click the left button over the desired point, reposition the point,
and click the middle button.  Note that \fIBOX\fP, 
\fIROUNDED-CORNER BOX\fP and \fIPOLYGON\fP 
objects are internally stored as \fIPOLYLINE\fP
objects, and therefore moving certain points may open these objects.
.TP
.I POLYGON
Same as \fIPOLYLINE\fP
except that a line segment is drawn connecting the first and last
points entered.
.TP
.I POLYLINE
Create polylines (line segments connecting a sequence of points).
Enter points by clicking the left button at the desired positions on the
canvas window.  Click the middle button to terminate.
.TP
.I REMOVE
Remove (or delete) objects.
.TP
.I SCALE COMPOUND
Only compound objects can be scaled.  Click the left button
on a corner of the bounding box, stretch the
bounding box to the desired size, and click the middle button.
Or click the left button on a side of the bounding box, stretch that
side to the desired size, and click the middle button.
.TP
.I SPLINE
Create (quadratic spline) spline objects.
Enter control vectors in the same way as for creation of a
\fIPOLYLINE\fP object.
At least three points (two control vectors) must be entered.
The spline will pass only the two end points.
.TP
.I TEXT
Create text strings. Click the left button at the desired position on
the canvas window, then enter text from the keyboard.
Text is drawn using the current font, font size and justification settings.
A DEL or ^H (backspace) will delete a character, while a ^U will kill
the entire line.
Terminate by clicking the middle button or typing the return key.  To
edit text, click on an existing text string with the left button.
Insertion of characters will take place at that point.  
.TP
.I TURN
Turn \fIPOLYGON\fP into a \fICLOSED INTERPOLATED SPLINE\fP object, or
turn \fIPOLYLINE\fP into a \fIINTERPOLATED SPLINE\fP object.
.SH "DRAWING AIDS"
Drawing aids act as toggle switches. More than one can be selected at a time
(except for \fIGRID\fP and the line drawing modes).
.TP
.I AUTO FORWARD/BACKWARD ARROW
Automatically add forward/backward arrow heads to \fIPOLYLINE\fP, \fISPLINE\fP
or \fIARC\fP objects.
.TP
.I FLIP
Invert the object (middle button) or produce a mirror-image copy of an
object (left button). Point to part of the object ("the handle"), click
the appropriate button.
.TP
.I GRID
Display either the quarter- or half-inch grids (left button).
.TP
.I MAGNET
Round points to the nearest 1/16 of an inch.
This affects every function, and is provided as an alignment aid.
.TP
.I UNRESTRICTED
Allow lines to be drawn with any slope.
.TP
.I MANHATTAN
Enforce drawing of lines in the horizontal and vertical direction only.
Both \fIMANHATTAN\fP and \fIMOUNTAIN\fP can be turned on simultaneously. The
creations of \fIPOLYGON\fP, \fIPOLYLINE\fP and \fISPLINE\fP objects are
affected by these two modes.
.TP
.I MOUNTAIN
Enforce drawing of only diagonal lines.  Both \fIMANHATTAN\fP
and \fIMOUNTAIN\fP can be turned on simultaneously. The creations
of \fIPOLYGON\fP, \fIPOLYLINE\fP and \fISPLINE\fP objects are affected
by these two modes.
.TP
.I MANHATTAN MOUNTAIN
Allow lines to be drawn at any slope allowed when in
MOUNTAIN or MANHATTAN modes.
.TP
.I ROTATE
Rotate the object (middle button) or copy (left button) +90 degrees.
.TP
.I SOLID/DASHED/DOTTED LINE STYLE
Toggle between solid, dashed and dotted line styles. The dash length
is fixed at 0.05 inch.
.PP
If \fIxfig\fP is compiled with the -DTFX option (TransFig compatibility)
then the following two buttons are available:
.TP
.I LATEX LINE
Allow lines to be drawn only at slopes which can be handled by LaTeX picture
environment lines: slope = x/y, where x,y are integers in the range [-6,6].
.TP
.I LATEX VECTOR
Allow lines to be drawn only at slopes which can be handled by LaTeX picture
environment vectors: slope = x/y, where x,y are integers in the range [-4,4].
.SH X DEFAULTS
The overall widget name(Class) is xfig.fig(Fig.TopLevelShell).  This
set of resources correspond to the command line arguments:
.TP 1.25i
justify
(boolean:false) -right (true) and -left (false) arguments
.TP
landscape
(boolean:true) -Landscape and -Portrait arguments
.TP
pwidth
(integer:7.5 or 10 inches) -pwidth argument
.TP
pheight
(integer:10 or 7.5 inches) -pheight argument
.TP
trackCursor
(boolean:on) -track and -notrack arguments
.TP
inches
(boolean:true) -inches and -metric arguments
.TP
reverseVideo
(boolean:off) -inverse argument
.TP
debug
(boolean:off) -debug argument
.TP
normalFont
(string:fixed) -normal argument
.TP
boldFont
(string:8x13bold) -bold argument
.PP
These arguments correspond to the widgets which make up \fIxfig\fP.
.TP 1.5i
overall window
form(Form)
.TP
side panel
form.side_panel(Form.Box)
.TP
bottom panel
form.bottom_panel(Form.Box)
.TP
buttons
form.side_panel.button(Form.Box.Command)
form.bottom_panel.button(Form.Box.Command)
.TP
top ruler
form.truler(Form.Label)
.TP
side ruler
form.sruler(Form.Label)
.TP
canvas
form.canvas(Form.Label)
.TP
message window
form.message(Form.Command)
.TP
menu
form.popup_menu.menu(Form.OverrideShell.Box)
.TP
menu title
form.popup_menu.menu.title(Form.OverrideShell.Box.Label)
.TP
menu items
form.popup_menu.menu.pane(Form.OverrideShell.Box.Command)
.TP
font menu
form.font_menu.menu(Form.OverrideShell.Box)
.TP
indicator panel
form.indicator(Form.Box)
.TP
font indicator window
form.font_indicator(Form.Label)
.PP
For example, to set the background of the side panel to blue and the 
indicator panel background to green the resources
would be:
.br
\f(CWxfig*form.panel.background: blue\fP
.br
\f(CWxfig*form.indicator.background: blue\fP
.SH BUGS
.PP
Creating a text object is not "Undoable".
.PP
Area fill doesn't show on the canvas for closed splines, but are filled 
when printed.  This has to do with the way the splines are generated on the
screen.
.PP
Undoing the creation of a compound object deletes the objects
inside the compound object.  Undoing the undo doesn't bring them back.
.PP
Ellipses which are too narrow are not drawn correctly.
.PP
Objects which are created while one of the 
.I grids
is on may appear ragged. This can be corrected by selecting \fIRedisplay\fP
from the pop-up menu.
.SH "SEE ALSO"
Brian W. Kernighan
.I "PIC - A Graphics Language for Typesetting User Manual"
.br
fig2ps(1)
.SH ACKNOWLEDGEMENT
Many thanks goes to Professor Donald E. Fussell who inspired the
creation of this tool.
.SH AUTHORS
Original author:
.br
Supoj Sutanthavibul
.br
University of Texas at Austin 
.br
(supoj@sally.utexas.edu) 
.sp
Manual page modified by:
.br
R. P. C. Rodgers
.br
UCSF School of Pharmacy
.br
San Francisco, CA 94118 
.sp
The LaTeX line drawing modes were contributed by:
.br
Frank Schmuck
.br
Cornell University
.sp
X11 port by:
.br
Ken Yap
.br
Rochester
.br
(ken@cs.rochester.edu)
.sp
Variable window sizes, cleanup of X11 port, right hand side panel
under X11, X11 manual page provided by:
.br
Dana Chee
.br
Bellcore
.br
(dana@bellcore.com)
.sp
Cleanup of color port to X11 by:
.br
John T. Kohl
.br
MIT
.br
(jtkohl@athena.mit.edu)
.sp
Area fill, multiple line thicknesses, multiple fonts and font sizes,
bottom panel, line style/thickness modification of objects by:
.sp
Brian V. Smith
.br
Lawrence Berkeley Laboratory
.br
(standard disclaimer applies)
.br
(bvsmith@lbl.gov)
