.TH TRANSFIG 1 "1 Sept 1990"
.SH NAME
transfig \- creates a makefile for portable LaTeX figures
.SH SYNOPSIS
.B transfig
[ -L \fIlanguage\fR ]
[ -M \fImakefile\fR ]
[ -T \fItexfile\fR ]
[ -I \fImacrofile\fR ]
[ -V ] 
[ \fIcontrol_specs\fR figfile ... ] ...]
.SH DESCRIPTION
.I Transfig
creates a makefile to translate figures described in Fig code, PostScript,
or PIC into a specified LaTeX graphics \fIlanguage\fR.
PostScript and PIC files are identified by the suffixes ".ps" and ".pic"
respectively;
Fig files can be specified either with or without the suffix ".fig" .
Transfig also creates a TeX macro file appropriate to the target language.
.SH OPTIONS
The \fIlanguage\fR specifier must be either
.T
.BR epic ,
.BR eepic ,
.BR eepicemu ,
.BR latex ,
.BR pictex ,
.BR ps ,
.BR psfig ,
.BR pstex ,
.BR textyl ,
.BR tpic ,
or
.BR null .
The specifier
.B psfig
is like the 
.B ps
specifier, except that it
make use of the psfig macro package.
The specifier
.B pstex
is like
.B psfig,
except that it uses LaTeX to process formatted (special) text.
The specifier 
.B null
results in the figures being replaced by empty boxes of the
appropriate size.
If no language is specified,
.B epic
is the default.
.PP
The names of the makefile and TeX macro file can be set with the
-M and -T options.
The default names are "Makefile" and "transfig.tex", respectively.
If the -I option is specified, then a command to read in \fImacrofile\fR is
	inserted into the TeX macro file.
If the -V option is specified, the program version number is printed only.
.PP
Control specifiers are 
.TP
\fB\-m\fI mag\fR
set the magnification at which the figure is rendered (default 1.0).
.TP
\fB\-f\fI font\fR
set the default font family used for text objects (default "\fBrm\fR").
.TP
\fB\-s \fIfontsize\fR
set the default font size (in points) for text objects (default 11*\fImag\fR).
.TP
\fB\-o \fIoption\fR
pass the specified option string through to fig2dev.
.PP
If there is no scaling, the default font is an eleven point roman font.
Language and control specifiers may occur more than once;
they affect the translation of files which appear to their
right in the argument list. 
If no files are specified, then "*.fig" is assumed.
.SH "SEE ALSO"
fig(1),
fig2dev(1),
pic(1),
pic2fig(1),
.SH COPYRIGHT
Copyright (c) 1985 Supoj Sutantavibul
.br
Copyright (c) 1991 Micah Beck
.LP
Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation. The authors make no representations about the suitability 
of this software for any purpose.  It is provided "as is" without express 
or implied warranty.
.LP
THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
EVENT SHALL THE AUTHORS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
.SH AUTHOR
Micah Beck
