#ifndef USS

#if defined(WIN32)
#define ZERO 0I64
#define MSBMASK     0x8000000000000000I64
#define LSBMASK     0x0000000000000001I64
#define FRACMASK    0x00FFFFFFFFFFFFFFI64
#define FRACLMASK   0x00000000FFFFFFFFI64
#define FRACMMASK   0x0000FFFFFFFF0000I64
#define FRACHMASK   0x000FFFFFFFF00000I64
#define FRACTMASK   0xFFFFFFFF00000000I64
#define FRAC32MASK  0x00FFFFFFFF000000I64
#define FRAC16MASK  0x00FFFF0000000000I64
#define FRAC8MASK   0x00FF000000000000I64
#define FRAC4MASK   0x00F0000000000000I64
#define GUARD1MASK  0xF000000000000000I64
#define GUARD2MASK  0x0F00000000000000I64
#define SHORTNORM   0x0000F00000000000I64
#else
#define ZERO 0ULL
#define MSBMASK     0x8000000000000000ULL
#define LSBMASK     0x0000000000000001ULL
#define FRACMASK    0x00FFFFFFFFFFFFFFULL
#define FRACLMASK   0x00000000FFFFFFFFULL
#define FRACMMASK   0x0000FFFFFFFF0000ULL
#define FRACHMASK   0x000FFFFFFFF00000ULL
#define FRACTMASK   0xFFFFFFFF00000000ULL
#define FRAC32MASK  0x00FFFFFFFF000000ULL
#define FRAC16MASK  0x00FFFF0000000000ULL
#define FRAC8MASK   0x00FF000000000000ULL
#define FRAC4MASK   0x00F0000000000000ULL
#define GUARD1MASK  0xF000000000000000ULL
#define GUARD2MASK  0x0F00000000000000ULL
#define SHORTNORM   0x0000F00000000000ULL
#endif

#define PGM_EXPONENT_OVERFLOW_EXCEPTION 12
#define PGM_EXPONENT_UNDERFLOW_EXCEPTION 13
#define PGM_SIGNIFICANCE_EXCEPTION 14
#define PGM_FLOATING_POINT_DIVIDE_EXCEPTION 15

#define CC_EQ 0
#define CC_LT 1
#define CC_GT 2

extern int    ibm_addl (t_uint64 *, t_uint64 *);
extern int    ibm_cmpl (t_uint64 *, t_uint64 *);
extern int    ibm_divl (t_uint64 *, t_uint64 *);
extern uint32 ibm_fixl (t_uint64 *, int);
extern int    ibm_fltl (t_uint64 *, int32);
extern int    ibm_mpyl (t_uint64 *, t_uint64 *);
extern int    ibm_negl (t_uint64 *);
extern int    ibm_subl (t_uint64 *, t_uint64 *);

extern int    ibm_adds (uint32 *, uint32 *);
extern int    ibm_cmps (uint32 *, uint32 *);
extern int    ibm_divs (uint32 *, uint32 *);
extern uint32 ibm_fixs (uint32 *, int);
extern int    ibm_flts (uint32 *, int32);
extern int    ibm_mpys (uint32 *, uint32 *);
extern int    ibm_negs (uint32 *);
extern int    ibm_subs (uint32 *, uint32 *);

#endif /* USS */
