/***********************************************************************
*
* DUMPFPY - Dumps a TI990 floppy image file.
*
* Changes:
*      06/20/04   DGP   Original.
*
***********************************************************************/
 
#include <stdio.h>
#include <stddef.h>
#include <errno.h>
#include <ctype.h>

#define NORMAL		0
#define ABORT		16

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define FPYSECTTRK 26
#define FPYTRKCYL  77
#define FPYSECTLEN 128

#define HEXDUMP(file,ptr,size)	\
{\
   int jjj;\
   int iii;\
   char *tp;\
   char *cp;\
   for (iii = 0, tp = (char *)(ptr), cp = (char *)(ptr); iii < (size); )\
   {\
      fprintf ((file), "%04X  ", iii);\
      for (jjj = 0; jjj < 8; jjj++)\
      {\
	 if (cp < ((char *)(ptr)+(size)))\
	 {\
	    fprintf ((file), "%02.2X", *cp++ & 0xFF);\
	    if (cp < ((char *)(ptr)+(size)))\
	    {\
	       fprintf ((file), "%02.2X ", *cp++ & 0xFF);\
	    }\
	    else\
	    {\
	       fprintf ((file), "   ");\
	    }\
	 }\
	 else\
	 {\
	    fprintf ((file), "     ");\
	 }\
	 iii += 2;\
      }\
      fprintf ((file), "   ");\
      for (jjj = 0; jjj < 8; jjj++)\
      {\
	 if (tp < ((char *)(ptr)+(size)))\
	 {\
	    if (isprint(*tp))\
	       fprintf ((file), "%c", *tp);\
	    else\
	       fprintf ((file), ".");\
	    tp++;\
	    if (tp < ((char *)(ptr)+(size)))\
	    {\
	       if (isprint(*tp))\
		  fprintf ((file), "%c ", *tp);\
	       else\
		  fprintf ((file), ". ");\
	       tp++;\
	    }\
	    else\
	    {\
	       fprintf ((file), "  ");\
	    }\
	 }\
	 else\
	 {\
	    fprintf ((file), "   ");\
	 }\
      }\
      fprintf ((file), "\n");\
   }\
}

/***********************************************************************
* main
***********************************************************************/

int
main (int argc, char **argv)
{
   FILE *fd;
   char *fname;
   int dskloc;
   int i;
   int j;
   int cyls, sectrk, sectlen;
   int tracklen;
   int cyl;
   int start, end;
   char buf[288];
   
   fname = NULL;
   cyl = 0;
   start = 0;
   end = 0;
   for (i = 1; i < argc; i++)
   {
      switch (i)
      {
      case 1:
         fname = argv[i];
	 break;
      case 2:
         cyl = atoi(argv[i]);
	 break;
      case 3:
         start = atoi(argv[i]);
	 end = start;
	 break;
      case 4:
         end = atoi(argv[i]);
	 break;
      default:
      USAGE:
	 fprintf (stderr,
	    "usage: dumpfpy file [cyl [startsec [endsec]]]\n");
	 exit (1);
      }
   }
   if (fname == NULL) goto USAGE;

   /*
   ** Open the disk image file
   */

   if ((fd = fopen (fname, "rb")) == NULL)
   {
      perror ("Can't open disk file");
      exit (1);
   }

   /*
   ** Setup the disk geometry
   */

   cyls = FPYTRKCYL;
   sectrk = FPYSECTTRK;
   sectlen = FPYSECTLEN;

   tracklen = sectrk * sectlen;

   printf ("FD800 disk geometry:\n");
   printf ("   cyls      = %d\n", cyls);
   printf ("   sectrk    = %d\n", sectrk);
   printf ("   sectlen   = %d\n", sectlen);
   printf ("   tracklen  = %d\n", tracklen);
   printf ("   disk size = %d bytes\n", tracklen * cyls);

   if (cyl >= cyls)
   {
      printf ("Invalid disk cylinder specified, abort\n");
      exit (ABORT);
   }
   if (start >= sectrk)
   {
      printf ("Invalid disk start sector specified, abort\n");
      exit (ABORT);
   }
   if (end >= sectrk)
   {
      printf ("Invalid disk end sector specified, abort\n");
      exit (ABORT);
   }

   for (j = start; j <= end; j++)
   {
      /*
      ** Calculate location
      */

      dskloc = (tracklen * cyl) + (sectlen * j);

#ifdef DEBUG
      printf ("   cyl = %d, sector = %d\n",
	       cyl, start);
      printf ("   dskloc = %d\n", dskloc);
#endif

      /*
      ** Go to the specified location on disk
      */

      if (fseek (fd, dskloc, SEEK_SET) < 0)
      {
	 perror ("seek failed");
	 exit (ABORT);
      }

      /*
      ** Read sector
      */

      for (i = 0; i < sectlen; i++)
	 buf[i] = fgetc (fd);
      /*
      ** Dump it
      */
      printf ("\ncyl %d sect %d dskloc = %d:\n", cyl, j, dskloc);
      HEXDUMP (stdout, buf, sectlen);
   }

   return (NORMAL);
}
