#include "comPort.h"

/* NOTE: This file uses int's where char's should be used,
	 this is because char's don't always work in the FreeSDK */

void InitComPort( int port, int baudRate )
{
	_asm
	{
		di
		ld l,_port(ix)
		ld e,_baudRate+0(ix)
		ld d,_baudRate+1(ix)
		call 0x018C
		ei
	}
}


void CloseComPort()
{
	_asm
	{
		di
		call 0x018F
		ei
	}
}

void SendChar(int ch)
{
	_asm
	{
		di
		ld l,_ch+0(ix)
		call 0x0192
		ei
	}
}

int ReceiveChar()
{
	int inChar;

	inChar = 0;

	_asm
	{
		di
		call 0x0195
		jp nz,nochar
		ld _inChar+0(ix),a
		ld _inChar+1(ix),#0
nochar:
		ei
	}

	return inChar;
}

