#include <avsys.h>
#include "comm.h"

unsigned char title[]="IR Drawing";
char clear[]=" Clear ";
char exit[]=" Exit ";

void ClearScreen(){

	ClearLCD(0);

	InitComm( PORT_IR, BAUD_115200);

	WriteString(10, LCD_HEIGHT-12, clear, DRAW_WHITE);
	WriteString(80, LCD_HEIGHT-12, exit, DRAW_WHITE);

	DrawLine(0,LCD_HEIGHT-15,LCD_WIDTH-1,LCD_HEIGHT-15,DRAW_GRAY);

}

void SendDrawDot(int ptx, int pty)
{
	SendOneByte('D');
	SendOneByte(ptx);
	SendOneByte(pty);	
}

void SendClear()
{
	SendOneByte('C');
}

void ReceiveDraw()
{
	int cmd;
	int recvPenx,recvPeny;

	while((cmd = ReceiveOneByte()) != -1){
		switch (cmd){
		case 'D':
			recvPenx = ReceiveOneByte();
			recvPeny = ReceiveOneByte();

			DrawDot(recvPenx,recvPeny,DRAW_BLACK);
			break;

		case 'C':
			ClearScreen();
			break;
		}
	}
}

int main()
{
	int key;
	unsigned char penx,peny;
	unsigned char lastPenx,lastPeny;

	ClearScreen();

	while(-1){

		key=GetKey(&penx,&peny);

		if(key != PENDOWN && key != 0) break;

		if(key == PENDOWN){
			if (peny > LCD_HEIGHT - 15){		/* pen in button section */
				while(GetKey(&penx,&peny));		/* wait for pen up */
				if (peny > LCD_HEIGHT - 15){	/* if still in button secton, then */
					if (penx < 70) {						/* do action */
						/* Clear Pressed */
						PenBeep();

						SendClear();
						
					} else if (penx > 70) {
						/* Exit pressed */
						break;
					}
				}
			} else {			/* pen in draw section */
				do{					/* keep drawing while pen stays down */
					if(peny < LCD_HEIGHT-15 && (penx != lastPenx || peny != lastPeny)){
						SendDrawDot(penx, peny);

						ReceiveDraw();

						lastPenx = penx;
						lastPeny = peny;
					}
				} while (GetKey(&penx,&peny));
			}
		}
		
		ReceiveDraw();
	}
	PenBeep();

	CloseComm();

	return key;
}
