/* you have to include all those header files
*/

#include "p100plib.h"
#include "ressdk.h"
#include "math.h"
#include "packet.h"
#include "f_sdkapi.h"

#include "sun.h"

/* you have to decleare a static string for the window
  title 
*/

unsigned char test_title[] = "Sun and Moon";

int id=100;

typedef struct _prefs
{	int magic;
	double La,Lo,H,TZ;
} prefs;

prefs Prefs;

#define MAGIC 3414

double La,Lo,H,TZ;

_DATE Date;
_TIME Time;

void dump (double y)
{	static char s[16];
	NumericToStr(y,s,DTREAL);
	MessageBox(MK_FAR_PTR(s),mfOKButton);
}

/* you have to declare the event handlers BANKED and extern
*/

extern BANKED void test_draw (VOID_PTR view);
extern BANKED void test_handle_event (VOID_PTR view,
    unsigned short *evType, unsigned char x, unsigned char y);

/* define the command constants (belongs to a header file)
*/

/* define the main menu structure
*/

#define cmdComputeSun 1000
#define cmdComputeMoon 1001
#define cmdSavePreferences 1002

const MENUITEM MainMenu[] =
{   {"Save Preferences", cmdSavePreferences, 0},
	{"Exit", cmCancel, 0},
    {"\0", 0, 0}
};

/* this is the definition of the drawing routine,
which is inserted for the main window with the
help of the BankedAssign() function.
*/

int TopY,BottomY,TopY1,BottomY1;

char sun[80];
char moon[80];

void drawResults ()
{	FillRect(6,TopY+1,154,BottomY-1,DRAW_WHITE);
	DrawRect(5,TopY,155,BottomY,DRAW_BLACK);
	WriteString(10,TopY+5,sun,0);
	FillRect(6,TopY1+1,154,BottomY1-1,DRAW_WHITE);
	DrawRect(5,TopY1,155,BottomY1,DRAW_BLACK);
	WriteString(10,TopY1+5,moon,0);
}

void test_draw (VOID_PTR view)
{   /* the pointer is really a point to a DESKBOX */
    PDESKBOX *dsk;
    dsk=(PDESKBOX *)view;

    PDESKBOX_draw(view); /* default, clears the view */
	drawResults();
}

/* the event handler for the menu commands and for
 the main window
*/

void appendInt2 (char *p, double x)
{	if (x<10) strcat(p,"0");
	NumericToStr(x,p+strlen(p),DTINTEGER);
}

void appendTime (char *p, double t)
{	double h,m;
	t=mod(t,1);
	h=floor(t*24);
	m=floor((t*24-h)*60);
	appendInt2(p,h);
	strcat(p,":");
	appendInt2(p,m);
}

void compute1 ()
{	double T;
	
	double Set,Rise;

	T=Epoche2000(Date.year+1901,Date.month,Date.day,
		Time.hour,Time.minute,Time.second)/36525.0;

	strcpy(sun,"Please Wait!");
	drawResults();
	Set=computeSun(T,La,Lo,H,1);
	Rise=computeSun(T,La,Lo,H,-1);
	strcpy(sun,"Sun : ");
	if (Rise!=-100)
	{	Rise=Rise/360+TZ/24;
		appendTime(sun,Rise);
	}
	else strcat(sun,"??:??");
	strcat(sun," - ");
	if (Set!=-100)
	{	Set=Set/360+TZ/24;
		appendTime(sun,Set);
	}
	else strcat(sun,"??:??");	
	drawResults();
}

void compute2 ()
{	double T;
	
	double Phase;

	strcpy(moon,"Please Wait!");
	drawResults();

	T=Epoche2000(Date.year+1901,Date.month,Date.day,
		Time.hour,Time.minute,Time.second)/36525.0;

	Phase=computePhase(T);
	strcpy(moon,"Moon Phase : ");

	if (Phase<180)
	{	Phase=floor((1-Phase/180)*100);
		NumericToStr(Phase,moon+strlen(moon),DTINTEGER);
		strcat(moon,"% incr.");
	}
	else if (Phase>=180)
	{	Phase=floor(((Phase-180)/180)*100);
		NumericToStr(Phase,moon+strlen(moon),DTINTEGER);
		strcat(moon,"% decr.");
	}

	drawResults();
}

void savePreferences ()
{	Prefs.magic=MAGIC;
	Prefs.La=La;
	Prefs.Lo=Lo;
	Prefs.H=H;
	Prefs.TZ=TZ;
	dapSavePreference(CurrentAppID,(BYTE *)&Prefs,(WORD)sizeof(prefs));
}

void test_handle_event (VOID_PTR view,
    unsigned short *evType, unsigned char x, unsigned char y)
{   /* convert view to deskbox */
    PDESKBOX *dsk;
    dsk=(PDESKBOX *)view;

    /* call default handler (don't know why) */
    PDESKBOX_handleEvent(view,evType,x,y);

    /* switch events */
    if (*evType==evCommand)
    {   switch (TOWORD(x,y))
        {   case cmdComputeSun :
        		compute1();
        		break;
        	case cmdComputeMoon :
        		compute2();
        		break;
        	case cmdSavePreferences :
        		savePreferences();
        		break;        		
        }
        ClearEvent(evType);
    }
}

PNUMBERFIELD *FLatitude,*FLongitude,*FHorizon,*FTimezone;
PDATEFIELD *FDate;
PTIMEFIELD *FTime;
PTIMEFIELD *FSunset,*FSunrise;
PLABEL *Label;
PBUTTON *FComputeSun,*FComputeMoon;

short main (void)
{

	/* pointer to the main window (properly destroy it at end) */
    PDESKBOX *dsk;
    int y;

	dapReadPreference(CurrentAppID,0,(BYTE *)&Prefs,(WORD)sizeof(prefs));
	
	if (Prefs.magic==MAGIC)
	{	La=Prefs.La;
		Lo=Prefs.Lo;
		H=Prefs.H;
		TZ=Prefs.TZ;
	}
	else
	{	La=50;
		Lo=10;
		H=-0.8333;
		TZ=1;
	}

    /* create a window covering all of the screen
       with a menu, a title and a close box */
    dsk = (PDESKBOX *)CreateDeskBox(id++,0,0,159,239,
        MK_FAR_PTR(test_title),MK_FAR_PTR(MainMenu),0,
        bafClose|bafDotTitle);
    dsk->options &= ~ofFindable; /* no find in this application */

    /* assign the event handlers to this window */
    BankedAssign(dsk->handleEvent,test_handle_event);
    BankedAssign(dsk->draw,test_draw);
    
    y=25;
    
    Label=(PLABEL *)CreateLabel(id++,
  		10, y, 85, y+12,
  		MK_FAR_PTR("Latitude"),
		lbofAlignLeft,PRPFONT11N);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,Label);
    
    FLatitude=(PNUMBERFIELD *)CreateNumberField(id++,
    	80,y,(unsigned char *)(&La),
    	DTREAL,MK_FAR_PTR("Latitude"));
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,FLatitude);

	y+=15;

    Label=(PLABEL *)CreateLabel(id++,
  		10, y, 85, y+12,
  		MK_FAR_PTR("Longitude"),
		lbofAlignLeft,PRPFONT11N);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,Label);
    
    FLongitude=(PNUMBERFIELD *)CreateNumberField(id++,
    	80,y,(unsigned char *)(&Lo),
    	DTREAL,MK_FAR_PTR("Longitude"));
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,FLongitude);
	
	y+=15;
	
    Label=(PLABEL *)CreateLabel(id++,
  		10, y, 85, y+15,
  		MK_FAR_PTR("Date"),
		lbofAlignLeft,PRPFONT11N);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,Label);
	
	GetDate(&Date);
	
    FDate=(PDATEFIELD *)CreateDateField(id++,
    	80,y,(unsigned char *)(&Date),
    	MK_FAR_PTR("Date"));
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,FDate);

	y+=15;
	
    Label=(PLABEL *)CreateLabel(id++,
  		10, y, 85, y+15,
  		MK_FAR_PTR("Time"),
		lbofAlignLeft,PRPFONT11N);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,Label);
	
	GetTime(&Time);
	
    FTime=(PTIMEFIELD *)CreateTimeField(id++,
    	80,y,(unsigned char *)(&Time),
    	MK_FAR_PTR("Time"));
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,FTime);

	y+=15;

    Label=(PLABEL *)CreateLabel(id++,
  		10, y, 85, y+15,
  		MK_FAR_PTR("Horizon"),
		lbofAlignLeft,PRPFONT11N);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,Label);
    
    FHorizon=(PNUMBERFIELD *)CreateNumberField(id++,
    	80,y,(unsigned char *)(&H),
    	DTREAL,MK_FAR_PTR("Horizon"));
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,FHorizon);
	
	y+=15;
	
    Label=(PLABEL *)CreateLabel(id++,
  		10, y, 85, y+15,
  		MK_FAR_PTR("Time Zone"),
		lbofAlignLeft,PRPFONT11N);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,Label);
    
    FTimezone=(PNUMBERFIELD *)CreateNumberField(id++,
    	80,y,(unsigned char *)(&TZ),
    	DTREAL,MK_FAR_PTR("Time Zone"));
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,FTimezone);
	
	y+=15;
	
	TopY=y+5;
	BottomY=y+25;
	
	y+=30;
	
    FComputeSun=(PBUTTON *)CreateButton(id++,
    	30,BottomY+5,130,
    	MK_FAR_PTR("Sunset/Sunrise"),cmdComputeSun,bttBasic);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,FComputeSun);
	
	y+=20;

	TopY1=y+5;
	BottomY1=y+25;
	
	y+=30;
	
    FComputeMoon=(PBUTTON *)CreateButton(id++,
    	30,BottomY1+5,130,
    	MK_FAR_PTR("Moon Phase"),cmdComputeMoon,bttBasic);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,FComputeMoon);

  	strcpy(sun,"");
  	strcpy(moon,"");
	
    /* seems to generate the main event loop */
    ExecView ((PGROUP *) dsk);

    /* destroy the window */
    Destroy ((VOID_PTR) dsk);

    return 0;
}
