
#include <avsys.h>
#include <avdata.h>

unsigned int GetTableCount(void)
{
	return 8;
}

int GetFreeTableID()
{
	int t;
	char tname[18];
	for(t=8;t<16;t++)
	{
		if(ReadTableName(t,tname)==FAIL)
		{
			return FAIL;
		}
		if(!*tname)
		{
			return t;
		}
	}
	return FAIL;
}

extern int _ReadTableName(unsigned char appID, unsigned char *name);

int ReadTableName(unsigned char appID, unsigned char *name)
{
	if((appID<8)||(appID>15))
	{
		return FAIL;
	}
	return _ReadTableName(appID-8,name);
}

int SaveTableName(unsigned char appID, unsigned char *name)
{
	CATEGORY_INFO catinfo;

	if((appID<8)||(appID>15))
	{
		return FAIL;
	}

	appID-=8;

	ReadCategoryInfo(8,&catinfo);
	strncpy(catinfo.cate[appID].name,name,17);
	catinfo.cate[appID].id=appID;
	catinfo.cate[appID].status=STATUS_MODIFY;
	SaveCategoryInfo(8,&catinfo);

	return SUCCESS;
}

extern int _InsertRecord(unsigned char appID,unsigned int recID,void* buffer,unsigned int length,unsigned int reserved);

int InsertRecord(unsigned char appID,unsigned int recID,void* buffer,unsigned int length)
{
	return _InsertRecord(appID,recID,buffer,length,0);
}


extern int _CreateRecord(unsigned char appID,void* buffer,unsigned int length,unsigned int reserved);

int CreateRecord(unsigned char appID,void* buffer,unsigned int length)
{
	return _CreateRecord(appID,buffer,length,0);
}
