
/* written by G. Vermeulen */

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include "io_devices.h"
#include "io_error.h"
#include "tops_pda.h"

char id[256];
int g_bSessOpen=0;
typedef enum
{
	CMD_LIST,
	CMD_DELETE,
	CMD_UPLOAD,
	CMD_REPLACE
} cmd;

TOPS_ReturnValues (_stdcall * TOPS_BeginSession)(int p_port,
                                             IO_DeviceIdType p_device,
                                             char *p_id_string);

TOPS_ReturnValues (_stdcall * TOPS_EndSession)(void);

TOPS_ReturnValues (_stdcall * TOPS_GetTags)(TOPS_TableType p_table_type,
                                         TOPS_Selector  p_selector,
                                         unsigned int  *p_num_of_returned_tags,
                                         TOPS_TagList  *p_returned_tags_ptr);

TOPS_ReturnValues (_stdcall * TOPS_PutTags)(TOPS_TableType p_table_type,
                                           WORD           p_num_tags,
                                           TOPS_TagList  *p_tags_ptr);

TOPS_ReturnValues (_stdcall * TOPS_GetRecord)( TOPS_TableType p_table_type,
                                           TOPS_RecordId  p_record_id,
                                           WORD          *p_returned_rec_status_ptr,
                                           TOPS_Record   *p_returned_rec_ptr);

TOPS_ReturnValues (_stdcall * TOPS_PutRecord)( TOPS_TableType p_table_type,
                                           TOPS_RecordId  p_record_id,
                                           WORD           p_record_status,
                                           TOPS_Record   *p_record_ptr );

TOPS_ReturnValues (_stdcall * TOPS_GetUnexpectedResponse)(
                                    TOPS_ErrorCategory   *p_error_category_ptr,
                                    TOPS_ErrorId         *p_error_id_ptr);

TOPS_ReturnValues (_stdcall * TOPS_PutSysInfo)( TOPS_SysInfoItems      p_item_type,
                                            TOPS_ReadWriteSysInfo *p_item_ptr );

TOPS_ReturnValues (_stdcall * TOPS_GetSysInfo)( TOPS_SysInfoItems  p_item_type,
                                            TOPS_SysInfoParms *p_parameters,
                                            TOPS_SysInfo      *p_item_ptr );

TOPS_ReturnValues (_stdcall * TOPS_PutCommand)(TOPS_CommandType       p_item_type,
                                            TOPS_CommandParameter *p_parm_ptr );

TOPS_ReturnValues (_stdcall * TOPS_SetupCallback)(int (_USERENTRY *p_IO_Callbackfunction)(void));

TOPS_ReturnValues (_stdcall * TOPS_CancelCallback)(void);

void (_stdcall * TOPS_SetupDisconnectWarningCallback)(void (_USERENTRY *p_IO_Callbackfunction)(int));

void (_stdcall * TOPS_CancelDisconnectWarningCallback)(void);

TOPS_CheckCommReturnValues (_stdcall * TOPS_CheckComm)(BYTE p_port,
                                                    IO_DeviceIdType p_device);

void exerr()
{
	if(g_bSessOpen)
	{
		TOPS_EndSession();
	}
	exit(1);
}

void usage()
{
	printf("usage: avapp <-pn|-in> <-l | -dappname | <-u|-r>appfile.app>\n");
	printf(" -pn : use COM port n\n");
	printf(" -in : use IrDA port n\n");
	printf(" -l  : list installed apps\n");
	printf(" -d  : delete app\n");
	printf(" -u  : install app\n");
	printf(" -r  : install or replace app\n");
}

void list_apps()
{
	TOPS_ReturnValues ret;
	WORD returned_rec_status;
	TOPS_Record returned_rec;
	int num_of_returned_tags;
	TOPS_TagType returned_tags[128];
	int t;

	ret=TOPS_GetTags(TOPS_ApplicationRecordTable,TOPS_GetAll,&num_of_returned_tags,(TOPS_TagType (*)[])returned_tags);
	if(ret!=TOPS_Success)
	{
		printf("error: unexpected error.\n");
		exerr();
	}

	printf("AppName                 Version Copyright\n");
	printf("+-----------------------+-------+---------------\n");
	for(t=0;t<num_of_returned_tags;t++)
	{
		char sz[32];
		ret=TOPS_GetRecord(TOPS_ApplicationInfoTable,returned_tags[t].Id,&returned_rec_status,&returned_rec);
		if(ret!=TOPS_Success)
		{
			printf("error: unexpected error.\n");
			exerr();
		}
		if(returned_tags[t].Status!=TOPS_RecordDeleted)
		{
			strncpy(sz,returned_rec.AppInfoTable.Name.Text,returned_rec.AppInfoTable.Name.FieldLength);
			sz[returned_rec.AppInfoTable.Name.FieldLength]=0;
			printf("%-16s\t",sz);

			printf("%d.%d\t",returned_rec.AppInfoTable.Version.Text[0],returned_rec.AppInfoTable.Version.Text[1]);

			strncpy(sz,returned_rec.AppInfoTable.Copyright.Text,returned_rec.AppInfoTable.Copyright.FieldLength);
			sz[returned_rec.AppInfoTable.Copyright.FieldLength]=0;
			printf("%-16s\t",sz);
			printf("\n");
		}
	}
}

int getappid(char* psz)
{
	TOPS_ReturnValues ret;
	WORD returned_rec_status;
	TOPS_Record returned_rec;
	int num_of_returned_tags;
	TOPS_TagType returned_tags[128];
	int t;

	ret=TOPS_GetTags(TOPS_ApplicationRecordTable,TOPS_GetAll,&num_of_returned_tags,(TOPS_TagType (*)[])returned_tags);
	if(ret!=TOPS_Success)
	{
		printf("error: unexpected error.\n");
		exerr();
	}

	for(t=0;t<num_of_returned_tags;t++)
	{
		ret=TOPS_GetRecord(TOPS_ApplicationInfoTable,returned_tags[t].Id,&returned_rec_status,&returned_rec);
		if(ret!=TOPS_Success)
		{
			printf("error: unexpected error.\n");
			exerr();
		}
		if(!strnicmp(returned_rec.AppInfoTable.Name.Text,psz,returned_rec.AppInfoTable.Name.FieldLength))
		{
			return returned_tags[t].Id;
		}
	}

	return -1;
}

void delete_app(char* psz)
{
	TOPS_ReturnValues ret;
	TOPS_TagType tag[1];

	int nAppId=getappid(psz);
	if(nAppId==-1)
	{
		printf("error: app '%s' is not installed.\n",psz);
		exerr();
	}

	tag[0].Id=nAppId;
	tag[0].Status=TOPS_DeleteRecordTag;
	ret=TOPS_PutTags(TOPS_ApplicationRecordTable,1,(TOPS_TagType (*)[])&tag);
	if(ret!=TOPS_Success)
	{
		printf("error: unexpected error.\n");
		exerr();
	}
}

void upload_app(char* psz)
{
	TOPS_ReturnValues ret;
	TOPS_SysInfoParms parms;
	TOPS_SysInfo sysinfo;
	int nAppId;
	HFILE hFile;
	int dwLen;
	char* pBuf;

	hFile=_lopen(psz,OF_READ);
	if(hFile==HFILE_ERROR)
	{
		printf("error: cannot open '%s' for reading.\n",psz);
		exerr();
	}
	dwLen=_llseek(hFile,0,FILE_END);
	_llseek(hFile,0,FILE_BEGIN);
	pBuf=(char*)malloc(dwLen+4);
	_lread(hFile,pBuf+4,dwLen);
	*(int*)pBuf=dwLen;
	_lclose(hFile);

	parms.AppIdParm.TOPS_NewAppSize=pBuf[0x40+4];
	if(1024*pBuf[0x40+4]!=dwLen)
	{
		printf("error: application has wrong size.\n");
		free(pBuf);
		exerr();
	}

	ret=TOPS_GetSysInfo(TOPS_NewApplicationIdItem,&parms,&sysinfo);
	if(ret!=TOPS_Success)
	{
		printf("error: unexpected error (avigo out of memory?).\n");
		free(pBuf);
		exerr();
	}

	nAppId=sysinfo.ReadOnly.NewApplicationId;
	ret=TOPS_PutRecord(TOPS_ApplicationRecordTable,nAppId,TOPS_RecordNew,(TOPS_Record*)pBuf);
	if(ret!=TOPS_Success)
	{
		printf("error: unexpected error.\n");
		free(pBuf);
		exerr();
	}
	free(pBuf);
}

void replace_app(char* psz)
{
	TOPS_SysInfoParms parms;
	int nAppId;
	HFILE hFile;
	int dwLen;
	char* pBuf;
	char pszAppName[32];

	hFile=_lopen(psz,OF_READ);
	if(hFile==HFILE_ERROR)
	{
		printf("error: cannot open '%s' for reading.\n",psz);
		exerr();
	}
	dwLen=_llseek(hFile,0,FILE_END);
	_llseek(hFile,0,FILE_BEGIN);
	pBuf=(char*)malloc(dwLen+4);
	_lread(hFile,pBuf+4,dwLen);
	*(int*)pBuf=dwLen;
	_lclose(hFile);

	parms.AppIdParm.TOPS_NewAppSize=pBuf[0x40+4];
	if(1024*pBuf[0x40+4]!=dwLen)
	{
		printf("error: application has wrong size.\n");
		free(pBuf);
		exerr();
	}

	strncpy(pszAppName,pBuf+0x2c+4,16);
	pszAppName[16]=0;

	nAppId=getappid(pszAppName);
	if(nAppId!=-1)
	{
		delete_app(pszAppName);
	}
	upload_app(psz);
	free(pBuf);
}

int main(int argc,char* argv[])
{
	TOPS_ReturnValues ret;
	int nPort;
	int bComm;
	int bErr=1;
	cmd nCmd;
	char* pszCmdArg;
	HINSTANCE hTopsLib;


	if((argc<3)||(argc>3))
	{
		usage();
		exerr();
	}

	if(argv[1][0]=='-')
	{
		if(argv[1][1]=='p')
		{
			nPort=argv[1][2]-'0';
			bComm=1;
			bErr=0;
			if((nPort<0)||(nPort>4))
			{
				printf("error: bad COM port number.\n");
				exerr();
			}
		}
		if(argv[1][1]=='i')
		{
			nPort=argv[1][2]-'0';
			bComm=0;
			bErr=0;
		}
	}
	if(bErr)
	{
		usage();
		exerr();
	}

	bErr=1;

	if(argv[2][0]=='-')
	{
		if(argv[2][1]=='l')
		{
			nCmd=CMD_LIST;
			bErr=0;
		}
		if(argv[2][1]=='d')
		{
			nCmd=CMD_DELETE;
			pszCmdArg=&(argv[2][2]);
			bErr=0;
		}
		if(argv[2][1]=='u')
		{
			nCmd=CMD_UPLOAD;
			pszCmdArg=&(argv[2][2]);
			bErr=0;
		}
		if(argv[2][1]=='r')
		{
			nCmd=CMD_REPLACE;
			pszCmdArg=&(argv[2][2]);
			bErr=0;
		}
	}
	if(bErr)
	{
		usage();
		exerr();
	}

	hTopsLib=LoadLibrary("tops.dll");
	if(!hTopsLib)
	{
		printf("error: cannot load tops.dll library.\n");
		exerr();
	}

	(FARPROC)TOPS_BeginSession=GetProcAddress(hTopsLib,"TOPS_BeginSession");
	(FARPROC)TOPS_EndSession=GetProcAddress(hTopsLib,"TOPS_EndSession");
	(FARPROC)TOPS_GetTags=GetProcAddress(hTopsLib,"TOPS_GetTags");
	(FARPROC)TOPS_PutTags=GetProcAddress(hTopsLib,"TOPS_PutTags");
	(FARPROC)TOPS_GetRecord=GetProcAddress(hTopsLib,"TOPS_GetRecord");
	(FARPROC)TOPS_PutRecord=GetProcAddress(hTopsLib,"TOPS_PutRecord");
	(FARPROC)TOPS_GetUnexpectedResponse=GetProcAddress(hTopsLib,"TOPS_GetUnexpectedResponse");
	(FARPROC)TOPS_PutSysInfo=GetProcAddress(hTopsLib,"TOPS_PutSysInfo");
	(FARPROC)TOPS_GetSysInfo=GetProcAddress(hTopsLib,"TOPS_GetSysInfo");
	(FARPROC)TOPS_PutCommand=GetProcAddress(hTopsLib,"TOPS_PutCommand");
	(FARPROC)TOPS_SetupCallback=GetProcAddress(hTopsLib,"TOPS_SetupCallback");
	(FARPROC)TOPS_CancelCallback=GetProcAddress(hTopsLib,"TOPS_CancelCallback");
	(FARPROC)TOPS_SetupDisconnectWarningCallback=GetProcAddress(hTopsLib,"TOPS_SetupDisconnectWarningCallback");
	(FARPROC)TOPS_CancelDisconnectWarningCallback=GetProcAddress(hTopsLib,"TOPS_CancelDisconnectWarningCallback");
	(FARPROC)TOPS_CheckComm=GetProcAddress(hTopsLib,"TOPS_CheckComm");

	ret=TOPS_BeginSession(nPort,bComm?IO_ComPort:IO_IRDA,id);
	if(ret!=TOPS_Success)
	{
		ret=TOPS_BeginSession(nPort,bComm?IO_ComPort:IO_IRDA,id);
		if(ret!=TOPS_Success)
		{
			ret=TOPS_BeginSession(nPort,bComm?IO_ComPort:IO_IRDA,id);
			if(ret!=TOPS_Success)
			{
				ret=TOPS_BeginSession(nPort,bComm?IO_ComPort:IO_IRDA,id);
				if(ret!=TOPS_Success)
				{
					ret=TOPS_BeginSession(nPort,bComm?IO_ComPort:IO_IRDA,id);
					if(ret!=TOPS_Success)
					{
						printf("error: connection failed.\n");
						exerr();
					}
				}
			}
		}
	}

	g_bSessOpen=1;

	switch(nCmd)
	{
		case CMD_LIST:
		{
			list_apps();
		} break;
		case CMD_DELETE:
		{
			delete_app(pszCmdArg);
		} break;
		case CMD_UPLOAD:
		{
			upload_app(pszCmdArg);
		} break;
		case CMD_REPLACE:
		{
			replace_app(pszCmdArg);
		} break;
	}

	ret=TOPS_EndSession();

	return 0;
}
