
#ifndef AVSYS_H_
#define AVSYS_H_

extern unsigned char _BankNo;
extern unsigned int _StartRomBank;

#define AssignBankNo(sym,dst)\
_asm{\
 jr .+5::\
 .db .BANKNO.::\
 .dw _##sym::\
 ld a,(.-3)::\
 ld (__BankNo),a}\
dst=_BankNo+_StartRomBank;

extern int BankedFunctionCall(int (*f)(),unsigned int b,...);

#define TRUE             1
#define FALSE            0
#define SET		 2
#define GET              0xff

#define LCD_WIDTH        160
#define LCD_HIGH         240
#define LCD_HEIGHT       LCD_HIGH

#define PUT              0
#define OR               1
#define XOR              2
#define NOT		 0x10

#define DRAW_BLACK       0
#define DRAW_GRAY        1
#define DRAW_WHITE       2
#define DRAW_DASH        3
#define DRAW_B3DOT       4
#define DRAW_W3DOT       5
#define DRAW_B2DOT       6
#define DRAW_W2DOT       7
#define DRAW_B1DOT       8
#define DRAW_XOR         0x80
#define VIRTTOREAL       0
#define REALTOVIRT       1

#define ALIGN_LEFT       1
#define ALIGN_RIGHT      2

#define PENDOWN          0xff

#define PRPFONT11N       0
#define PRPFONT11B       1
#define PRPFONT14N       2
#define PRPFONT14B       3
#define PRPFONT7N        4

#define POWER           0x01
#define ADDRESS         0x02
#define SCHEDULE        0x03
#define TASK            0x04
#define MEMO            0x05
#define PGUP            0x06
#define PGDN            0x07
#define CALENDAR        0x08
#define EXPENSES        0x09
#define CALCULATOR      0x0a
#define TABLE           0x0b
#define APPLICATION     0x0c
#define FIND            0x0d
#define BACK_LIGHT      0x0e
#define PC_LINK_KEY     0x0f

#define ENGLISH  0
#define GERMAN   1
#define FRENCH   2
#define ITALIAN  3
#define SPANISH  4

#define SEEK_SET 0
#define SEEK_CUR 1

typedef struct tagDATE
{
	unsigned char year;
	unsigned char month;
	unsigned char day;
} _DATE;

typedef struct tagTIME
{
	unsigned char hour;
	unsigned char minute;
	unsigned char second;
} _TIME;

typedef struct{
   long StartAddress;
   long Offset;
} _HANDLE;

#define cmQuit           0x0002
#define cmOK             0x0003
#define cmCancel         0x0004
#define cmYes            0x0005
#define cmNo             0x0006
#define cmSave           0x0007
#define cmRedraw         0x0008

#define mfWarning        0x0000
#define mfInformation    0x0002
#define mfYesButton      0x0100
#define mfNoButton       0x0200
#define mfOKButton       0x0400
#define mfCancelButton   0x0800
#define mfOKCancel       (mfOKButton | mfCancelButton)
#define mfYesNo          (mfYesButton | mfNoButton)
#define mfYesNoCancel    (mfYesButton | mfNoButton | mfCancelButton)

extern char *strstr(char *s1, char *s2);
extern short strcmp(unsigned char *s1, unsigned char*s2);
extern short strcmpi(unsigned char *s1, unsigned char *s2);
extern short stricmp(unsigned char *s1, unsigned char *s2);
extern short strncmp(unsigned char *s1, unsigned char *s2, unsigned short maxlen);
extern short strncmpi(unsigned char *s1, unsigned char *s2, unsigned short maxlen);
extern short strnicmp(unsigned char *s1, unsigned char *s2, unsigned short maxlen);
extern char *strcat(unsigned char *s1, unsigned char *s2);
extern char *strncat(unsigned char *s1, unsigned char *s2, unsigned short maxlen);
extern char *strncpy(unsigned char *s1, unsigned char *s2, unsigned short maxlen);
extern char *strcpy(unsigned char *s1, unsigned char *s2);
extern short strlen(unsigned char* s1);
int memcmp(void* buf1,void* buf2,unsigned int len);
void *memcpy(void* dest,void* src,unsigned int len);
void memset(void* buf,int c,unsigned int len);
extern unsigned char open_file(_HANDLE *_handle, unsigned short index);
extern void read_file(_HANDLE *_handle, unsigned char *buffer, unsigned short count);
extern void lseek_file(_HANDLE *_handle, long offset, short fromwhere);
extern void close_file(_HANDLE *_handle);
extern void randomize();
extern int random(int num);
extern char* itoa(int value,char *string,int radix );
extern int atoi(char* str);

extern void SetDisplayDirection(unsigned char direction);
extern unsigned char GetDisplayDirection();
extern void SetDotSize(unsigned char size);
extern unsigned char GetDotSize();
extern void DrawDot(unsigned char x, unsigned char y, unsigned char attr);
extern void SetLineSize(unsigned char lineSize);
extern unsigned char GetLineSize();
extern void DrawLine(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2, unsigned char attr);
extern void DrawRect(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2, unsigned char attr);
extern void FillRect(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2, unsigned char attr);
extern void DrawCircle(unsigned char centerX , unsigned char centerY , unsigned char radius, unsigned char attr);
extern void FillCircle(unsigned char centerX , unsigned char centerY , unsigned char radius, unsigned char attr);
extern void ClearLCD(unsigned char type);
extern void ClearLCDArea(unsigned char x1,unsigned char y1,unsigned char x2,unsigned char y2,unsigned char op);
extern void InverseLCDArea(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2);
extern void GrayLCDArea(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2);
extern void BackupWindow(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2, unsigned char *buffer);
extern void RestoreWindow(unsigned char x, unsigned char y, unsigned char *buffer, unsigned char operate);
extern void SetToVirtualLCD(unsigned char mode);
extern void SetToRealLCD(unsigned char mode);
extern void SwapLCD(unsigned short x1y1, unsigned short x2y2, unsigned short w_h, unsigned char op, unsigned char mode);
extern void LCDCopy(unsigned char mode);
extern unsigned char GetActiveLCDType();
extern void DrawIcon(unsigned char x, unsigned char y, unsigned short index, unsigned char style);
extern void GetTime(_TIME *time);
extern void GetDate(_DATE *date);
extern unsigned short GetBatteryValue(unsigned char batteryType);
extern void SetDrawArea(unsigned short x1y1, unsigned short x2y2);
extern void PenBeep();
extern void WarningBeep();
extern void ClearKeyBuffer();
extern void SetAutoPowerOff(unsigned char parm, unsigned char value);
extern void SetFontType(unsigned char fontType);
extern unsigned char GetFontType();
extern unsigned char WriteChar(unsigned char x, unsigned char y, unsigned char ch, unsigned char attr);
extern unsigned char WriteString(unsigned char x, unsigned char y, unsigned char *str, unsigned char attr);
extern unsigned char WriteAlignString(unsigned char x, unsigned char y, unsigned char *str, unsigned char lengthLimit, unsigned char mode, unsigned char attr);
extern unsigned char GetLanguageType();
extern short GetStringLength(unsigned char *str, unsigned char fontType);

extern int GetRamBank();
extern void SetRamBank(int bank);
extern int GetKey(unsigned char* penx,unsigned char* peny);
extern void Delay_10ms();
extern void Buzzer(int note,int duration);

extern double sqrt(double d);
extern double dabs(double d);
extern double dint(double d);
extern int dtoa(double d,char* str);
extern double atod(char* str);

void DisableInterrupts();
void EnableInterrupts();

extern unsigned short MessageBox(unsigned char* message, unsigned short option);
extern int MemoryErrorMessageBox(void);
extern void GetAvigoVersion(unsigned char *str);

#endif
