/********************************************************
 * 
 * Title: Kralj
 *
 * Author: Jurica Jurjevic
 *
 * Timestamp: 2000/01/25 22:17:32
 *
 *
 * This is the haeder file for the chess program kralj
 *
 ********************************************************/

#ifndef _kralj_h
#define _kralj_h

#include "game.h"

/********************************************************
 * Basic boolean definitions - I know they are defined
 * nearly everywhere
 ********************************************************/
#define FALSE 0
#define TRUE 1
 
/********************************************************
 * Board direction
 ********************************************************/
#define WHITE_TOP 1
#define WHITE_BOTTOM -1

/********************************************************
 * Whoes moving next
 ********************************************************/
#define NO_PLAYER 0
#define WHITE_PLAYER_NEXT 1
#define BLACK_PLAYER_NEXT 2

/********************************************************
 * Square modes
 ********************************************************/
#define NORMAL 0
#define SELECTED 1

/********************************************************
 * The maximum of figures that fit on the board
 ********************************************************/
#define COL_A 0
#define COL_B 1
#define COL_C 2
#define COL_D 3
#define COL_E 4
#define COL_F 5
#define COL_G 6
#define COL_H 7

#define ROW_1 7
#define ROW_2 6
#define ROW_3 5
#define ROW_4 4
#define ROW_5 3
#define ROW_6 2
#define ROW_7 1
#define ROW_8 0

/********************************************************
 * The rows and field of the chessboard
 ********************************************************/
#define MAX_FIGURES 32

/********************************************************
 * Figures
 ********************************************************/
#define NONE 0

#define PAWNS 1
#define BISHOPS 2
#define KNIGHTS 3
#define ROOKS 4
#define QUEENS 5
#define KINGS 6

#define WHITE_FIGURES 10

#define WHITE_PAWN 11
#define WHITE_BISHOP 12
#define WHITE_KNIGHT 13
#define WHITE_ROOK 14
#define WHITE_QUEEN 15
#define WHITE_KING 16

#define BLACK_FIGURES 20

#define BLACK_PAWN 21
#define BLACK_BISHOP 22
#define BLACK_KNIGHT 23
#define BLACK_ROOK 24
#define BLACK_QUEEN 25
#define BLACK_KING 26

/* 
===============================================================================
 Now definig some basic structs
=============================================================================== 
*/

/********************************************************
 * This defines a point - Virtual or Real
 ********************************************************/
typedef struct point
{
	int x; /* The x coordinate */
	int y; /* The y coordinate */
} Point;

/********************************************************
 * This defines a point - Virtual or Real
 ********************************************************/
typedef struct figure
{
	Point pos; /* The position of the sprite */
	unsigned int type; /* The type of the figure */
} Figure;



/********************************************************
 * This is one of 64 fields of the chessboard
 ********************************************************/
typedef struct field
{ 
	Point pos; /* The horizontal and vertical position (internal from 0 to 7) */
	Figure figure; /* See figure struct above */
	Point offset; /* The horizontal and vertical offset to the selected point */	
	unsigned char selected; /* TRUE if is selected, otherwise FALSE */	
} Field;


/********************************************************
 * Player information
 ********************************************************/
typedef struct player
{
	char* name; /* The name of the player */
	unsigned int time; /* The time he needed for his moves */
	unsigned char selectable; /* Player should select? TRUE or FLASE */	
} Player;


/********************************************************
 * Both players
 ********************************************************/
typedef struct players
{
	Player black; /* Black player */
	Player white; /* White player */
	unsigned char nextplayer; /* Who plays next */
} Players;


/********************************************************
 * The complete chessboard
 ********************************************************/
typedef struct chessboard
{
	/*
	 * The chessboard is represented with chars only to save
	 * memory. Black starts at top ( 0 and 1 row )
	 */
	unsigned char board[8][8];

	/*
	 * Captured figures
	 */
	unsigned char captured[MAX_FIGURES];

	/*
	 * The selected field position 
	 */
	Field selected_field;

	/*
	 * The destination field of a move
	 */
	Field destination_field;

	/*
	 * Both players are in that struct
	 */
	Players players;

	/*
	 * Orientation white on top or bottom
	 */
	int orientation;/* = WHITE_BOTTOM;*/

	/*
	 * The board position and the width of the board
	 * Remember same widths on a square
	 */
	unsigned char top;/*=30;*/
	unsigned char left;/*_left=10;*/	


} Chessboard;


/********************************************************
 * The complete chessboard
 ********************************************************/
typedef struct options
{
	/*
	 * Should we animate some graphics?
	 */
	unsigned char animation_speed;

	/*
	 * The clock ticks every second
	 */
	unsigned char ticks;

	/*
	 * Beep on moves
	 */
	unsigned char beep;

	/*
	 * Show last move
	 */
	unsigned char show_last_move;


} Options;



/********************************************************
 * The global game data
 ********************************************************/
typedef struct game
{
	/*
	 * The chessboard of the game
	 */
	Chessboard chessboard;

	/*
	 * The game options
	 */
	Options options;

	/*
	 * The game type
	 */
	GameType gametype;

	/*
	 * TRUE if the game is started
	 */
	unsigned char game_started;

} Game;

/* 
===============================================================================
 Some global variables that are used in other places too
=============================================================================== 
*/


/********************************************************
 * The global game data reference extern
 ********************************************************/
extern Game game;


#endif