/********************************************************
 * 
 * Title: Kralj
 *
 * Module: Opening
 *
 * Type: Header
 *
 * Author: Jurica Jurjevic
 *
 * Timestamp: 2000/02/25 22:33:41
 *
 *
 * The opening book for the chess engine
 *
 ********************************************************/

#ifndef _opening_h
#define _opening_h

/********************************************************
 * A board position
 ********************************************************/
typedef struct boardpos
{
	unsigned char x;
	unsigned char y;
} BoardPos;

/********************************************************
 * The move of
 ********************************************************/
typedef struct boardmove
{
	BoardPos from;
	BoardPos to;
} BoardMove;


/********************************************************
 * The type of the opening move
 ********************************************************/
typedef struct openingmove
{

	char *name;

	BoardMove white;
	BoardMove black;

	struct openingmove *nextOpening;
	struct openingmove *nextMove;

} OpeningMove;

#endif