
#include <avsys.h>
#include <avdata.h>

void ShowMemoTitle(int nMemo)
{
	FIELD_INFO fi;
	char title[64];
	int fieldcount;
	int titlefield=-1;
	int titleoffset,maxtitlesize;
	int t;

	WriteString(0,0,"memo's loaded (first 10):",DRAW_BLACK);

	/* fetch memo field record info */
	fieldcount=ReadFieldInfo(TYPE_MEMO,&fi);

	/* find title field */
	for(t=0;t<fieldcount;t++)
	{
		if(!stricmp(fi.field[t].name,"title"))
		{
			titlefield=t;
			/* get max size of memo title (==258 bytes, not used in this example) */
			maxtitlesize=GetDataSize(fi.field[t].dataType);
			break;
		}
	}

	if(titlefield==-1)
	{
		/* should never happen! */
		return;
	}

	/* read title field offset */
	ReadRecord(TYPE_MEMO,nMemo,sizeof(PIMHEAD)+titlefield*sizeof(RECHEAD),&titleoffset,2);
	/* read first 63 chars of title */
	ReadRecord(TYPE_MEMO,nMemo,titleoffset,title,63);
	/* write title to LCD */
	WriteString(0,20+nMemo*10,title,DRAW_BLACK);
}

int ShowMemoTitles()
{
	unsigned int memocount,alivememocount;
	int t;

	/* get number of memo's */
	GetRecordCount(TYPE_MEMO,&memocount,&alivememocount);

	/* only show first 10 */
	if(alivememocount>10)
	{
		alivememocount=10;
	}

	for(t=0;t<alivememocount;t++)
	{
		ShowMemoTitle(t);
	}

	return alivememocount;
}

void ShowMemoData(int nMemo)
{
	FIELD_INFO fi;
	char memo[64];
	int fieldcount;
	int memofield=-1;
	int memooffset,maxmemosize;
	int t,x;

	WriteString(0,140,"memo data (first line):",DRAW_BLACK);

	/* fetch memo field record info */
	fieldcount=ReadFieldInfo(TYPE_MEMO,&fi);

	/* find title field */
	for(t=0;t<fieldcount;t++)
	{
		if(!stricmp(fi.field[t].name,"memo"))
		{
			memofield=t;
			/* get max size of memo ( == 3.5K, not used in this example) */
			maxmemosize=GetDataSize(fi.field[t].dataType);
			break;
		}
	}

	if(memofield==-1)
	{
		/* should never happen! */
		return;
	}

	/* read memo field offset */
	ReadRecord(TYPE_MEMO,nMemo,sizeof(PIMHEAD)+memofield*sizeof(RECHEAD),&memooffset,2);
	/* read first 63 chars of memo */
	ReadRecord(TYPE_MEMO,nMemo,memooffset,memo,63);
	/* write first line or 63 chars to LCD */
	x=0;
	for(t=0;t<63;t++)
	{
		if(memo[t]<32)
		{
			break;
		}
		x=WriteChar(x,160,memo[t],DRAW_BLACK);
	}
}

int main()
{
	int key;
	unsigned char penx,peny;

	ClearLCD(0);
	SetFontType(PRPFONT11B);

	LoadIndexTable(TYPE_MEMO);

	if(ShowMemoTitles())
	{
		ShowMemoData(0);
	}
	else
	{
		WriteString(0,0,"No memos loaded!",DRAW_BLACK);
	}

	while(!(key=GetKey(&penx,&peny)));
	PenBeep();

	return key;
}
