
#include <avsys.h>
#include <avdata.h>
#include "mktable.h"
#include "wrrec.h"

#define NUMFIELDS 5

void WriteRecord(int tableid,int private,char* name,char* address,char* telephone,int id)
{
	char recbuf[1024];
	PIMHEAD* pPIMHead=(PIMHEAD*)recbuf;
	RECHEAD* pRECHead=(RECHEAD*)(recbuf+sizeof(PIMHEAD));
	char* pFieldPtr=(char*)pRECHead+NUMFIELDS*sizeof(RECHEAD);
	char* pField0;
	char* pField1;
	char* pField2;
	char* pField3;
	char* pField4;

	pField0=pFieldPtr;
	pFieldPtr+=0; /* private is a bit in PIMHead! */
	pField1=pFieldPtr;
	pFieldPtr+=strlen(name)+1;
	pField2=pFieldPtr;
	pFieldPtr+=strlen(address)+1;
	pField3=pFieldPtr;
	pFieldPtr+=strlen(telephone)+1;
	pField4=pFieldPtr;
	pFieldPtr+=sizeof(double); /* integers are stored as double! */

	memset(pPIMHead,0,sizeof(PIMHEAD));
	pPIMHead->typeID=tableid;
	pPIMHead->option|=private?4:0;
	pPIMHead->fieldCount=NUMFIELDS;
	pPIMHead->recLength=pFieldPtr-recbuf;
	pPIMHead->synKeyOffset=pFieldPtr-recbuf;

	pRECHead[0].offset=pField0-recbuf;
	pRECHead[1].offset=pField1-recbuf;
	pRECHead[2].offset=pField2-recbuf;
	pRECHead[3].offset=pField3-recbuf;
	pRECHead[4].offset=pField4-recbuf;

	strcpy(pField1,name);
	strcpy(pField2,address);
	strcpy(pField3,telephone);
	*(double*)pField4=(double)id;

	/* no error checking */
	AllocPIMRecordSpace(tableid,pPIMHead->recLength);
	CreateRecord(tableid,recbuf,pPIMHead->recLength);
}

