#include <avsys.h>
#include <comm.h>

void InitComm(int mode,int baud)
{
_asm
{
	di
	ld l,_mode(ix)
	ld e,_baud+0(ix)
	ld d,_baud+1(ix)
	call 0x018C
	ei
}
}

void CloseComm()
{
_asm
{
	di
	call 0x018F
	ei
}
}

int ReceiveOneByte()
{
_asm
{
	di
	call 0x0195
	jp nz,.nch
	ld l,a
	ld h,#0
	jr .rch
.nch:
	ld l,#0xff
	ld h,#0xff
.rch:
	ei
}
}

void SendOneByte(int byte)
{
_asm
{
	di
	ld l,_byte+0(ix)
	call 0x0192
	ei
}
}

void EnableCommAutoWakeup()
{
_asm
{
	di
	ld a,(0xc04b)
	and a,#0xfe
	ld (0xc04b),a
	ei
}
}

void DisableCommAutoWakeup()
{
_asm
{
	di
	ld a,(0xc04b)
	or a,#0x1
	ld (0xc04b),a
	ei
}
}
