	.module	startup

	.globl	_main

	.include "syscall.asm"
	.include "datacall.asm"

	.globl	GetRomBank
	.globl	GetRamBank
	.globl	SetRomBank
	.globl	SetRamBank
	.globl	mult_int
	.globl	uns_mult_int
	.globl	div_int
	.globl	uns_div_int
	.globl	mod_int
	.globl	uns_mod_int
	.globl	oper1_double_to_int
	.globl	exts_oper1_int_to_double
	.globl	uns_oper1_int_to_double
	.globl	add_double
	.globl	sub_double
	.globl	mult_double
	.globl	div_double
	.globl	cmp_double

	.area	_code

	jp		startup

	.ds		16				;copyright
	.ds		16				;dev kit
	.db		0xff				;app
	.db		0x00,0x0			;checksum
	.db		0x61,0x01,0x12			;yy/mm/dd
	.db		0x0d,0x20,0x38			;hh/mm/ss
	.ds		16				;prog name
	.db		0x01,0x00			;version
	.db		0x10,0x00			;ram size
	.db		0x00,0x00			;rom size
	.db		0xc3,0xc3			;flash
	.db		0x34,0x32			;icon 52x50
	.db		0x00				;compress icon
	.ds		7*50				;icon data

	.db		0xff,0xff,0xff,0xff
	.db		0xff,0xff,0xff,0xff
	.db		0xff,0xff,0xff,0xff
	.db		0xff,0xff,0xff,0xff

startup:
	call	GetRomBank
	push	hl
	ld		hl,#.RAMSTART.
	ld		de,#copyram-0x8000
	add		hl,de
	push	hl
	call	GetRomBank
	ld		de,#.RAMBANK.
	add		hl,de
	jp		SetRomBank

	.globl	adjustsp
	.globl	moveaddrtostack
	.globl	moveoffsttostack
	.globl	movestacktoaddr
	.globl	movestacktooffst
	.globl	comparedouble

adjustsp:
	push	de
	exx
	pop		de
	pop		hl
	ld		(retaddr),hl
	pop		hl
	ld		(retbank),hl
	pop		hl
	ld		(retfunc),hl
	ex		de,hl
	add		hl,sp
	ld		sp,hl
	ld		hl,(retfunc)
	push	hl
	ld		hl,(retbank)
	push	hl
	ld		hl,(retaddr)
	push	hl
	exx
	ret

moveaddrtostack:
	push	de
	push	bc
	exx
	pop		bc
	pop		de
	ld		hl,#0x6
	add		hl,sp
	ex		de,hl
	ldir
	exx
	ret

moveoffsttostack:
	push	de
	push	bc
	exx
	pop		bc
	pop		de
	push	ix
	pop		hl
	add		hl,de
	ex		de,hl
	ld		hl,#0x6
	add		hl,sp
	ex		de,hl
	ldir
	exx
	ret

movestacktoaddr:
	push	de
	push	bc
	exx
	pop		bc
	pop		de
	ld		hl,#0x6
	add		hl,sp
	ldir
	exx
	ret

movestacktooffst:
	push	de
	push	bc
	exx
	pop		bc
	pop		de
	push	ix
	pop		hl
	add		hl,de
	ex		de,hl
	ld		hl,#0x6
	add		hl,sp
	ldir
	exx
	ret

comparedouble:
	exx
	pop		hl
	ld		(retaddr),hl
	pop		hl
	ld		(retbank),hl
	pop		hl
	ld		(retfunc),hl
	ld		hl,#0x0
	add		hl,sp
	ex		de,hl
	ld		hl,#0x8
	add		hl,de
	ld		iy,#0x10
	add		iy,sp
	push	iy
	call	cmp_double
	pop		iy
	ld		sp,iy
	ld		hl,(retfunc)
	push	hl
	ld		hl,(retbank)
	push	hl
	ld		hl,(retaddr)
	push	hl
	exx
	ret

	.area	_data

	.globl	copyram
copyram:
	ld		hl,#.RAMSTART.
	ld		de,#0x8000
	ld		bc,#.RAMSIZE.
	ldir
	pop		hl
	ld		(__StartRomBank),hl
	ld		bc,#GetProgramId
	call	banked_function_call
	ld		(_CurrentAppID),a
	call	bankedcall
	.db		.BANKNO.
	.dw		_main
	ret

	.globl	bankedcall
bankedcall:
	exx
	pop		hl
	ld		e,(hl)
	ld		d,#0
	inc		hl
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	inc		hl
	push	hl
	call	GetRomBank
	push	hl
	ld		hl,(__StartRomBank)
	add		hl,de
	call	SetRomBank
	ld		hl,#bankedret
	push	hl
	push	bc
	exx
	ret

	.globl	bankedret
bankedret:
	ex		de,hl
	pop		hl
	call	SetRomBank
	ex		de,hl
	ret

	.globl	_BankedFunctionCall
_BankedFunctionCall:
	pop		bc ;bankedret
	pop		de ;bank
	pop		hl ;retaddr
	pop		bc ;funcptr
	exx
	pop		hl ;bank
	call	SetRomBank
	exx
	push	hl
	push	de
	ld		hl,#BankedFunctionCallRet
	push	hl
	push	bc
	ret
BankedFunctionCallRet:
	ex		de,hl
	pop		hl
	call	SetRomBank
	pop		hl
	push	bc
	push	bc
	push	hl
	ex		de,hl
	ret

	.globl	_CurrentAppID
_CurrentAppID:
	.db		0

	.globl	__StartRomBank
__StartRomBank:
	.dw		0

	.globl	__BankNo
__BankNo:
	.db		0

	.globl	retaddr
retaddr:
	.dw		0

	.globl	retbank
retbank:
	.dw		0

	.globl	retfunc
retfunc:
	.dw		0
