
#include <avsys.h>
#include "fmem.h"



void fmemcpy(unsigned char* dest, unsigned char* src, unsigned short uiBank, unsigned short n)
/*
    Function
      Copies 'n' bytes of banked data from 'src' in ROM-bank 'uiBank' to 'dest'.

    Parameters 
      dest   The pointer of destination string.
      src    The address of source string in bank 'uiBank'.
      uiBank The Bank, where the source string resides.
      n      The bytes count to copy. 

    Return Value
      None.

    Example
      fmemcpy(dest, src, bank, 100);
*/
{
     _asm
     {
          ld    l, _dest+0(ix)
          ld    h, _dest+1(ix)  /* destination-address in HL */
          ld    e, _uiBank+0(ix)
          ld    d, _uiBank+1(ix) 
          push  de              /* source bank on stack */
          ld    e, _src+0(ix)
          ld    d, _src+1(ix)   
          push  de              /* source-address on Stack */
          ld    e, _n+0(ix)
          ld    d, _n+1(ix)     /* number of bytes in DE */
          call  _fmemcpy        /* FarMemCopy. */
          pop   de              /* clean up stack */
          pop   de              /* clean up stack */
     }
}

char *fstrcpy(unsigned char* dest, unsigned char* src, unsigned short uiBank)
/*
    Function
      Copies banked string src in ROM-bank uiBank to dest.

    Parameters 
      dest   Pointer of the destination string.
      src    The address of source string in bank 'uiBank'.
      uiBank The Bank, where the source string resides.

    Return Value  
      Pointer of destination string.

    Example
      fstrcpy(string1, string2);

*/
{
     _asm
     {
          ld    l, _dest+0(ix)
          ld    h, _dest+1(ix)  /* destination-address in HL */
          ld    e, _uiBank+0(ix)
          ld    d, _uiBank+1(ix) 
          push  de              /* source bank on stack */
          ld    e, _src+0(ix)
          ld    d, _src+1(ix)   
          push  de              /* source-address on Stack */
          call  _fstrcpy        /* FarStrCopy. */
          pop   de              /* clean up stack */
          pop   de              /* clean up stack */
     }
}
