
#include <avsys.h>
#include "fmem.h"

char *GetSystemString(char* dest, unsigned int uiTextID);

int main()
{
    int key;
    unsigned char penx,peny;
    char message[256];
    int iTextNo;
    char buf[10];
    SetDisplayDirection(0);

    iTextNo = 0;
    key = PGUP;
    while(key == PGUP || key == PGDN)
    {
      if(key==PGUP)
        iTextNo++;
      if(key==PGDN)
        iTextNo--;

      GetSystemString(message,iTextNo);

      ClearLCD(0);
      itoa(iTextNo,buf,10);

      SetFontType(PRPFONT7N);
      WriteString(5,40,"MessageNumber",DRAW_BLACK);
      WriteString(5,70,"MessageText",DRAW_BLACK);

      SetFontType(PRPFONT11N);
      WriteString(5,50,buf,DRAW_BLACK);
      WriteString(5,80,message,DRAW_BLACK);
 
      while(!(key=GetKey(&penx,&peny)));
      PenBeep();
  }

    SetDisplayDirection(0);

    return key;
}


char *GetSystemString(char* dest, unsigned int uiTextID)
{
  unsigned int offset;

  uiTextID--;
  uiTextID *= 4;
  uiTextID += 0x5000;  /* 0x4000 Bank-Base + 0x1000 Offset */

  fmemcpy((unsigned char*)&offset, (unsigned char*)uiTextID, TEXTINDEXBANK, 2);
  if(offset != 0xFFFF)
    fstrcpy(dest, (unsigned char*)offset, TEXTBANK);
  else
    strcpy(dest, "");
  return dest;
}
