
#include <avsys.h>

/*

  Floating point number test...
  It's soooooooo sloooooooooooooowwwwwwwwww......... :-{

  written by Gerard Vermeulen

*/

#define PI 3.1415926536

double cos(double x)
{
	double x2,x4,x6,x8,x10;
	int q=0;

	x=dabs(x);

	x=x-((int)(x/(2*PI)))*(2*PI); /* make 0<x<2*PI */
	q=x/(PI/2); /* calc quadrant */

	/* adjust for quadrant */
	switch(q)
	{
		case 1:
		{
			x=PI-x;
		} break;
		case 2:
		{
			x=x-PI;
		} break;
		case 3:
		{
			x=2*PI-x;
		} break;
	}

	x2=x*x;
	x4=x2*x2;
	x6=x4*x2;
	x8=x4*x4;
	x10=x8*x2;
	
	x=((((1-x2/2.0)+x4/24.0)-x6/720.0)+x8/40320.0)-x10/3628800.0; /* Taylor */

	/* adjust for quadrant */
	switch(q)
	{
		case 0:
		case 3:
		{
			return x;
		} break;
		case 1:
		case 2:
		{
			return -x;
		} break;
	}
}

double sin(double x)
{
	return cos(x-PI/2);
}

void circle(double x,double y,double r)
{
	double rho=-PI*8;
	int t;
	
	/* draw a 40 point circle */
	for(t=0;t<40;t++)
	{
		DrawDot(x+r*cos(rho),y+r*sin(rho),DRAW_BLACK);
		rho+=2*PI+(2*PI)/40; /* also do some range testing on the cos & sin functions */
	}
}

void convtest()
{
	double a;
	char buf[32];
	strcpy(buf,"2550.5");
	WriteString(0,10,"a=",DRAW_BLACK);
	WriteString(40,10,buf,DRAW_BLACK);
	a=atod(buf);
	a=sqrt(a);
	dtoa(a,buf);
	WriteString(0,20,"sqrt=",DRAW_BLACK);
	WriteString(40,20,buf,DRAW_BLACK);
	DrawDot(100,100,DRAW_BLACK);
	DrawDot(a,a,DRAW_BLACK);
}

int main()
{
	int key;
	unsigned char penx,peny;
	char dsize=GetDotSize();

	ClearLCD(0);
	SetDotSize(3);
	convtest();
	circle(80,120,50);

	while(!(key=GetKey(&penx,&peny)));
	PenBeep();
	while(GetKey(&penx,&peny));

	SetDotSize(dsize);

	return APPLICATION;
}

