/*
 * Vexed v1.4 - gfx.c "The graphical functions for Vexed"
 * Copyright (C) 1999 James McCombe (cybertube@earthling.net)
 *
 * Adaptation for the Avigo
 * Copyright (C) 2001 Jean-michel Bunouf (jeanmichel.bunouf@oreka.com)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */

#include <avsys.h>
#include <avdata.h>
#include <avgui.h>

#include "protos.h"

extern unsigned int block1, block2, block3, block4, block5, block6, block7, block8, block9;

extern struct BitmapPtr {
  unsigned int bank;
  unsigned int *image;
} Bitmap [10];

extern int current [9] [11];
extern int BlocksRemaining;

extern struct {
 Boolean
  PieceMoveAnim, /* whether the movement of a piece by the user is animated */
  GravityAnim, /* whether the gravity effect is animated */
  EliminationAnim, /* whether piece elimination is animated */
  Sound; /* whether sound is on or off */
 int CurrentLevel, SolvedLevels; /* stores the level the user was last at */
} VexedPreferences;

void LoadBitmapResources()
{
  AssignBankNo(block1, Bitmap[1].bank);
  Bitmap[1].image=&block1;
  AssignBankNo(block2, Bitmap[2].bank);
  Bitmap[2].image=&block2;
  AssignBankNo(block3, Bitmap[3].bank);
  Bitmap[3].image=&block3;
  AssignBankNo(block4, Bitmap[4].bank);
  Bitmap[4].image=&block4;
  AssignBankNo(block5, Bitmap[5].bank);
  Bitmap[5].image=&block5;
  AssignBankNo(block6, Bitmap[6].bank);
  Bitmap[6].image=&block6;
  AssignBankNo(block7, Bitmap[7].bank);
  Bitmap[7].image=&block7;
  AssignBankNo(block8, Bitmap[8].bank);
  Bitmap[8].image=&block8;
  AssignBankNo(block9, Bitmap[9].bank);
  Bitmap[9].image=&block9;
}


void DrawBlinds()
{
int i, x;
for (i = 0; i <= 16; i ++)
 {
 for (x = 0; x <= 144; x += 16)
  {
  ClearLCDArea(x,16,x+i-1,143,0);
  }
 Delay_10ms();
 }
}

void DrawLevel()
{
int i, x, y;

BlocksRemaining = 0;
DrawBlinds(); /* do the cool blinds effect */

for (y = 1; y <= 8; y ++)
 for (x = 0; x <= 9; x ++)
  {
  if (!current[y - 1][x] == 0)
   {
   if (!(current[y - 1][x] == 9)) BlocksRemaining ++; /* if its a playable block then add one to BlocksRemaining */
   DrawIcon( x*16, y*16, Bitmap[current[y - 1][x]].bank, Bitmap[current[y - 1][x]].image, OR);
   }
  else
   ClearLCDArea(x*16,y*16,x*16+15,y*16+15,0);
  }
UpdateStats(); /* display the on screen stats */
DrawLine( 0, 160, 159, 160, DRAW_GRAY);
DrawLine( 0, 178, 159, 178, DRAW_GRAY);
}

void UpdateStats()
{
char text [30];

ClearLCDArea(0, 164, 159, 175, 0); /*rub out what was there before */
SetFontType(PRPFONT14N);
strcpy( text, "Level: ");
itoa( VexedPreferences.CurrentLevel, text+strlen(text),10);
strcat( text, " - Blocks Left: ");
itoa( BlocksRemaining, text+strlen(text),10);
WriteString( 10, 164, text, 0); /* draw the text string */

}

void DrawIntro()
{
ClearLCD(0);
AboutDialog();
}

void EndSequence()
{
int x1, x2, randnum1, randnum2;
unsigned char penx, peny;
int bstate=0;

/* draw some text of adulation to the rather smart user! */
ClearLCDArea(0,16,159,143,0);
SetFontType(PRPFONT14N);
WriteString(50, 75, "Well Done!", 0);
SetFontType(PRPFONT11N);
WriteString(46, 90, "Game Complete", 0 );


/* fire some random blocks along the top and bottom of the screen! */
while (1)
 {
 randnum1 = random(9) + 1;
 randnum2 = random(9) + 1;

 SoundEffect(HighBeep);
 for (x1 = 0; x1 <= 160; x1 ++)
  {

  ClearLCDArea(x1-1,16,x1+14,31,0);
  DrawIcon(x1, 16, Bitmap[randnum1].bank, Bitmap[randnum1].image, OR);

  x2 = (160 - x1);

  ClearLCDArea(x2+1,128,x2+16,143,0);
  DrawIcon(x2, 128, Bitmap[randnum2].bank, Bitmap[randnum2].image, OR);

  Delay_10ms();

  bstate= GetKey(&penx, &peny);
  if (bstate==PENDOWN) break;
  }
 SoundEffect(LowBeep);
 ClearLCDArea(0,128,15,143,0);

 if (bstate==PENDOWN) break;
 }
SoundEffect(HighSweepLow);
}
