#ifndef AVDATA_H_
#define AVDATA_H_

#define SUCCESS 0
#define FAIL -1

#define FERR_NONE 0
#define FERR_MFILE 1
#define FERR_MFULL 2
#define FERR_BATLOW 3
#define FERR_ERASEFAIL 4
#define FERR_WRITEFAIL 5
#define FERR_UNKNOWCHIP 6
#define FERR_CHIPBAD 7
#define FERR_MPRGID 8
#define FERR_UNFORMATED 9
#define FERR_MENTRYPID 10
#define FERR_MOVERFILLED 11
#define FERR_KINDNUMBER 12

#define FBAT_VALUE_PHYSIC 470
#define FBAT_VALUE_BASIC 500
#define FBAT_VALUE_MIDDLE 508
#define FBAT_VALUE_HIGH 512

#define TYPE_ADDRESS 0
#define TYPE_MEMO 1
#define TYPE_SCHEDULE 2
#define TYPE_TASK 3
#define TYPE_EXPENSE 4
#define TYPE_SKETCH 5
#define TYPE_TIME 6
#define TYPE_CALC 7
#define TYPE_TABLE0 8
#define TYPE_TABLE1 9
#define TYPE_TABLE2 10
#define TYPE_TABLE3 11
#define TYPE_TABLE4 12
#define TYPE_TABLE5 13
#define TYPE_TABLE6 14
#define TYPE_TABLE7 15
#define TYPE_PRG0 128
#define APPLICATION_MAXID 254
#define INDEXTAB_SAVED 255

#define STATUS_ALARM 0X01
#define STATUS_BIRTHDAY 0X02
#define STATUS_PRIVATE 0X04
#define STATUS_REPEAT 0X08
#define STATUS_BYNAME 0X10

#define STATUS_MODIFY 0X40

#define SYSDATA_FDBSTART 5
#define SYSDATA_LIST_00 (SYSDATA_FDBSTART)
#define SYSDATA_LIST_15 (SYSDATA_FDBSTART+15)

#define FIELDNAME_SIZE 17
#define CATEGORYNAME_SIZE 17
#define LISTITEM_SIZE 17
#define APPNAME_SIZE 17
#define PASSWORD_SIZE 9

#define TABLE_MAXNUM_VER1 8
#define CATEGORY_MAXNUM 8
#define FIELD_MAXNUM 33
#define LISTITEM_MAXNUM 16
#define LISTTYPE_MAXNUM 16

typedef struct tagPIMHEAD
{
 unsigned int typeID;
 unsigned int recLength;
 unsigned int pid;
 unsigned char category;
 unsigned char option;
 unsigned char fieldCount;
 unsigned int synKeyOffset;
} PIMHEAD;

#define DTNOTYPE 0
#define DTTEXT16 0x01
#define DTTEXT128 0x02
#define DTTEXT256 0x03
#define DTTEXT512 0x04
#define DTTEXT4K 0x05
#define DTBOOLEAN 0x06
#define DTIINTEGER 0x07
#define DTREAL 0x08
#define DTCURRENCY 0x09
#define DTDATE 0x0a
#define DTTIME 0x0b
#define DTDBTIME 0x0c
#define DTALARM 0x0d
#define DTDRAWING 0x0e
#define DTCATEGORY 0x0f
#define DTTASKPRIORITY 0x10
#define DTREPEAT 0x11
#define DTLIST1 0x12
#define DTLIST2 0x13
#define DTLIST3 0x14
#define DTLIST4 0x15
#define DTLIST5 0x16
#define DTLIST6 0x17
#define DTLIST7 0x18
#define DTLIST8 0x19
#define DTLIST9 0x1a
#define DTLIST10 0x1b
#define DTLIST11 0x1c
#define DTLIST12 0x1d
#define DTLIST13 0x1e
#define DTLIST14 0x1f
#define DTLIST15 0x20
#define DTLIST16 0x21
#define DTPRIVATE 0x22
#define DTDUEDATE 0x23
#define DTDONE 0x24
#define DTSYNKEY 0x25
#define DTINTEGER 0x26

typedef struct tagRECHEAD
{
    unsigned int offset;
} RECHEAD;

typedef struct tagFIELD
{
 unsigned char status;
 unsigned char dataType;
 unsigned char name[FIELDNAME_SIZE];
} FIELD;

typedef struct tagFIELD_INFO
{
 FIELD field[FIELD_MAXNUM];
} FIELD_INFO;

typedef struct tagCATEGORY
{
 unsigned char status;
 unsigned char id;
 unsigned char name[CATEGORYNAME_SIZE];
} CATEGORY;

typedef struct tagCATEGORY_INFO
{
 CATEGORY cate[CATEGORY_MAXNUM];
} CATEGORY_INFO;

typedef struct tagLIST_NAME
{
 unsigned char string[LISTTYPE_MAXNUM][LISTITEM_SIZE];
} LIST_NAME;

typedef struct tagLIST_INFO
{
 unsigned char name[LISTITEM_SIZE];
 unsigned char item[LISTITEM_MAXNUM][LISTITEM_SIZE];
 unsigned char status;
} LIST_INFO;

typedef struct tagPASSWORD
{
 unsigned char string[PASSWORD_SIZE];
} PASSWORD;

typedef struct tagTABLE_NAME
{
 unsigned char string[APPNAME_SIZE];
} TABLE_NAME;

extern int ReadListName(LIST_NAME *listName);
extern int ReadListInfo(unsigned char listType,LIST_INFO *listInfo);
extern int SaveListInfo(unsigned char listType,LIST_INFO *listInfo);
extern int SetPrivateState(int state,unsigned char *password);
extern int GetPrivateState(void);
extern int SavePreference(unsigned char appID,void* buffer,unsigned int length);
extern int ReadPreference(unsigned char appID,unsigned int offset,void* buffer,unsigned int length);
extern int DeletePreference(unsigned char appID);
extern unsigned int GetPreferenceLen(unsigned char appID);
extern int LoadIndexTable(unsigned char appID);
extern int SaveIndexTable(unsigned char appID);
extern void GetRecordCount(unsigned char appID,unsigned int *records,unsigned int *aliveRecords);
extern unsigned int IsOverFilled(unsigned char appID);
extern unsigned int GetRecordSize(unsigned char appID,unsigned int recID);
extern unsigned int IsAliveRecord(unsigned char appID,unsigned int recID);
extern int CheckFreeRecordSpace(unsigned char appID,unsigned int recordSize);
extern int ReadRecord(unsigned char appID,unsigned int recID,unsigned int offset,void* buffer,unsigned int length);
extern int InsertRecord(unsigned char appID,unsigned int recID,void* buffer,unsigned int length);
extern int CreateRecord(unsigned char appID,void* buffer,unsigned int length);
extern int DeleteRecord(unsigned char appID,unsigned int recID);
extern int ModifyRecord(unsigned char appID,unsigned int recID,void* buffer,unsigned int length);
extern int ChangeRecord(unsigned char appID,unsigned int recID,void* buffer,unsigned int length);
extern unsigned int ReadFieldInfo(unsigned char appID,FIELD_INFO *fieldInfo);
extern int SaveFieldInfo(unsigned char appID,FIELD_INFO *fieldInfo);
extern int ReadTableName(unsigned char appID,unsigned char *name);
extern int SaveTableName(unsigned char appID,unsigned char *name);
extern unsigned int GetTableCount(void);
extern int GetFreeTableID(void);
extern unsigned int GetDataSize(unsigned char dataType);
extern int AllocPIMRecordSpace(unsigned int tableID,unsigned int size);
extern int ReadCategoryInfo(unsigned int appID,CATEGORY_INFO* catinfo);
extern int SaveCategoryInfo(unsigned int appID,CATEGORY_INFO* catinfo);

extern unsigned char CurrentAppID;

#endif
