extern int freq[]; /* frequencies for the notes */
extern int notes[]; /* period for the notes */

 /* notes[0] is do, octave 0, aka C0
    notes[1] is C#0
    notes[2] is D0
    notes[3] is Eb0
    notes[4] is E0
    notes[5] is F0
    notes[6] is F#0
    notes[7] is G0
    notes[8] is G#0
    notes[9] is A0
    notes[10] is Bb0
    notes[11] is B0
    notes[12] is C1, do octave 1
    up to notes[101] F8, fa octave 8
*/

/* for any function, a volume or level of 24 or higher is full volume, full harmonics
   square wave. For any function, a volume of 0, the sound is played muted - basically
   a delay. For volumes or level (including attack, sustain etc) between 1 and 23,
   the sound will play from low volume (1) to almost maximum volume (23), with only
   a subset of harmonics which makes it sound one octave lower than the full harmonics
   square wave, but is really just a side effect of having a purer sound.
*/

#define MODE_0 0             /* precise (slower) mode, preferred for up to 2KHz */
#define MODE_1 1             /* looser (faster) mode, better above 2KHz */

/*
   mute (int ontime, int offtime, int loops )
   description: a delay/a sound with no volume. Use the same ontime and
   offtime and loops values as for fx() or a ratio of them to have silences
   that are related to the same time signature as the fx you are doing.
   It is better to use note() however to play music and silences, as all times
   are expressed in milliseconds instead. Also if volume==0 for fx, mute is
   called.
*/
int mute (int ontime, int offtime, int loops );



/*
   fx(int ontime, int offtime, int loops, int volume, int lfomode, int lfospeed,int mmode )
   description: play a sound effect based on the upper and lower half cycle, repetition, volume etc.
   nb: this is a very low level routine, and requires tables to make specific frequencies and durations.
   ontime= {a multiplier to the number of cycles that the speaker will be toggled on}
   offtime= {a multiplier to the number of cycles that the speaker will be toggled off}
            if ontime=offtime, the frequencies can be found in freq.txt, else it can be
            calculated with: frequency=((ontime+offtime)/2)*31)/4000000+3.7 in mode 0.
            With ontime significantly smaller than offtime (but ontime+offtime/2 staying the same)
            one gets a lower intensity of sound, with different harmonics levels.
   loops= {how many time this on/off cycle will be repeated - it will sound shorter for a higher frequency}
          frequency/1000*duration will give you the number of loops for a duration in ms for a specific frequency
          Be warned that 0 is actually 65536 and at 30 Hz, that would sound for over 36 minutes (but only 6 seconds at 11KHz)!
   volume= {0 to 23 is volume control, 24+ is maximum intensity}
   lfomode= {still in heavy development, i disconnected that function - in the future frequency and amplitude modulation and other fx modes}
   lfospeed= {same as above}
   mmode= {MODE_0 is really precise from 0.9 Hz up to 2KHz, while MODE_1 starts at 588Hz and goes up to 27 KHz}
   
*/
int fx (int ontime, int offtime, int loops, int volume, int lfomode, int lfospeed,int mmode );



/*
   dualtone(int xf, int yf, int duration)
   description: a similar generator to fx, but with two voices
   xf= { ontime and offtime = xf, for the high voice (lower value than yf}
   yf= { ontime and offtime = yf, for the low voice (higher value than yf}
   duration= { similar to the loops concept for fx }
*/
int dualtone(int xf, int yf, int duration);



/*
   sound( int frequency, int duration, int attackDuration, int sustainDuration, int sustainLevel, int release)
   description: play a specific frequency, for a precise time with a defined enveloppe.
   nb: uses floats for conversions, so is a little slower than fx.
   frequency= {the pitch in Hz}
   duration= {how long the sound, in milliseconds, from 1ms up; oms is the same as 1ms}
   attackDuration= {time in milliseconds to reach sustain level volume from a volume of 0.
                    if 0, no attack}
   sustainDuration= {time in milliseconds to stay at sustain level volume}
   sustainLevel= {volume at which the sound will sustain after the attack if sustain level=0, mute }
   release= {volume at which the sound will end, the slope of which is determined by duration-(attackDuration+sustainDuration)=releaseDuration
*/
int sound( int frequency, int duration, int attackDuration, int sustainDuration, int sustainLevel, int release);



/*
   note(int keynote, int volume, int duration)
   description: play a note from the piano keyboard, tuned to A 440Hz
   keynote= {what note to play where 0 is C0, 1 is C#0, 2 is D0 etc}
   volume= {volume. If =0, silence of the proper length. Only !=0 or 0 for now due to a bug }
   duration= {time in milliseconds, from 1ms up; 0ms is the same as 1ms} )
*/
int note( int keynote, int volume, int duration);

