;*******************************************************
;*                                                     *
;*                 AVIGO GUI Library                   *
;*                  Version 1.01K1                     *
;*    Designed for Gerard Vermeulen's Freeware SDK     *
;*       Copyright (C)1999 Charles "Randy" Gill        *
;*           Released as licenced freeware             *
;*                                                     *
;*            Bug fixes and enhancements               *
;*          by Kai Nothdurft (KNO) 02/2000             *
;*         'KNO-changes' are Public Domain.            *
;*          Do with them whatever you want.            *
;*                                                     *
;*******************************************************

.module avagui.asm

.area _data 

.globl _GetRomBank
.globl __handleraddr    ;used internally by BankedAssign macros
.globl __bkpush1        ;used internally by BankedAssign macros
.globl __bkpush2        ;used internally by BankedAssign macros
.globl __GetTargetAddr  ;used internally by BankedAssign macros

_GetRomBank = 0x000f
_store_long_funct_arg = 0x3099

__handleraddr:
    .dw     0x0000

stored_ix:
    .dw     0x0000

;These revised bkpop routines circumvent the 'bankedreturn' stub and allow
;re-entrant code

rbkpop0:
    pop     hl
    ld      c,(hl)                  ;funct index lo
    inc     hl
    ld      b,(hl)                  ;funct index hi
    pop     hl                      ;retaddr of stub - discarded
    pop     hl                      ;calling ROM bank
    call    SetRomBank              ;Restore it - It's okay, we're running in RAM
    jp      banked_function_call    ;jump because overall return addr now at SP.
                                    ;We will return thru banked_function_call's own
                                    ;return stub, as it is compatible when #params
                                    ;is zero

rbkpop1:
    pop     iy                      ;get address of the '.dw' with the index
    ld      c, 0x00(iy)             ;func index lo
    ld      b, 0x01(iy)             ;func index hi
    ld      iy, #0x6800             ;base of banked func table
    add     iy, bc                  ;iy now points to func table entry
    ld      hl, #0x003F             ;bank for function table
    call    SetRomBank              ;switch to that bank
    pop     bc                      ;retaddr of old stub - discarded
    pop     bc                      ;calling ROM bank
    pop     de                      ;overall return addr
    pop     hl                      ;put 1st param in hl
    push    de                      ;put overall return address back on stack
    push    bc                      ;put calling ROM bank back on stack
    ld      bc, #rbkpop1ret         ;address of new return stub
    push    bc                      ;put it on stack
    ld      c,0x00(iy)              ;lo byte of target address
    ld      b,0x01(iy)              ;hi byte of target address
    push    bc                      ;put it on the stack
    push    hl                      ;temporarily store hl
    ld      l,0x02(iy)              ;lo byte of target bank
    ld      h,#0x00                 ;hi byte of target bank
    call    SetRomBank              ;set bank to target
    pop     hl                      ;restore hl
    ret                             ;jumps to target addr (at sp)

rbkpop1ret:
    ex      (sp),hl                 ;bank->hl , hl(retval)->sp
    call    SetRomBank              ;restore original bank
    pop     hl                      ;restore retval
    pop     iy                      ;overall return address
    push    hl                      ;put a dummy param back on stack for cleanup
    push    iy                      ;put overall return back on stack
    ret                             ;back to calling routine

rbkpop2:
    pop     iy                      ;get address of the '.dw' holding the index
    ld      c, 0x00(iy)             ;func index lo
    ld      b, 0x01(iy)             ;func index hi
    ld      iy, #0x6800             ;base of banked func table
    add     iy, bc                  ;iy now points to func table entry
    ld      hl, #0x003F             ;bank for function table
    call    SetRomBank              ;switch to that bank
    pop     bc                      ;retaddr of old stub - discarded
    pop     bc                      ;calling ROM bank
    ld      (stored_ix),ix          ;save ix - need to free up a reg
    pop     ix                      ;overall return addr
    pop     hl                      ;put 1st param in hl
    pop     de                      ;put 2nd param in de
    push    ix                      ;put overall return address back on stack
    ld      ix,(stored_ix)          ;restore ix
    push    bc                      ;put calling ROM bank back on stack
    ld      bc, #rbkpop2ret         ;address of new return stub
    push    bc                      ;put it on stack
    ld      c,0x00(iy)              ;lo byte of target address
    ld      b,0x01(iy)              ;hi byte of target address
    push    bc                      ;put it on the stack
    push    hl                      ;temporarily store hl
    ld      l,0x02(iy)              ;lo byte of target bank
    ld      h,#0x00                 ;hi byte of target bank
    call    SetRomBank              ;set bank to target
    pop     hl                      ;restore hl
    ret                             ;jumps to target addr (at sp)

rbkpop2ret:
    ex      (sp),hl                 ;bank->hl , hl(retval)->sp
    call    SetRomBank              ;restore original bank
    pop     hl                      ;restore retval
    pop     iy                      ;overall return address
    push    hl                      ;
    push    hl                      ;put 2 dummy params back on stack for cleanup
    push    iy                      ;put overall return back on stack
    ret                             ;back to calling routine

__bkpush1:
    pop     iy                      ;get address of '.dw' holding the target address
    ld      c,0x00(iy)              ;target addr lo
    ld      b,0x01(iy)              ;target addr hi
    push    bc                      ;
    pop     iy                      ;transfer it to iy
    pop     bc                      ;stub return address - discarded
    pop     bc                      ;calling ROM bank
    pop     de                      ;overall return address
    push    hl                      ;put param1 on stack
    push    de                      ;put overall return address back on stack
    push    bc                      ;put calling ROM bank back on stack
    ld      bc, #bkpush1ret         ;address of new return stub
    push    bc                      ;put it on stack
    push    iy                      ;target address -> stack
    ret                             ;jump to addr at sp

bkpush1ret:
    ex      (sp),hl                 ;bank->hl , hl(retval)->sp
    call    SetRomBank              ;restore original bank
    pop     hl                      ;restore retval
    pop     iy                      ;overall return address
    pop     bc                      ;remove param1 from stack
    push    iy                      ;put overall return back on stack
    ret                             ;back to calling routine

__bkpush2:
    ;call   0x0093                  ;debugging code - clearLCD
    ;jp     __bkpush2
    
    pop     iy                      ;get address of '.dw' holding the target address
    ld      c,0x00(iy)              ;target addr lo
    ld      b,0x01(iy)              ;target addr hi
    push    bc                      ;
    pop     iy                      ;transfer it to iy
    pop     bc                      ;stub return address - discarded
    pop     bc                      ;calling ROM bank
    ld      (stored_ix),ix          ;save ix - need to free up a reg
    pop     ix                      ;overall return addr
    push    de                      ;put 2nd param on stack
    push    hl                      ;put 1st param on stack
    push    ix                      ;put overall return address back on stack
    ld      ix,(stored_ix)          ;restore ix
    push    bc                      ;put calling ROM bank back on stack
    ld      bc, #bkpush2ret         ;address of new return stub
    push    bc                      ;put it on stack
    push    iy                      ;target address -> stack
    ret                             ;jump to addr at sp

bkpush2ret:
    ex      (sp),hl                 ;bank->hl , hl(retval)->sp
    call    SetRomBank              ;restore original bank
    pop     hl                      ;restore retval
    pop     iy                      ;overall return address
    pop     bc                      ;remove param1 from stack
    pop     de                      ;remove param2 from stack
    push    iy                      ;put overall return back on stack
    ret                             ;back to calling routine

__GetTargetAddr:
    ex      (sp),hl                 ;push old hl value
    push    hl                      ;return address
    push    de                      ;temporarily store
    ld      de, #0xFFF8             ;minus 8
    add     hl, de                  ;calculate origin address
    pop     de                      ;restore
    ret

.area _code

;Base Function Calls

banked_function_call=0x3003

;Banked Function Indexes
AllocBlock=0x01EF
FreeBlock=0x01F2

Destroy=0x017D
MessageBox=0x018F
ExecPickerOS=0x0192
ResourceRotate=0x0030
SendMessage=0x0186

PutEvent=0x01FB
TestPutEvent=0x01FE
GetEvent=0x01F8
SetEventMask=0x0204
GetEventMask=0x0207
ClearEvent=0x0201

PressAtRange=0x01E0
PressAtButton=0x01E3
PressAtButtonInv=0x01E6

PVIEW_setState=0x0090
PVIEW_draw=0x0093
PVIEW_handleEvent=0x0096

PGROUP_setState=0x0099
PGROUP_draw=0x009C
PGROUP_handleEvent=0x009F
PGROUP_execute=0x00A2
PGROUP_redraw=0x00A5
PGROUP_setCurrent=0x00AB
PGROUP_insert=0x00AE
Delete=0x0183

PDESKBOX_draw=0x00B1
PDESKBOX_handleEvent=0x00B4
PDESKBOX_redraw=0x00BA
PDESKBOX_drawTitle=0x00B7
CreateDeskBox=0x013B
InsertButton=0x014A
InsertPageArrow=0x0153
ExecView=0x0180
ChangeCommandMenu=0x013E
EnableCommand=0x018C
DisableCommand=0x0189

PCONTROLMENU_draw=0x00CC
PCONTROLMENU_handleEvent=0x00CF
CreateControlMenu=0x0156

PBUTTON_draw=0x00BD
PBUTTON_handleEvent=0x00C0
PBUTTON_drawStatus=0x00C3
CreateButton=0x0144
ChangeButton=0x0147

PSTACKEDLIST_draw=0x00FF
PSTACKEDLIST_handleEvent=0x0102
PSTACKEDLIST_drawExample=0x0105
CreateStackedList=0x0165

PPAGEARROW_draw=0x00C6
PPAGEARROW_handleEvent=0x00C9
CreatePageArrow=0x0150

PTEXTFIELD_draw=0x03AE
PTEXTFIELD_handleEventOS=0x03B1 ; KNO
CreateTextFieldOS=0x03A8        ; KNO

PNUMBERFIELD_draw=0x0135
PNUMBERFIELD_handleEventOS=0x0138 ; KNO
CreateNumberFieldOS=0x0177        ; KNO

PNUMBERSET_draw=0x00F3
PNUMBERSET_handleEvent=0x00FC
PNUMBERSET_drawNumber=0x00F6
CreateNumberSet=0x0162

PDATEFIELD_draw=0x0123
PDATEFIELD_handleEventOS=0x0126  ; KNO
CreateDateFieldOS=0x016E  ; RCN: 0x168 KNO: 0x16E

PTIMEFIELD_draw=0x0129
PTIMEFIELD_handleEventOS=0x012C ;KNO
CreateTimeFieldOS=0x0171  ; KNO

PBOOLFIELD_draw=0x011D
PBOOLFIELD_handleEvent=0x0120
CreateBoolField=0x0174

PLISTER_draw=0x00D2
PLISTER_handleEvent=0x00D5
PLISTER_writeItem=0x00D8
PLISTER_penDownAct=0x00DB
CreateLister=0x0159

PMENUFIELD_draw=0x00EA
PMENUFIELD_handleEvent=0x00ED
CreateMenuField=0x015F

;Global Declarations
.globl _AllocBlock
.globl _FreeBlock
.globl _MemoryErrorMessageBox

.globl _Destroy
.globl __MessageBox
.globl _ExecPickerOS
.globl _ResourceRotate
.globl _SendMessage

.globl _PutEvent
.globl _TestPutEvent
.globl _GetEvent
.globl _SetEventMask
.globl _GetEventMask
.globl _ClearEvent

.globl _PressAtRange
.globl _PressAtButton
.globl _PressAtButtonInv

.globl _PVIEW_setState
.globl _PVIEW_draw
.globl _PVIEW_handleEvent

.globl _PGROUP_setState
.globl _PGROUP_draw
.globl _PGROUP_handleEvent
.globl _PGROUP_execute
.globl _PGROUP_redraw
.globl _PGROUP_setCurrent
.globl _PGROUP_insert
.globl _Delete

.globl _PDESKBOX_draw
.globl _PDESKBOX_handleEvent
.globl _PDESKBOX_redraw
.globl _PDESKBOX_drawTitle
.globl _CreateDeskBox
.globl _InsertButton
.globl _InsertPageArrow
.globl _ExecView
.globl _ChangeCommandMenu
.globl _EnableCommand
.globl _DisableCommand

.globl _CreateControlMenu

.globl _PBUTTON_draw
.globl _PBUTTON_handleEvent
.globl _PBUTTON_drawStatus
.globl _CreateButton
.globl _ChangeButton

.globl _PSTACKEDLIST_draw
.globl _PSTACKEDLIST_handleEvent
.globl _PSTACKEDLIST_drawExample
.globl _CreateStackedList

.globl _PPAGEARROW_draw
.globl _PPAGEARROW_handleEvent
.globl _CreatePageArrow

.globl _PTEXTFIELD_draw
.globl _PTEXTFIELD_handleEventOS ; KNO
.globl _CreateTextFieldOS        ; KNO

.globl _PNUMBERFIELD_draw
.globl _PNUMBERFIELD_handleEventOS ; KNO
.globl _CreateNumberFieldOS        ; KNO

.globl _PNUMBERSET_draw
.globl _PNUMBERSET_handleEvent
.globl _PNUMBERSET_drawNumber
.globl _CreateNumberSet

.globl _PDATEFIELD_draw
.globl _PDATEFIELD_handleEventOS ; KNO
.globl _CreateDateFieldOS        ; RCN, KNO

.globl _PTIMEFIELD_draw
.globl _PTIMEFIELD_handleEventOS ; KNO
.globl _CreateTimeFieldOS        ; KNO

.globl _PBOOLFIELD_draw
.globl _PBOOLFIELD_handleEvent
.globl _CreateBoolField

.globl _PLISTER_draw
.globl _PLISTER_handleEvent
.globl _PLISTER_writeItem
.globl _PLISTER_penDownAct
.globl _CreateLister

.globl _PMENUFIELD_draw
.globl _PMENUFIELD_handleEvent
.globl _CreateMenuField

; <KNO>
.globl _PCONTROLMENU_draw
.globl _PCONTROLMENU_handleEvent
; </KNO>

_AllocBlock:
        call    rbkpop2
        .dw     AllocBlock
_FreeBlock:
        call    rbkpop1
        .dw     FreeBlock

_Destroy:
        call    rbkpop1
        .dw     Destroy
__MessageBox:
        call    rbkpop2
        .dw     MessageBox
_ExecPickerOS:
        call    rbkpop2
        .dw     ExecPickerOS
_ResourceRotate:
        call    rbkpop1
        .dw     ResourceRotate
_SendMessage:
        call    rbkpop2
        .dw     SendMessage

_PutEvent:
        call    rbkpop2
        .dw     PutEvent
_TestPutEvent:
        call    rbkpop2
        .dw     TestPutEvent
_GetEvent:
        call    rbkpop2
        .dw     GetEvent
_SetEventMask:
        call    rbkpop1
        .dw     SetEventMask
_GetEventMask:
        call    rbkpop0
        .dw     GetEventMask
_ClearEvent:
        call    rbkpop1
        .dw     ClearEvent

_PressAtRange:
        call    rbkpop2
        .dw     PressAtRange
_PressAtButton:
        call    rbkpop2
        .dw     PressAtButton
_PressAtButtonInv:
        call    rbkpop2
        .dw     PressAtButtonInv

_PVIEW_setState:
        call    rbkpop2
        .dw     PVIEW_setState
_PVIEW_draw:
        call    rbkpop1
        .dw     PVIEW_draw
_PVIEW_handleEvent:
        call    rbkpop2
        .dw     PVIEW_handleEvent

_PGROUP_setState:
        call    rbkpop2
        .dw     PGROUP_setState
_PGROUP_draw:
        call    rbkpop1
        .dw     PGROUP_draw
_PGROUP_handleEvent:
        call    rbkpop2
        .dw     PGROUP_handleEvent
_PGROUP_execute:
        call    rbkpop1
        .dw     PGROUP_execute
_PGROUP_redraw:
        call    rbkpop1
        .dw     PGROUP_redraw
_PGROUP_setCurrent:
        call    rbkpop2
        .dw     PGROUP_setCurrent
_PGROUP_insert:
        call    rbkpop2
        .dw     PGROUP_insert
_Delete:
        call    rbkpop2
        .dw     Delete

_PDESKBOX_draw:
        call    rbkpop1
        .dw     PDESKBOX_draw
_PDESKBOX_handleEvent:
        call    rbkpop2
        .dw     PDESKBOX_handleEvent
_PDESKBOX_redraw:
        call    rbkpop1
        .dw     PDESKBOX_redraw
_PDESKBOX_drawTitle:
        call    rbkpop1
        .dw     PDESKBOX_drawTitle
_CreateDeskBox:
        call    rbkpop2
        .dw     CreateDeskBox
_InsertButton:
        call    rbkpop2
        .dw     InsertButton
_InsertPageArrow:
        call    rbkpop2
        .dw     InsertPageArrow
_ExecView:
        call    rbkpop1
        .dw     ExecView
_ChangeCommandMenu:
        call    rbkpop2
        .dw     ChangeCommandMenu
_EnableCommand:
        call    rbkpop1
        .dw     EnableCommand
_DisableCommand:
        call    rbkpop1
        .dw     DisableCommand

_CreateControlMenu:
        call    rbkpop2
        .dw     CreateControlMenu

_PBUTTON_draw:
        call    rbkpop1
        .dw     PBUTTON_draw
_PBUTTON_handleEvent:
        call    rbkpop2
        .dw     PBUTTON_handleEvent
_PBUTTON_drawStatus:
        call    rbkpop2
        .dw     PBUTTON_drawStatus
_CreateButton:
        call    rbkpop2
        .dw     CreateButton
_ChangeButton:
        call    rbkpop2
        .dw     ChangeButton

_PSTACKEDLIST_draw:
        call    rbkpop1
        .dw     PSTACKEDLIST_draw
_PSTACKEDLIST_handleEvent:
        call    rbkpop2
        .dw     PSTACKEDLIST_handleEvent
_PSTACKEDLIST_drawExample:
        call    rbkpop1
        .dw     PSTACKEDLIST_drawExample
_CreateStackedList:
        call    rbkpop2
        .dw     CreateStackedList

_PPAGEARROW_draw:
        call    rbkpop1
        .dw     PPAGEARROW_draw
_PPAGEARROW_handleEvent:
        call    rbkpop2
        .dw     PPAGEARROW_handleEvent
_CreatePageArrow:
        call    rbkpop2
        .dw     CreatePageArrow

_PTEXTFIELD_draw:
        call    rbkpop1
        .dw     PTEXTFIELD_draw
_PTEXTFIELD_handleEventOS:   ; KNO
        call    rbkpop2
        .dw     PTEXTFIELD_handleEventOS
_CreateTextFieldOS:          ; KNO
        call    rbkpop2
        .dw     CreateTextFieldOS

_PNUMBERFIELD_draw:
        call    rbkpop1
        .dw     PNUMBERFIELD_draw
_PNUMBERFIELD_handleEventOS:   ; KNO
        call    rbkpop2
        .dw     PNUMBERFIELD_handleEventOS
_CreateNumberFieldOS:          ; KNO
        call    rbkpop2
        .dw     CreateNumberFieldOS

_PNUMBERSET_draw:
        call    rbkpop1
        .dw     PNUMBERSET_draw
_PNUMBERSET_handleEvent:
        call    rbkpop2
        .dw     PNUMBERSET_handleEvent
_PNUMBERSET_drawNumber:
        call    rbkpop1
        .dw     PNUMBERSET_drawNumber
_CreateNumberSet:
        call    rbkpop2
        .dw     CreateNumberSet

_PDATEFIELD_draw:
        call    rbkpop1
        .dw     PDATEFIELD_draw
_PDATEFIELD_handleEventOS:  ; KNO
        call    rbkpop2
        .dw     PDATEFIELD_handleEventOS
_CreateDateFieldOS: ; RCN, KNO
        call    rbkpop2
        .dw     CreateDateFieldOS

_PTIMEFIELD_draw:
        call    rbkpop1
        .dw     PTIMEFIELD_draw
_PTIMEFIELD_handleEventOS:  ; KNO
        call    rbkpop2
        .dw     PTIMEFIELD_handleEventOS
_CreateTimeFieldOS: ; KNO
        call    rbkpop2
        .dw     CreateTimeFieldOS

_PBOOLFIELD_draw:
        call    rbkpop1
        .dw     PBOOLFIELD_draw
_PBOOLFIELD_handleEvent:
        call    rbkpop2
        .dw     PBOOLFIELD_handleEvent
_CreateBoolField:
        call    rbkpop2
        .dw     CreateBoolField

_PLISTER_draw:
        call    rbkpop1
        .dw     PLISTER_draw
_PLISTER_handleEvent:
        call    rbkpop2
        .dw     PLISTER_handleEvent
_PLISTER_writeItem:
        call    rbkpop2
        .dw     PLISTER_writeItem
_PLISTER_penDownAct:
        call    rbkpop2
        .dw     PLISTER_penDownAct
_CreateLister:
        call    rbkpop2
        .dw     CreateLister

_PMENUFIELD_draw:
        call    rbkpop1
        .dw     PMENUFIELD_draw
_PMENUFIELD_handleEvent:
        call    rbkpop2
        .dw     PMENUFIELD_handleEvent
_CreateMenuField:
        call    rbkpop2
        .dw     CreateMenuField

; <KNO>
_PCONTROLMENU_draw:
        call    rbkpop1
        .dw     PCONTROLMENU_draw
_PCONTROLMENU_handleEvent:
        call    rbkpop2
        .dw     PCONTROLMENU_handleEvent
; </KNO>
