/*****************************************************\
*                                                     *
*             PBITMAP customized control              *
*                    Version 1.00                     *
*    Designed for Gerard Vermeulen's Freeware SDK     *
*        Copyleft (KNO)2000 Kai Nothdurft             *
*           Given to the Public Domain                *
*                                                     *
\*****************************************************/
#include <avgui.h>
#include "PBITMAP.H"

unsigned char IsValidPoint(unsigned char x, unsigned char y)
{
    if (GetDisplayDirection())
    {
        if (x>=LCD_HEIGHT || y>=LCD_WIDTH)
            return 0;
    }
    else
    {
        if (x>=LCD_WIDTH || y>=LCD_HEIGHT)
            return 0;
    }

    return 1;
}

void PBITMAP_setState(VOID_PTR thisView, unsigned char state, char enable)
{
  PVIEW_setState(thisView, state, enable);
}

void PBITMAP_draw(VOID_PTR thisView)
{
  PBITMAP *bitmap;

  PVIEW_draw(thisView);
  bitmap = (PBITMAP *)thisView;

  DrawIcon((bitmap->view).left, (bitmap->view).top, (bitmap->bmpdata).bank,
           (unsigned int *)((bitmap->bmpdata).addr), bitmap->mode);

}

void PBITMAP_handleEvent(VOID_PTR thisView, unsigned int *evType, unsigned char x, unsigned char y)
{
  PVIEW_handleEvent(thisView, evType, x, y);
}

VOID_PTR CreateBitmap(unsigned char ID,
                     unsigned char left, unsigned char top,
                     unsigned int bmpbank, unsigned int bmpaddr, unsigned char mode)
{
  PBITMAP *bitmap;
  
  if (!IsValidPoint(left, top))
      return (VOID_PTR)0;

  /* Allocate memory block for the new object */
  bitmap = (PBITMAP *)AllocBlock(sizeof(PBITMAP), ID, 0); /* 0=Random mode memory allocation. */

  if (!bitmap)
      return (VOID_PTR)0;

  /* initialize the members of PVIEW */
  (bitmap->view).next    = (PVIEW_PTR)0;   /* Pointer to the next object in the same
                                             group as this one */
  (bitmap->view).owner   = (PGROUP_PTR)0;  /* Pointer to the group that owns this */
  (bitmap->view).state   = 0;              /* State flags */
  (bitmap->view).options = 0;              /* Option flags */
  (bitmap->view).left    = left;           /* Left screen coordinate */
  (bitmap->view).top     = top;            /* Top  screen coordinate */

  BankedAssign2((bitmap->view).setState, PBITMAP_setState);       /* Address of setState handler */
  BankedAssign1((bitmap->view).draw, PBITMAP_draw);               /* Address of draw handler */
  BankedAssign2((bitmap->view).handleEvent, PBITMAP_handleEvent); /* Address of handleEvent handler */

  /* initialize the members of PBITMAP */
  (bitmap->bmpdata).bank = bmpbank;
  (bitmap->bmpdata).addr = bmpaddr;
  bitmap->mode = mode;

  return (VOID_PTR) bitmap;
}
