;--------------------------------------------------------------
;This patch alters the behaviour of the ABC buttons of the world time picker
;Instead of just jumping to the city names starting with the first letter in
;the button it now also jumps to the others letters when tapped again
;--------------------------------------------------------------

;FindNextCity (optimized and enhanced)

;		L=first initial char of CityName in range

	        .org	$5FED

		 ld	a,l		;1st in range
		 cp	'Y'
		 adc	a,2
		 ld 	h,a		;Last in range
		 
		 ld	a,($9878)	;E=Top WorldTimeCityindex
		 ld	e,a
		 call	GetCityName	
		 cp	l		
		 jr	c,UseFirst	;<Start letter
		 inc	a
		 cp	h
		 jr	c,FindCity	;<Last set next
UseFirst:	 ld	a,l

FindCity:	 ld	e,0		;1st WT index
		 ld	d,a		;city letter wanted
FindNext:	 push	de
		 call	GetCityName
		 pop	de
		 jr	z,NotFound	;index does not exist
		 cp	d		
		 jr	c,TryNext	;too small
		 cp	h
		 jr	c,Found		;Found in range
TryNext:	 inc	e
		 ld	a,e
		 cp	$64
		 jr	c,FindNext
NotFound:	 ld	a,l		
		 cp	d
		 jr	nz,FindCity	;Try again for to find first in range
		ld	c,$FF				 
Found:		ld	a,c
		 ret

;-sub-
		 
GetCityName:	 push	hl
		 ld	l,1
		 push	hl
	         ld      hl,$9768       ;*WTbuffet
	         ld      bc,$48DF       ;GetWorldTimeInfo
	         call    $3000
	         pop	hl
	         ld	c,a		;CityIndex
	         inc	a
	         jr	z,NoCityName
	         ld	a,($9775)
NoCityName:      pop	hl
	         ret

		.fill	$607D-$,$FF
;------------------------------------------------------

		.end