#include "ressdk.h"
#include "f_sdkapi.h"
#include "..\windows.h"
#include "main.h"

void SoundBrick(void)
{
 Buzzer(1, 2);
 Buzzer(5, 2);
}

void SoundPaddle(void)
{
 Buzzer(5, 2);
 Buzzer(1, 2);
}

void BuildBoard(void)
{
 byte y,x;

 for (y=0; y<6; y++)
 {
  for(x=0; x<10; x++)
  {
   Boards[(y*10)+x].Xpos = (x*16);
   Boards[(y*10)+x].Ypos = BOARD_TOP+((BrickHeight+1)*y);
   Boards[(y*10)+x].Style = 1;
   Boards[(y*10)+x].NbHit = 1;
  }
 }
}

void BounceBall(int Mode)
{
 if (DispX<0) DispX = DispXVal;
 else DispX = 0-DispXVal;

 if(!Mode)
 {
  if (DispY<0) DispY = DispYVal;
  else DispY = 0-DispYVal;
 }
}

void DrawBoard(void)
{
 byte i = 0;

 BuildBoard();
 NumBricks=0;

 do
 {
  DrawRect(	Boards[i].Xpos, Boards[i].Ypos, 
			Boards[i].Xpos + BrickWidth,
			Boards[i].Ypos + BrickHeight, DRAW_BLACK);

  FillRect(	Boards[i].Xpos+1, Boards[i].Ypos+1, 
			(Boards[i].Xpos + BrickWidth)-2,
			(Boards[i].Ypos + BrickHeight)-2, 
			BrickClrs[Boards[i].Style]);
  i++;
  NumBricks++;
 }while(Boards[i].Ypos > 0);
}

int BallTuchesBrick(byte x, byte y)
{
 byte i=0;

 do
 {
  if (y <= (Boards[i].Ypos + BrickHeight + 5)) 
  {
   if (Boards[i].NbHit>0)
   {
    if ( ((x>=Boards[i].Xpos) && (x<=Boards[i].Xpos+BrickWidth)) )
    {
     Boards[i].NbHit--;
     FillRect(Boards[i].Xpos, Boards[i].Ypos, 
 			  Boards[i].Xpos + BrickWidth,
			  Boards[i].Ypos + BrickHeight, 
			  BrickClrs[Boards[i].NbHit]);
    
     BounceBall((y <= Boards[i].Ypos));
	 NumBricks--;
     return TRUE;
    }
   }
  }
  i++;
 }while(Boards[i].Ypos > 0);
 return (FALSE);
}

void ErasePaddle(void)
{
 SetLineSize(2);
 DrawLine(PaddlePosX, PaddlePosY, PaddlePosX+PaddleWidth, PaddlePosY, DRAW_WHITE);
 SetLineSize(0);
}

void DrawPaddle(void)
{
 SetLineSize(2);
 DrawLine(PaddlePosX, PaddlePosY, PaddlePosX+PaddleWidth, PaddlePosY, DRAW_BLACK);
 SetLineSize(0);
}

void EraseBall()
{
 FillCircle(BallX, BallY, 3, DRAW_WHITE);
}

void DrawBall()
{
 FillCircle(BallX, BallY, 3, DRAW_BLACK);
}

short GetNewDispX(void)
{
 if (DispX>0) return (DispXVal);
 else return (0-DispXVal);
}

void MoveBall(void)
{
 byte pos;

 if (BallTuchesBrick( BallX, BallY)) SoundBrick();
 
 /* left wall */
 if (BallX<=3) DispX = DispXVal;
 /* right wall */
 if (BallX>=157) DispX = 0-DispXVal;
 /* top wall */
 if (BallY<=3) DispY = DispYVal;
 /* bottom */
 if ((BallY>=(PaddlePosY-6)) && 
    ((BallX>=PaddlePosX) && (BallX<=PaddlePosX+PaddleWidth)))
 {
  pos = (PaddleWidth)/3;
  DispY = 0-DispYVal;
  /* left part of paddle */
  if (BallX<(PaddlePosX+pos))
  {
   DispXVal = 5;
   DispX = 0-DispXVal;
  }
  else
  /* right part of paddle */
  if (BallX>(PaddlePosX+PaddleWidth)-pos)
 {
   if (DispX<0) {DispXVal = 5;DispX = 0-DispXVal;} 
   else {DispXVal = 5;DispX = DispXVal;} 
  }
  else {DispXVal = 3;DispX = GetNewDispX();}
  /* redraw paddle */
  DrawPaddle();
  SoundPaddle();
 }
 
 BallX += DispX;
 BallY += DispY;
}


static BANKED void WndProc(byte handle, short evType, byte x, byte y)
{
 switch(evType)
 {
  case evKeyDown:
  		switch(x)
  		{
		 case SCHEDULE:
		 	ErasePaddle();
			if (PaddlePosX>0) PaddlePosX -= 10;
			DrawPaddle();
			break;

		 /* move right */		
  		 case MEMO:
			ErasePaddle();
			if ((PaddlePosX+PaddleWidth)<160) PaddlePosX += 10;
			DrawPaddle();
  			break;
  		}break;

  case evCreate:
		SetAutoPowerOff(FALSE, 0);
		DispXVal = 3;
		DispYVal = 8;

		PaddlePosX = (160/2) - (PaddleWidth/2);
 		PaddlePosY = 230;

 		BallX = 10;
 		BallY = 80;
  
 		DispX = 1;
 		DispY = 2;
 		speed = 0;
 		break;

  case evDestroy:
		SetAutoPowerOff(TRUE, 0);
  		break;

  case evFastTimer:
  		if (BallY > 240) PostQuitMessage(handle, APPLICATION);
 
		if (speed++ > 1)
  		{
   		 /* erase ball */
   	 	 EraseBall();
   		 MoveBall();
   		 /* draw ball */
   		 DrawBall();
   		 speed = 0;
  		}
 		break;

  case evPaint:
		ClearLCD(0);
		DrawBoard();
 		SetFontType(PRPFONT11N);
 		DrawPaddle();
 		DrawBall();
		break;
 
 }
}

BANKED void	WinMain()
{
 Window Win;

 /*ClearLCD(0);*/
 SetFontType(PRPFONT11N);

 Win.wTitle = MK_FAR_PTR(AppTitle);
 Win.wMenu =  MK_FAR_PTR(AppMenu);
 Win.wleft = 0;
 Win.wtop = 0;
 Win.wright = 159;
 Win.wbottom = 239;
 Win.Modal = FALSE;
 Win.wDir = PORTRAIT;
 Win.wflags = bafDotTitle;
 BankedAssign(Win.WndProc,WndProc);

 /*handle = */
 CreateWindow(MK_FAR_PTR(Win));
}
