#include "ressdk.h" 
#include "packet.h"
#include "f_sdkapi.h"
#include "windows.h"

#define MAX_WINDOWS	5
#define MAX_MSGS	20

#define SCR_WIDTH	160
#define SCR_HEIGHT	240

typedef struct TagTComPort
{
 word Speed;
 byte Mode;
 int  Opened;
 byte Handler;
}TComPort;

typedef struct TagMessage
{
 byte handle;
 unsigned short evType;
 byte x;
 byte y;
}Message;

byte 	*Tvar;
static Window	Windows[MAX_WINDOWS];
static byte		TopWindow = 0;
static Message	Messages[MAX_MSGS];
static TComPort ComPort;

static short	Cur_Msg;
static short	NumWindows = 0;
static byte 	PwasDown=0;
static short	ModalResult;
static byte 	TimCnt=0;

Window	SysTempWin;
static short AutoWakeUp;

extern BANKED void WinMain(void);
static BANKED byte ReceiveByte(void);
static BANKED void InitComm(short Mode, short Rate);

static byte oldx, oldy;
static short LastWin = -1;
static word LastCmd = 0;
static int PenIsDown = FALSE;
 

extern byte StartRomBank; 

BANKED void OpenComm(byte handle, byte Port, word Speed)
{
 if(ComPort.Opened) return;

 ComPort.Opened = TRUE;
 ComPort.Speed = Speed;
 ComPort.Mode = Port;
 ComPort.Handler = handle;

 InitComm(ComPort.Mode, ComPort.Speed);
}

BANKED byte HighByte(word v)
{
 return (((byte *) &v)[1]);
}

BANKED byte LowByte(word v)
{
 return (((byte *) &v)[0]);
}

BANKED int Round(double t)
{
 double v;
 int r;

 r = t;
 v = r + 0.5;

 if (t >= v) r++;

 return(r);
}

BANKED int isdigit(char c) 
{
 return ((int) (c<='9' && c>='0'));
}

BANKED int isalpha(char c) 
{
 return ((int) (c<='z' && c>='a') || (c<='Z' && c>='A'));
}

BANKED void SetProp(byte handle, word prop)
{
 Windows[handle].prop = prop;
}

BANKED int GetCharLength(char c,int Font)
{
 int i, z;
 char tmp[3];

 tmp[0] = c;
 tmp[1] = 0;

 if (c == 9)
 {
  tmp[0] = ' ';
  i=GetStringLength(tmp, Font);
  z = ((i+1)*3)+i;
 }
 else z = GetStringLength(tmp, Font);
  
 return(z);
}

BANKED word GetProp(byte handle)
{
 return (Windows[handle].prop);
}


BANKED void	ClearClientArea(byte handle)
{
 ClearLCDArea(	Windows[handle].wleft+2,
 				Windows[handle].wtop+15,
				Windows[handle].wright-2,
				Windows[handle].wbottom-2, 0);
}

BANKED char DecimalSeparator(void)
{
 if (GetSysFormat() & 2) return(',');
 else					 return('.');
}

BANKED byte GetWindowDirection(byte handle)
{
 return Windows[handle].wDir;
}

BANKED void	BringToFront(byte handle)
{
 TopWindow = handle;
 PostMessage(TopWindow, evPaint, 0, 0);
}

BANKED void	GetWindowsRect(byte handle, rect *r)
{
 r->left = Windows[handle].wleft;
 r->top = Windows[handle].wtop;
 r->right = Windows[handle].wright;
 r->bottom = Windows[handle].wbottom;
}

BANKED short ScreenWidth(void)
{
 if (GetDisplayDirection()) return SCR_HEIGHT;
 else						return SCR_WIDTH;
}

BANKED short ScreenHeight(void)
{
 if (GetDisplayDirection()) return SCR_WIDTH;
 else						return SCR_HEIGHT;
}

BANKED void WinDrawHandler(VOID_PTR thisView)
{
 PostMessage(TopWindow, evPaint, 0, 0);
 DispatchMessages();
}

BANKED void WinProcHandler(VOID_PTR thisView, unsigned short *evType, byte x, byte y)
{
 byte i;

 for (i=0; i<MAX_WINDOWS; i++)
 {
  if (Windows[i].used)
  {
   if (((VOID_PTR) Windows[i].Wnd) == thisView)
   {
    PostMessage(TopWindow, *evType, x, y);
    if (Windows[TopWindow].Modal) DispatchMessages();
    return;
   }
  }
 }
}

BANKED void DrawTime(byte h, byte x, byte y, short attr)
{
 _TIME time;

 GetTime(&time);
 WriteTime(Windows[h].wleft+x, Windows[h].wtop+y, time, attr);
}

BANKED byte DrawString(byte h, byte x, byte y, CONST_FAR_PTR str, short attr)
{
 char TempStr[256];

 fstrcpy(TempStr, str);
 if ((GetFontType() == PRPFONT7N) && (Windows[h].wDir)) y -=7;
 return WriteString(Windows[h].wleft+x, Windows[h].wtop+y, TempStr, attr);
}


BANKED void InsertControl(byte handle, PVIEW *p)
{
 PDESKBOX *dsk;

 dsk = (PDESKBOX *) Windows[handle].Wnd;

 LoadBank(&dsk->insert);
 dsk->insert((VOID_PTR) dsk, (PVIEW *) p);
}

BANKED byte GetWinHeight(byte handle)
{
 return(Windows[handle].wbottom+1);
}

BANKED byte GetWinWidth(byte handle)
{
 return(Windows[handle].wright+1);
}

BANKED void RotateWindow(byte handle)
{
 byte i;
 PDESKBOX *p;

 p = (PDESKBOX *) Windows[handle].Wnd;

 i = Windows[handle].wbottom;
 Windows[handle].wbottom = Windows[handle].wright;
 Windows[handle].wright = i;

 i = p->bottom;
 p->bottom = p->right;
 p->right = i;

 if (Windows[handle].wDir) Windows[handle].wDir=0;
 else Windows[handle].wDir = 1;

 ResourceRotate(Windows[handle].wDir);
 PostMessage(handle, evPaint, 0, 0);
}

BANKED void ResizeWindow(byte handle, byte left, byte top, byte right, byte bottom)
{
 byte i, ydif;
 PVIEW *p;

 ydif = Windows[handle].wbottom;

 p = (PVIEW *) Windows[handle].Wnd;
 
 Windows[handle].wleft	= left;
 Windows[handle].wtop	= top;
 Windows[handle].wright	= right;
 Windows[handle].wbottom= bottom;

 p->left	= left;
 p->top		= top;
 p->right	= right;
 p->bottom	= bottom;
 /*
 while(p->next)
 {
  p = (PVIEW *) p->next;
  p->top += ydif;
  p->bottom += ydif;
 }
 */
 PostMessage(handle, evPaint, 0, 0);
} 

BANKED VOID_PTR GetWindowPtr(byte handle)
{
 return ((VOID_PTR) Windows[handle].Wnd);
}

static byte FindClickedWindow(byte x, byte y)
{
 byte i;

 /* check TopWindow first */
 if (Windows[TopWindow].used)
 {
  if (((x >= Windows[TopWindow].wleft) && (x<= Windows[TopWindow].wright)) &&
      ((y >= Windows[TopWindow].wtop) && (y<= Windows[TopWindow].wbottom))) return (TopWindow);
 }

 for (i=MAX_WINDOWS-1; i>=0; i--)
 {
   if (Windows[i].used)
   {
     if (((x >= Windows[i].wleft) && (x<= Windows[i].wright)) &&
         ((y >= Windows[i].wtop) && (y<= Windows[i].wbottom))) return (i);
   }
 }

 return (-1);
}

static BANKED void BrodCast(unsigned short evType, byte x, byte y)
{
 short i;

 for (i=0; i<MAX_WINDOWS; i++)
	if (Windows[i].used) 
		PostMessage(i, evType, x, y);
}

BANKED void PostQuitMessage(byte handle, short app)
{
 BrodCast(evQuit, app, 0);
}

BANKED void PostMessage(byte handle, unsigned short evType, byte x, byte y)
{
 if (Cur_Msg>=MAX_MSGS) WarningBeep();
 else
 {
  Cur_Msg++;
  Messages[Cur_Msg].handle = handle;
  Messages[Cur_Msg].evType = evType;
  Messages[Cur_Msg].x = x;
  Messages[Cur_Msg].y = y;
 }
}

static BANKED int FindFreeWindow(void)
{
 short i;

 for (i=0; i<MAX_WINDOWS; i++)
   if (!Windows[i].used) return (i);

 return (-1);
}

static BANKED int PeekMessage(byte *handle, unsigned short  *evType, byte *x, byte *y)
{
 if (Cur_Msg>0)
 {
  *handle = Messages[1].handle;
  *evType = Messages[1].evType;
  *x = Messages[1].x;
  *y = Messages[1].y;
  /*
  for (i=2; i<=Cur_Msg; i++) 
    memcpy(&Messages[i-1], &Messages[i], sizeof(Message));
  */
  memcpy(&Messages[1], &Messages[2], sizeof(Message) * (Cur_Msg-1));

  Cur_Msg--;
  return (TRUE);
 }
 else return(FALSE);
}


static BANKED short DispatchMessages(void)
{
 unsigned short evType, ev;
 byte handle;
 byte x,y;
 VOID_PTR thisView;

 while(Cur_Msg>0)
 {
  if (PeekMessage(&handle, &evType, &x, &y))
  {
   thisView = Windows[handle].Wnd;
   ev = evType;
  
   if (evType == evCreateModal)
   {
    CreateModalWindow(MK_FAR_PTR(SysTempWin), 0, TRUE); 
    continue;
   }

   if (evType == evQuit)
   {
    DestroyWindow(handle); 
    ModalResult = (short) x;
   }
   else
   {
    if (evType == evPaint)
    {
     if (Windows[handle].wDir != GetDisplayDirection())
       ResourceRotate(Windows[handle].wDir);

     if (Windows[handle].WndProc != 0)
       PDESKBOX_draw((VOID_PTR) thisView);
    }
    
    /* dispatch messages */
    if ((handle>=0) && (Windows[handle].used))
    {
     if (Windows[handle].WndProc != 0)
     {
      if (evType!=evPaint)
        PDESKBOX_handleEvent((VOID_PTR) thisView, &evType, x, y);
   
      LoadBank(&(Windows[handle].WndProc));
      Windows[handle].WndProc(handle, ev, x, y);
     }
    }
   }
  }
 }
}


BANKED void DestroyWindow(byte handle)
{
 VOID_PTR thisView;
 int post = (TopWindow == handle);
 byte i;

 if (Windows[handle].used)
 {
  thisView = Windows[handle].Wnd;

  PostMessage(handle, evDestroy, 0, 0);
  DispatchMessages();

  if (Windows[handle].Modal) EndState = 1;

  Windows[handle].used = FALSE;
  Destroy ((VOID_PTR) Windows[handle].Wnd);
  memset(&Windows[handle], 0, sizeof(Window));

  NumWindows--;

  if (NumWindows>1) 
  {
    for (i=MAX_WINDOWS-1;i>0; i--)
      if (Windows[i].used) TopWindow = i;
  }
  else TopWindow = 0;
 }
}

static BANKED int GetKey(byte *penx, byte *peny)
{
.asm
	call 00E7h
	ld l,a
	ld h,0
	push hl
	;  set xpos 
	ld	l,(ix)
	ld	h,(ix+1)
	ld	e,l
	ld	d,h
	ld	a,b
	ld	(de),a
	;  set ypos
	ld	l,(ix+2)
	ld	h,(ix+3)
	ld	e,l
	ld	d,h
	ld	a,c
	ld	(de),a
	; set code 
    pop hl
.endasm
} 

static BANKED short GetMyEvent(byte *x, byte *y)
{
 short ev;

 switch((ev = GetKey(x, y)))
 {
  case 0: 
		return(evNothing);

  case POWER:
  case ADDRESS:
  case SCHEDULE:
  case TASK:
  case MEMO:
  case PGUP:
  case PGDN:
  case CALENDAR:
  case EXPENSES:
  case CALCULATOR:
  case TABLE:
  case APPLICATION:
  case FIND:
  case BACK_LIGHT:
  case PC_LINK_KEY:
  		*x = ev;
  		return (evKeyDown);

  case 255:
        return(ev);
        break;
 }
}

static BANKED void CheckModalControls(byte x, byte y)
{
 PDESKBOX *dsk;
 int x1, x2;
 byte right;
 PPAGEARROW *pg;

 if (Windows[TopWindow].Modal)
 {
  ModalResult = 0;
  dsk = (PDESKBOX *) GetWindowPtr(TopWindow);

  pg = (PPAGEARROW *) dsk->next;

  if ((y>=dsk->top+3) && (y<=dsk->top+13))
  {
   right = dsk->right;
   /* check button */
   if (dsk->boxAttrib & bafCheck)
   {
	x1 = right-15;
	x2 = right-4;

	if ((x>=x1) && (x<=x2))
   	    ModalResult = cmOK;

	x1 = right-29;
	x2 = right-18;
   }
   else {x1 = right-15;x2 = right-4;};       
   /* close button */
   if (dsk->boxAttrib & bafClose) 
   {
    if ((x>=x1) && (x<=x2))
   	    ModalResult = cmCancel;
   }
   /* check button */
  }
  if (ModalResult) DestroyWindow(TopWindow);
 }
}

static BANKED void CheckMessages(void)
{
 short evType, ev, ret;
 byte x, x2, y, y2;
 char c;

 /* test timer */
 if (*Tvar == 0)
 {
  BrodCast(evFastTimer, 0, 0);
  *Tvar = 8;
  if (TimCnt == 64)
  {
   BrodCast(evTimer, 0, 0);
   TimCnt = 0;
  }
  else TimCnt += 8;
 }
 
 /* if comm port opened */
 if (ComPort.Opened)
 {
  do
  {
   c = ReceiveByte();
   if (c) PostMessage(ComPort.Handler, evComChar, c, 0);
  }while(c && (Cur_Msg<(MAX_MSGS/2)));
 }
  /* get an event */
 evType = GetMyEvent(&x, &y);
 
 if ((PenIsDown) && (evType == 0)) {PenIsDown=FALSE;evType = evPenUp;}
 else
 if((evType == 255) && (!PenIsDown)) {PenIsDown = TRUE;evType = evPenDown;oldx=x;oldy=y;}
 else
 if ((evType == 255) && (PenIsDown)) 
 {
  if ((oldx == x) && (oldy == y)) evType = evPenAuto;
  else evType = evPenDownMove;
 }
 else
 if (TestPutEvent(&x2, &y2))
 {
  evType = GetEvent(&x, &y);
  ev = evType;
  ClearEvent(&evType);
  PostMessage(LastWin, ev, x, y);
  return;
 }
  
 ev = evType;

 switch(evType)
 {
  case evPaint:
    	break;

  case evNothing:
		break;
  
  case evTimer:
 		BrodCast(evType, x, y);
 		break;
 
  case evPenDown:
  case evKeyDown:
  case evPen:
  case evPenDownMove:
  case evPenAuto:
  case evPenUp:
  		LastWin = FindClickedWindow( x, y);
        if (Windows[TopWindow].Modal && LastWin != TopWindow) 
		{
		 WarningBeep();
		 LastWin = TopWindow;
		}
        else
        {
         if (LastWin>=0) PostMessage(LastWin, evType, x, y);		
         /* case pen down check modal controls */		 
         if (evType == evPenDown) CheckModalControls(x, y);
        }break;
   
  case evCommand:
 /*	default:*/
         if (LastWin>=0) PostMessage(LastWin, evType, x, y);
 		/*ClearEvent(&evType);*/
		break;
 }
}

BANKED short CreateModalWindow(CONST_FAR_PTR Win, byte owner, int Mode)
{
 byte h, x, y, cnt, hnd;
 short ret;
 unsigned short  evType;
 byte t, b, r;
 int z;
 byte TW;
 byte *buf;
 
 /* save covered area of screen */
 TW = TopWindow;

 /* create new window */
 Windows[h].Modal = TRUE;
 
 h = CreateWindow(Win);
 
 cnt = 2;
 while(PeekMessage(&hnd, &evType, &x, &y) && (cnt>0))
 {
  if (hnd != h) PostMessage(hnd, evType, x, y);
  else cnt--;
 }
 
 TopWindow = h;

 if (Windows[h].wDir != GetDisplayDirection())
     ResourceRotate(Windows[h].wDir);
 
 if (Mode)
 {
  PostMessage(h, evShow, 0, 0);
  ret = ExecView ((PGROUP *) Windows[h].Wnd);
  DestroyWindow(h);
  /*PostMessage(owner, evPaint, 0, 0);*/
 }
 else
 {
  /*GetWindowsRect(h, &r);*/
  /* window rotated, screen rotated */
  
  t = Windows[h].wtop;
  b = Windows[h].wbottom;
  r = ScreenWidth();
  
  z =  b-t;
  z *= (r/8);
  /*if (z>3000) buf = (byte *) 0;
  else */ buf = AllocBlock(z, 'B', 0);

  if (buf) BackupWindow(0, t, r-1, b, buf);
  else     BackupWindow(0, 0, r-1, ScreenHeight()-1, GetLCDBackBufAddr());

  PostMessage(h, evPaint, 0, 0);
  PostMessage(h, evShow, 0, 0);

  while(Windows[h].used)
  {
   CheckMessages();
   DispatchMessages();
  }

  /* restore screen */
  if (buf)	{RestoreWindow(0, t, buf, PUT);FreeBlock(buf);}
  else		RestoreWindow(0, 0, GetLCDBackBufAddr(), PUT);
 }

 if (Windows[owner].wDir != GetDisplayDirection())
	ResourceRotate(Windows[owner].wDir);

 TopWindow = TW;
 /* PostMessage(owner, evPaint, 0, 0);*/
 /*BrodCast(evPaint, 0, 0);*/

 /*return ret;*/
 return ModalResult;
}

BANKED byte CreateWindow(CONST_FAR_PTR Win)
{
 byte i;
 PDESKBOX *v;
 
 i = FindFreeWindow();
 if (i>=0)
 {
  fmemcpy(&Windows[i], Win, sizeof(Window));
  /*
  Windows[i].wTitle = MK_FAR_PTR(TestTitle);
  Windows[i].wMenu = MK_FAR_PTR(TestMenu);
  */
  Windows[i].used = TRUE;

  v = (PDESKBOX *)
   CreateDeskBox('A', Windows[i].wleft, Windows[i].wtop, 
                 Windows[i].wright, Windows[i].wbottom,
                 Windows[i].wTitle, Windows[i].wMenu, 0,
                 Windows[i].wflags);

  Windows[i].Wnd = v;
  BankedAssign(v->handleEvent, WinProcHandler);
  BankedAssign(v->draw, WinDrawHandler);

  /*Windows[i].Modal = FALSE;*/
  TopWindow = i;

  /* dispatch the OnCreate message */
  PostMessage(i, evCreate,0, 0);
  if (Windows[i].Modal) DispatchMessages();

  /* Avocet MODAL windows, no paint needed */
  PostMessage(i, evPaint,0, 0);
  /* window shows for the first time */
  PostMessage(i, evShow,0, 0);
  
  NumWindows++;
 }
 return i;
}


static BANKED short RunApplication(void)
{
 short ret;
 
 /* resolve timer */
 Tvar = (byte *) 0xC207;
 *Tvar = 8;
 TimCnt = 0;
 /*return (ExecView ((PGROUP *) Windows[handle].Wnd));*/
 ret = APPLICATION; 
 
 do
 {
  DispatchMessages();

  CheckMessages();
 /*  if((TopWindow != TW) && (Modal)) return ModalResult;*/
 }while(NumWindows>0);

 return ret;
}


BANKED void DrawSystemIcon(byte x, byte y, int icon_number, int mode)
{
.asm
    ld  b, a
    ld  c, l
; get mode 
	ld	l,(ix+0Fh)
	ld	h,(ix+0Fh)
	push hl
; get icon
    ld	l,(ix+0Ch)
	ld	h,(ix+0Dh)
	push hl
	
; get x 
	ld	l,c
; get y 
	ld	e,a

    call 0168h
    pop bc
    pop bc
.endasm
}

static BANKED void SysWndProc(byte handle, short evType, byte x, byte y)
{
 switch(evType)
 {
  case evPaint:	ClearLCD(0);
 }
}

short main()
{
 memset(&Windows, 0, sizeof(Window)*MAX_WINDOWS);
 memset(&ComPort, 0, sizeof(TComPort));
 Cur_Msg = 0;

 SysTempWin.wTitle = 0;
 SysTempWin.wMenu =  0;
 SysTempWin.wleft = 0;
 SysTempWin.wtop = 0;
 SysTempWin.wright = 159;
 SysTempWin.wbottom = 239;
 SysTempWin.Modal = FALSE;
 SysTempWin.wDir = 0;
 SysTempWin.wflags = 0;
 
 BankedAssign(SysTempWin.WndProc, SysWndProc);
 CreateWindow(MK_FAR_PTR(SysTempWin));

 DispatchMessages();
 
 WinMain();

 return(RunApplication());
}


/****   ccmmmunications */

BANKED void CloseComm(void)
{
 if(!ComPort.Opened) return;

.asm
	ld		hl,(_AutoWakeUp)
	ld		a,l
	ld      (c04bh),a
.endasm

 ComPort.Opened = FALSE;
}

static BANKED void InitComm(short Mode, short Rate)
{
 if(!ComPort.Opened) return;

.asm
;Here is where the communications happens.
;get rate
	ld		l,(ix+2)
  	ld		h,(ix+3)
  	ld		d,h
  	ld		e,l
; get Mode
	ld		l,(ix)
  	ld		h,(ix+1)
	call    018CH      ;initialize communications
	ld      b,10
.endasm

/* set autowakeup off */
.asm
	ld      a,(c04bh)
	ld		h,0
	ld 		l,a
	ld		(_AutoWakeUp),hl
	or      a,1
	ld      (c04bh),a
.endasm 
}
    

BANKED void SendByte(byte Byte)
{
 if(!ComPort.Opened) return;

.asm
;	ld	l,(ix)
;	ld	h,(ix+1)
	ld      l,a
	call    0192H        ;send byte back
.endasm
 /* infra red, remove echo ! */
 if (!ComPort.Mode) ReceiveByte();
}

static BANKED byte ReceiveByte(void)
{
.asm
	PUSH    BC
	LD      B,FFH
RB2loop:
	IN      A,(35H)
	LD      C,A
	AND     1EH
	JR      NZ,RB2skip1
	BIT     0,C
	JR      NZ,RB2skip2
	DJNZ    RB2loop
	LD      A,00H
	LD      B,01H
	BIT     0,B
	JR      RB2exit
RB2skip1:
	IN      A,(30H)
	LD      A,00H
	LD      B,01H
	BIT     0,B
	JR      RB2exit
RB2skip2:
	IN      A,(30H)
	LD      B,00H
	BIT     0,B
RB2exit:
	POP     BC

	ld	hl,0
;	ld	h,1
	jr  z, RB2exit2
	ret
RB2exit2:
	ld	l,a
.endasm
}


BANKED char tolower(char c)
{
 if(c<='Z' && c>='A') return (c+32);
 return (c);
}

BANKED char toupper(char c)
{
 if(c<='z' && c>='a') return (c-32);
 return (c);
}

BANKED void strupr(char *s)
{
 while(*s)
 {
  *s = toupper(*s);
  s++;
 }
}

BANKED void strlwr(char *s)
{
 while(*s) 
 {
  *s = tolower(*s);
  s++;
 }
}



