#include "ressdk.h"
#include "packet.h"
#include "f_sdkapi.h"
#include "..\windows.h"
#include "modal.h"

#define mcExit		0x0103
#define mcOK		0x0105

static const ModalTitle[] = "Title";
static const MENUITEM ModalMenu[2] = 
{
 "Exit",    mcExit,  0
};

static BANKED void OnModalCommand(byte handle, word Cmd)
{
 switch(Cmd)
 {
  case mcExit:
  case mcOK:  
  	  DestroyWindow(handle);
      break;
 }
}


static BANKED void ModalWndProc(byte handle, short evType, byte x, byte y)
{
 rect r;
 PVIEW *btn;

 switch(evType)
 {
  case evCommand:
		OnModalCommand(handle, ((word) x << 8) | (word) y);
		break;

  case evCreate:
  		GetWindowsRect(handle, &r);
  		
  		btn = (PVIEW *) CreateButton('B', r.right-40, r.bottom-22, r.right-5, MK_FAR_PTR("Ok"), mcOK, bttBasic);
  		InsertControl(handle, (PVIEW *) btn);
  		break;

  case evPaint:
  case evDestroy:
  case evPenDown:
  case evPenUp:
  case evTimer:
  case evFastTimer:
  case evPenDownMove:
  case evKeyDown:
  		break;
 }
}

BANKED void ModalWindow(int Modal, byte handle)
{
 Window Win;
 short ret;

 Win.wTitle = MK_FAR_PTR(ModalTitle);
 Win.wMenu =  MK_FAR_PTR(ModalMenu);
 Win.wleft = 30;
 Win.wtop = (ScreenHeight()-100)/2;
 Win.wright = ScreenWidth()-Win.wleft;
 Win.wbottom = Win.wtop+100;
 Win.Modal = Modal;
 Win.wDir = GetDisplayDirection();
 Win.wflags = bafClose | bafCheck | bafDotTitle;

 BankedAssign(Win.WndProc, ModalWndProc);

 if (Modal) ret = CreateModalWindow(MK_FAR_PTR(Win), handle, FALSE);
 else CreateWindow(MK_FAR_PTR(Win));
}
