#include "ressdk.h"
#include "packet.h"
#include "f_sdkapi.h"
#include "memo.h"
#include "defaults.h"
#include "viewmemo.h"
#include "comp.c"

/*
extern int MemoCnt;
extern int CurPos;
extern int HidePriv;
*/
const char CompHeader[] = "This memo is compressed, do not edit !";

void ViewMemo(int index)
{
 PDESKBOX *dsk;
 int MemoSize;

 CurRecord = index;
 dapLoadIndexTable(TYPE_MEMO);
 MemoSize = dapGetRecordSize(index) - sizeof(PIMHEAD) - sizeof(RECHEAD);

 memset(MemoText,0,MAX_MEMO_SIZE);

 /*GetMemoTitle(index, ViewerTitle);*/
 dsk = (PDESKBOX *) CreateViewerWindow();
 fmemcpy(MemoText, GetMemoText(index), MemoSize);
 Pos = MemoText;

 if (MemoText[0] == 0x02)
 {
  Decode(&MemoText[1], MemoSize-1, OutBuffer, MAX_MEMO_SIZE);
  strcpy(MemoText, OutBuffer);
 }

 ExecView ((PGROUP *) dsk);

 Destroy ((VOID_PTR) dsk);
}


void DrawMemo(void)
{
 char *p,
      *p2,
      *TextPos,
      oldchar;
 int i,y;

 SetFontType(PRPFONT11B);
 TextPos = Pos;

 ClearLCDArea(2,20,158,220,0);

 for(i=0,y=20; (i<17) && (TextPos); i++, y+=12)
 {
  if (TextPos)
  {
   p2 = p = strstr(TextPos,"\n");
   if (p) 
   {
    p2 = p;
    oldchar = *p;
    *p = NULL;

    if (strlen(TextPos)>28)
    {
     *p = oldchar;
     oldchar = TextPos[27];
     TextPos[27]=NULL;
     p2 = p = &TextPos[27];
    }
    else p++;
   }

   WriteString(2,y,TextPos,0);

   TextPos = p;
   if (p2) *p2 = oldchar;
  }
 }
}


void ViewerDrawHandler(VOID_PTR thisView)
{
 PDESKBOX_draw(thisView);
 DrawMemo();
}


void ViewerProcHandler(VOID_PTR thisView, unsigned short *evType, unsigned char x, unsigned char y)
{
 int i, outsize;

 /* default system proc handler */
 PDESKBOX_handleEvent(thisView, evType, x, y);
 /* dispatch messages */
 switch(*evType)
 {
  case evCommand: 
     switch(((WORD) x << 8) | (WORD) y)
     {
      case cmPgDn:
        /*if (*Pos) Pos++;*/
        Pos = strstr(Pos,"\n");
        if (Pos) Pos++;
        else     Pos = MemoText;
        DrawMemo();
        break;

      case cmPgUp:
        Pos = MemoText;
        DrawMemo();
        break;

      case mcClose:
        EndState = mcClose;
        break;

      case mcComp:
		strcpy(OutBuffer, CompHeader);
        OutBuffer[0] = 0x02;
		Encode(MemoText, strlen(MemoText), &OutBuffer[1], &outsize);
        outsize++;
		/* save the new memo */
		CreateMemo(MK_FAR_PTR("test compressed"), MK_FAR_PTR(OutBuffer), outsize);
        break;
     }
     break;

  case evPenDown :
     break;

  case evPenDownMove :
     break;

  case evPenAuto :
     break;

  case evPenUp :
     break;

  /*case evPen :*/
     
  case evKeyDown:
       switch(x)
       {
  		/* pgdn */
  		case 7: 
            for (i=0; i<16; i++)
            {
             Pos = strstr(Pos,"\n");
             if (Pos) Pos++;
             else  
             {
              Pos = MemoText;
              break;
             }
            }
            DrawMemo();
    		break;

    	/* pgup */
 		case 6: 
            Pos = MemoText;
            DrawMemo();
    		break;
 		}
     	break;

  case evTimer :
     break;

  default:
     break;
 }
/* ApplicationProcHandler(thisView, evType, x, y);*/
}


VOID_PTR CreateViewerWindow(void)
{
 VOID_PTR retval;
 PDESKBOX *dsk;

 dsk = (PDESKBOX *) 
   CreateDeskBox('B', 0, 0, 159, 239, MK_FAR_PTR(ViewerTitle), 
                 MK_FAR_PTR(ViewerMenu), 0, bafClose|bafDotTitle);
 dsk->options &= ~ofFindable;

 BankedAssign(dsk->handleEvent, ViewerProcHandler);
 BankedAssign(dsk->draw, ViewerDrawHandler);

 InsertPageArrow((PDESKBOX *) dsk, 'A', (PVIEW *) dsk);

 retval = dsk;
 return retval;
}

short main(void)
{
 /* call when testing compress */
 ViewMemo(1);
 /* call when testing decompress */
 /*ViewMemo(14);*/
}

