
#define KEYB_TOP		169

#define	mcAbout			0x0100
#define	mcKeyboard		0x0101
#define	mcGlyph			0x0102

#define KEY_CAPS		300
#define KEY_SHIFT		301
#define KEY_SYMBOL		303
#define KEY_SPACE		304
#define KEY_ACC1		305
#define KEY_ACC2		306
#define KEY_ACC3		307
#define KEY_ACC4		308
#define KEY_BACKSPACE	309
#define KEY_CANCEL		310

#define MODE_CAPS		  1
#define MODE_SHIFT		  2
#define MODE_SYMBOL		  4
#define MODE_ACC1		  8
#define MODE_ACC2		 16
#define MODE_ACC3		 32
#define MODE_ACC4		 64
#define MODE_PASSWORD	128

typedef struct TagKeyboards
{
 byte Mode;
 int  Keyb;
}Keyboard;

typedef struct TagCoord
{ 
 rect r;
 int  key;
 byte Mode;
}Coord;

const char KeybTitle[] = "Keyboard";
const char KeybAbout[] = "Keyboard by O.Civiol, Glyph by R.Bates";

const MENUITEM KeybMenu[4] = 
{
 "Keyboard",	mcKeyboard,		0,
 "AviGlyph",	mcGlyph,		lstUnderLine,
 "About",   	mcAbout,		0
};

/* keyboards */
static const char FR_LowerCharTable[] =
{
 '`','1','2','3','4','5','6','7','8','9','0',
 '\t','a','z','e','r','t','y','u','i','o','p','-',
 'q','s','d','f','g','h','j','k','l','\n',
 'w','x','c','v','b','n','m',',','.','/',' '
};

static const char FR_CapsCharTable[] =
{
 '`','1','2','3','4','5','6','7','8','9','0',
 '\t','A','Z','E','R','T','Y','U','I','O','P','-',
 'Q','S','D','F','G','H','J','K','L','\n',
 'W','X','C','V','B','N','M',',','.','/',' '
};

static const char FR_ShiftCharTable[] = 
{
 '~','!','@','#','$','%','^','&','*','(',')',
 '\t','A','Z','E','R','T','Y','U','I','O','P','_',
 'Q','S','D','F','G','H','J','K','L','\n',
 'W','X','C','V','B','N','M','<','>','?',' '
};

static const char FR_ShiftCapsCharTable[] =
{
 '~','!','@','#','$','%','^','&','*','(',')',
 '\t','a','z','e','r','t','y','u','i','o','p','_',
 'q','s','d','f','g','h','j','k','l','\n',
 'w','x','c','v','b','n','m',',','.','/',' '
};

static const char US_LowerCharTable[] =
{
 '`','1','2','3','4','5','6','7','8','9','0',
 '\t','q','w','e','r','t','y','u','i','o','p','-',
 'a','s','d','f','g','h','j','k','l','\n',
 'z','x','c','v','b','n','m',',','.','/',' '
};

static const char US_CapsCharTable[] =
{
 '`','1','2','3','4','5','6','7','8','9','0',
 '\t','Q','W','E','R','T','Y','U','I','O','P','-',
 'A','S','D','F','G','H','J','K','L','\n',
 'Z','X','C','V','B','N','M',',','.','/',' '
};

static const char US_ShiftCharTable[] = 
{
 '~','!','@','#','$','%','^','&','*','(',')',
 '\t','Q','W','E','R','T','Y','U','I','O','P','_',
 'A','S','D','F','G','H','J','K','L','\n',
 'Z','X','C','V','B','N','M','<','>','?',' '
};

static const char US_ShiftCapsCharTable[] =
{
 '~','!','@','#','$','%','^','&','*','(',')',
 '\t','q','w','e','r','t','y','u','i','o','p','_',
 'a','s','d','f','g','h','j','k','l','\n',
 'z','x','c','v','b','n','m',',','.','/',' '
};

static const byte SymbolsCharTable[] =
{
 0xC6, 0xE6, 0x8A, 0x9A, 0xA3, 0xA5, 0x27, 0x22, 0x5C, 0x7C, 
 0x8C, 0x9C, 0xD8, 0xF8, 0xBF, 0xA1, 0x3A, 0x3B, 0x5B, 0x5D,
 0xC5, 0xE5, 0xC7, 0xE7, 0xD0, 0xF0, 0x2B, 0x3D, 0x7B, 0x7D, 
 0xC3, 0xE3, 0xD1, 0xF1, 0xDF
};


/* keys coordinates */

static const Coord SymbCoords[] =
{
 /* first line */
 {  2, KEYB_TOP+1,  16, KEYB_TOP+18},			0,			0,
 { 18, KEYB_TOP+1,  32, KEYB_TOP+18},			1,			0,
 { 34, KEYB_TOP+1,  48, KEYB_TOP+18},			2,			0,
 { 50, KEYB_TOP+1,  63, KEYB_TOP+18},			3,			0,
 { 65, KEYB_TOP+1,  80, KEYB_TOP+18},			4,			0,
 { 82, KEYB_TOP+1,  96, KEYB_TOP+18},			5,			0,
 { 98, KEYB_TOP+1, 112, KEYB_TOP+18},			6,			0,
 {114, KEYB_TOP+1, 128, KEYB_TOP+18},			7,			0,
 {130, KEYB_TOP+1, 144, KEYB_TOP+18},			8,			0,
 {146, KEYB_TOP+1, 158, KEYB_TOP+18},			9,			0,
 /* second line */
 {  2,KEYB_TOP+20,  16, KEYB_TOP+35},			10,			0,
 { 18,KEYB_TOP+20,  32, KEYB_TOP+35},			11,			0,
 { 34,KEYB_TOP+20,  48, KEYB_TOP+35},			12,			0,
 { 50,KEYB_TOP+20,  63, KEYB_TOP+35},			13,			0,
 { 65,KEYB_TOP+20,  80, KEYB_TOP+35},			14,			0,
 { 82,KEYB_TOP+20,  96, KEYB_TOP+35},			15,			0,
 { 98,KEYB_TOP+20, 112, KEYB_TOP+35},			16,			0,
 {114,KEYB_TOP+20, 128, KEYB_TOP+35},			17,			0,
 {130,KEYB_TOP+20, 144, KEYB_TOP+35},			18,			0,
 {146,KEYB_TOP+20, 158, KEYB_TOP+35},			19,			0,
 /* third line */
 {  2,KEYB_TOP+37,  16, KEYB_TOP+52},			20,			0,
 { 18,KEYB_TOP+37,  32, KEYB_TOP+52},			21,			0,
 { 34,KEYB_TOP+37,  48, KEYB_TOP+52},			22,			0,
 { 50,KEYB_TOP+37,  63, KEYB_TOP+52},			23,			0,
 { 65,KEYB_TOP+37,  80, KEYB_TOP+52},			24,			0,
 { 82,KEYB_TOP+37,  96, KEYB_TOP+52},			25,			0,
 { 98,KEYB_TOP+37, 112, KEYB_TOP+52},			26,			0,
 {114,KEYB_TOP+37, 128, KEYB_TOP+52},			27,			0,
 {130,KEYB_TOP+37, 144, KEYB_TOP+52},			28,			0,
 {146,KEYB_TOP+37, 158, KEYB_TOP+52},			29,			0,
 /* fourth line */
 {  2,KEYB_TOP+54,  16, KEYB_TOP+69},			30,			0,
 { 18,KEYB_TOP+54,  32, KEYB_TOP+69},			31,			0,
 { 34,KEYB_TOP+54,  48, KEYB_TOP+69},			32,			0,
 { 50,KEYB_TOP+54,  63, KEYB_TOP+69},			33,			0,
 { 65,KEYB_TOP+54,  80, KEYB_TOP+69},			34,			0,
 { 82,KEYB_TOP+54, 158, KEYB_TOP+69},	KEY_CANCEL,	MODE_SYMBOL,
 /* end of struct */
 {  0,			 0,   0,		   0},		   0,			0 
};


static const Coord KeybCoords[] =
{
 {  1, KEYB_TOP+43,  27, KEYB_TOP+55},	KEY_SHIFT,	MODE_SHIFT,
 {  1, KEYB_TOP+29,  20, KEYB_TOP+41},	KEY_CAPS,	MODE_CAPS,
 {117, KEYB_TOP+57, 157, KEYB_TOP+69},	KEY_SYMBOL,	MODE_SYMBOL,
 {  1, KEYB_TOP+57,  13, KEYB_TOP+69},	KEY_ACC1,	MODE_ACC1,
 { 15, KEYB_TOP+57,  27, KEYB_TOP+69},	KEY_ACC2,	MODE_ACC2,
 { 29, KEYB_TOP+57,  41, KEYB_TOP+69},	KEY_ACC3,	MODE_ACC3,
 { 43, KEYB_TOP+57,  55, KEYB_TOP+69},	KEY_ACC4,	MODE_ACC4,
 /* normal keyboard keys, first line */
 {  2, KEYB_TOP+1,    13,KEYB_TOP+13},		   0,			0, 
 { 15, KEYB_TOP+1,	  26,KEYB_TOP+13},		   1,			0, 
 { 28, KEYB_TOP+1,	  39,KEYB_TOP+13},		   2,			0, 
 { 41, KEYB_TOP+1,	  52,KEYB_TOP+13},		   3,			0, 
 { 54, KEYB_TOP+1,	  65,KEYB_TOP+13},		   4,			0, 
 { 67, KEYB_TOP+1,	  78,KEYB_TOP+13},		   5,			0, 
 { 80, KEYB_TOP+1,	  91,KEYB_TOP+13},		   6,			0, 
 { 93, KEYB_TOP+1, 	 104,KEYB_TOP+13},		   7,			0, 
 {106, KEYB_TOP+1,	 117,KEYB_TOP+13},		   8,			0, 
 {119, KEYB_TOP+1,	 130,KEYB_TOP+13},		   9,			0, 
 {132, KEYB_TOP+1, 	 143,KEYB_TOP+13},		  10,			0, 
 {145, KEYB_TOP+1, 	 158,KEYB_TOP+13},	KEY_BACKSPACE,		0, 
 /* second line */
 {  2, KEYB_TOP+15,   15,KEYB_TOP+27},		  11,			0, 
 { 17, KEYB_TOP+15,	  28,KEYB_TOP+27},		  12,			0, 
 { 30, KEYB_TOP+15,	  41,KEYB_TOP+27},		  13,			0, 
 { 43, KEYB_TOP+15,	  54,KEYB_TOP+27},		  14,			0, 
 { 56, KEYB_TOP+15,	  67,KEYB_TOP+27},		  15,			0, 
 { 69, KEYB_TOP+15,	  80,KEYB_TOP+27},		  16,			0, 
 { 82, KEYB_TOP+15,	  93,KEYB_TOP+27},		  17,			0, 
 { 95, KEYB_TOP+15,	 106,KEYB_TOP+27},		  18,			0, 
 {108, KEYB_TOP+15,	 119,KEYB_TOP+27},		  19,			0, 
 {121, KEYB_TOP+15,	 132,KEYB_TOP+27},		  20,			0, 
 {134, KEYB_TOP+15,	 145,KEYB_TOP+27},		  21,			0, 
 {147, KEYB_TOP+15,	 158,KEYB_TOP+27},		  22,			0, 
 /* third line */
 { 23, KEYB_TOP+29,	  34,KEYB_TOP+41},		  23,			0, 
 { 36, KEYB_TOP+29,	  47,KEYB_TOP+41},		  24,			0, 
 { 49, KEYB_TOP+29,	  60,KEYB_TOP+41},		  25,			0, 
 { 62, KEYB_TOP+29,	  73,KEYB_TOP+41},		  26,			0, 
 { 75, KEYB_TOP+29,	  86,KEYB_TOP+41},		  27,			0, 
 { 88, KEYB_TOP+29,	  99,KEYB_TOP+41},		  28,			0, 
 {101, KEYB_TOP+29,	 112,KEYB_TOP+41},		  29,			0, 
 {114, KEYB_TOP+29,	 125,KEYB_TOP+41},		  30,			0, 
 {127, KEYB_TOP+29,	 138,KEYB_TOP+41},		  31,			0,
 {140, KEYB_TOP+29,	 158,KEYB_TOP+41},		  32,			0,
 /* fourth line */
 { 30, KEYB_TOP+43,	  41,KEYB_TOP+55},		  33,			0, 
 { 43, KEYB_TOP+43,	  54,KEYB_TOP+55},		  34,			0, 
 { 56, KEYB_TOP+43,	  67,KEYB_TOP+55},		  35,			0, 
 { 69, KEYB_TOP+43,	  80,KEYB_TOP+55},		  36,			0, 
 { 82, KEYB_TOP+43,	  93,KEYB_TOP+55},		  37,			0, 
 { 95, KEYB_TOP+43,	 106,KEYB_TOP+55},		  38,			0, 
 {108, KEYB_TOP+43,	 119,KEYB_TOP+55},		  39,			0, 
 {121, KEYB_TOP+43,	 132,KEYB_TOP+55},		  40,			0, 
 {134, KEYB_TOP+43,	 145,KEYB_TOP+55},		  41,			0, 
 {147, KEYB_TOP+43,	 158,KEYB_TOP+55},		  42,			0,
 /* fifth line */
 { 58, KEYB_TOP+57, 116, KEYB_TOP+69},		  43,			0,   
 /* end of structure */
 {  0,			 0,   0,		   0},		   0,			0 
};

static const Keyboard Keyboards[] =
{
 {0,								189},	/* standard */
 {MODE_CAPS,						190},
 {MODE_SHIFT,						191},
 {MODE_SYMBOL,						210},
 {MODE_PASSWORD,					211},
 {MODE_CAPS+MODE_SHIFT,				192},

 {MODE_ACC1,						194},
 {MODE_ACC1+MODE_CAPS,				195},
 {MODE_ACC1+MODE_SHIFT,				196},
 {MODE_ACC1+MODE_CAPS+MODE_SHIFT,	197},

 {MODE_ACC2,						198},
 {MODE_ACC2+MODE_CAPS,				199},
 {MODE_ACC2+MODE_SHIFT,				200},
 {MODE_ACC2+MODE_CAPS+MODE_SHIFT,	201},

 {MODE_ACC3,						202},
 {MODE_ACC3+MODE_CAPS,				203},
 {MODE_ACC3+MODE_SHIFT,				204},
 {MODE_ACC3+MODE_CAPS+MODE_SHIFT,	205},

 {MODE_ACC4,						206},
 {MODE_ACC4+MODE_CAPS,				207},
 {MODE_ACC4+MODE_SHIFT,				208},
 {MODE_ACC4+MODE_CAPS+MODE_SHIFT,	209},

 {0,								  0}
};

extern BANKED int KeybWndProc(byte handle, unsigned short evType, byte x, byte y);


static byte CallerWin = -1;
static byte Mode=0;

static rect SavedRect;
static int 	RectSaved = FALSE;
static int  MustRestore = FALSE;
static byte OldMode;
static int  KeybMode = 1;

static char *LowerCharTable     = US_LowerCharTable; 
static char *CapsCharTable      = US_CapsCharTable; 
static char *ShiftCharTable     = US_ShiftCharTable;
static char *ShiftCapsCharTable = US_ShiftCapsCharTable;


