#include "p100plib.h"
#include "ressdk.h"
#include "math.h"
#include "packet.h"

#include "p100icon.h"

/* you have to decleare a static string for the window
  title 
*/

const int icons[4]={SPADES_ICON,HEARTS_ICON,DIAMONDS_ICON,CLUBS_ICON};
const char *cards[13]={"A","K","Q","J","T","9","8","7","6","5","4","3","2"};
const char *hand_name[4]={"N","O","S","W"};
int C[52]; /* cards 1-4 is owner of card */
typedef struct _cardstruct
{	int x1,y1,x2,y2,x3; /* plot rectangle */
	int c; /* card */
} cardstruct;
cardstruct card[4][13]; /* where are the cards ? */
int ncards[4]; /* how many cards in each hand */
int selected[4]; /* selected card (inverted) */
int xhand[4]={50,85,50,5};
int yhand[4]={20,75,130,75};
int height=50;
int width=70;
int next=-1; /* waiting for the next player */
int start=-1; /* who started that round of play */
int winner; /* winner of trick */
int follow=-1; /* played suit */
int trump=-1; /* trump suit */
int highest; /* highest card so far */
int played[4][14]; /* history of play */
int started[14]; /* who started at which round */
int won[14]; /* who won the trick at each round */
int round; /* round of play (length of history) */

PTEXTFIELD *Hand;
char hand[500]="";

unsigned char test_title[] = "Play Bridge";

#define cmdNew 100
#define cmdUndo 101
#define cmdReplay 102
#define cmdCompute 103
#define cmdTurn 104
#define cmdClear 105
#define cmdDescribe 106
#define cmdTurn1 107

void dump (int y)
{	static char s[16];
	NumericToStr((double)y,s,DTINTEGER);
	MessageBox(MK_FAR_PTR(s),mfOKButton);
}

void mark (int hand)
{	DrawRect(xhand[hand],yhand[hand],xhand[hand]+width,yhand[hand]+height,
		DRAW_XOR);
}

void make_hand_string ()
{	static char s[500];
	int i,j,count,c;
	s[0]=0;
	for (i=0; i<4; i++)
	{	strcat(s,hand_name[i]);
		for (c=0; c<4; c++)
		{	strcat(s," ");
			count=0;
			for (j=0; j<13; j++)
			{	if (C[c*13+j]==i+1)
				{	strcat(s,cards[j]);
					count++;
				}
			}
			if (count==0) strcat(s,"-");
		}
		strcat(s,"\n");
	}
	strcat(s,"# Use - for void!   ");
	strcpy(hand,s);
}

void set_hand_string ()
{	LoadBank(&(Hand->textLength));
	Hand->textLength=strlen(hand);
	PTEXTFIELD_draw((VOID_PTR)Hand);
}

char toupper (char c)
{	if (c>='a' & c<='z') c+='A'-'a';
	return c;
}

char * skip_blanks (char *p)
{	while (*p==' ' || *p=='\n') p++;
}

void compute_hand ()
{	static char str[64];
	static int cis[4][4]; /* cards in hand, suit */
	static int scis[4][4]; /* small cards in suit */
	static int fixed[4][4]; /* cards in hand, suit fixed or free */
	static int sum[4]; /* sum of all fixed and small cards in one hand */
	static int sums[4]; /* how many cards of suit are fixed */
	static int c[52]; /* local try to setup a hand */
	static int hc[52]; /* local try to setup a hand */
	char *p;
	int i,j,k,is,h,n;

	p=hand;
	
	/* clear all sums etc. */
	for (i=0; i<4; i++)
		for (j=0; j<4; j++)
		{	cis[i][j]=0;
			scis[i][j]=0;
			fixed[i][j]=0;
		}
	for (i=0; i<4; i++)
	{	sum[i]=0;
		sums[i]=0;
	}
	for (i=0; i<52; i++) c[i]=0;
	
	while (*p!=0) /* for at most 4 hands */
	{	p=skip_blanks(p);
		for (i=0; i<4; i++)
		{	if (toupper(*p)==hand_name[i][0]) /* hand found */
			{	p++;
				for (is=0; is<4; is++) /* for four suits */
				{	p=skip_blanks(p);
					if (*p=='-') /* check for void suit */
					{	cis[i][is]=scis[i][is]=0;
						fixed[i][is]=1;
						p++;
					}
					else if (*p=='?') /* check for unimportant suit */
					{	p++;
					}
					else while (1) /* check for cards */
					{	for (k=0; k<13; k++) /* find a card */
						{	if (toupper(*p)==cards[k][0])
							{	if (c[is*13+k]==0 && sums[is]<13 && sum[i]<13)
								{	c[is*13+k]=i+1;
									cis[i][is]++;
									fixed[i][is]=1;
									sum[i]++;
									sums[is]++;
									goto nextpos;
								}
								else
								{	if (sum[i]>=13) strcpy(str,"Too many cards in hand at\n");
									else if (sums[is]>=13) strcpy(str,"Too many cards in suit at\n");
									else if (c[is*13+k]!=0) strcpy(str,"Doubled card at\n");
									else strcpy(str,"Illegal hand at\n");
									n=strlen(str);
									strncpy(str+n,p,8);
									str[n+8]=0;
									strcat(str," ...");
									MessageBox(MK_FAR_PTR(str),
										mfOKButton);
									return;
								}
							}
						} /* end of card search */
						if (toupper(*p)=='X' && sums[is]<13 && sum[i]<13)
						{	scis[i][is]++;
							fixed[i][is]=1;
							sum[i]++;
							sums[is]++;
						}
						else break;
						nextpos: p++;
					} /* end of card search in one suit */
					p=skip_blanks(p);
				} /* end of four suits */
			} /* end of hand */
		}
		if (i>=4) break;
	} /* finished parsing the hands */
	
	p=skip_blanks(p);
	if (*p!=0 && *p!='#')
	{	strcpy(str,"Illegal input at\n");
		n=strlen(str);
		strncpy(str+n,p,8);
		str[n+8]=0;
		strcat(str," ...");
		MessageBox(MK_FAR_PTR(str),mfOKButton);
		return;
	}
	
	/* make hand */

	for (i=0; i<4; i++)
		for (is=0; is<4; is++)
		{	k=0;
			for (j=4; j<13; j++)
			{	if (c[is*13+j]==0)
				{	hc[k++]=is*13+j;
				}
			}
			for (j=k-1; j>1; j--)
			{	n=random(j+1);
				h=hc[n]; hc[n]=hc[j]; hc[j]=h;
			}
			for (j=0; j<scis[i][is] && j<k; j++)
				c[hc[j]]=i+1;
		}

	k=0;
	for (i=0; i<4; i++)
	{	for (j=sum[i]; j<13; j++)
		{	hc[k++]=i+1;
		}
		if (k>=52) break;
	}
	
	for (i=k-1; i>=1; i--)
	{	j=random(i+1);
		h=hc[i]; hc[i]=hc[j]; hc[j]=h;
	}

	j=0;
	for (i=0; i<52; i++)
	{	if (c[i]==0)
		{	c[i]=hc[j++];
		}
		if (j>=k) break;
	}
	
	for (i=0; i<52; i++) C[i]=c[i];
}

void generate ()
{	int i,j,h;
	for (i=0; i<52; i++) C[i]=i/13+1;
	for (i=51; i>=2; i--)
	{	j=random(i+1);
		if (j!=i)
		{	h=C[j]; C[j]=C[i]; C[i]=h;
		}		
	}
	if (next!=-1) mark(next);
	started[0]=next=start=follow=trump=-1;
	round=0;
	for (i=0; i<4; i++) selected[i]=-1;
}

int draw_card (int card, int x, int y)
{	if (card!=4) return (int)(WriteString(x,y,cards[card],0)+1);
	else
	{	DrawIcon(x,y,TEN_ICON,PUT);
		return x+9;
	}
}

void draw_suit (int hand, int suit, int x, int y)
{	int i,base;
	DrawIcon(x,y+2,icons[suit],PUT);
	x+=9; base=suit*13;
	for (i=0; i<13; i++)
	{	if (C[base+i]-1==hand)
		{	card[hand][ncards[hand]].x1=x;
			card[hand][ncards[hand]].y1=y;
			x=draw_card(i,x,y);
			card[hand][ncards[hand]].x2=x-1;
			card[hand][ncards[hand]].x3=x-1;
			card[hand][ncards[hand]].y2=y+10;
			card[hand][ncards[hand]].c=base+i;
			ncards[hand]++;
		}
	}
}

void draw_hand (int hand)
{	int i,x,y,h;
	x=xhand[hand];
	y=yhand[hand];
	FillRect(x,y,x+width,y+height,DRAW_WHITE);
	x+=2; y+=3;
	SetFontType(PRPFONT11N);
	ncards[hand]=0;
	for (i=0; i<4; i++)
	{	h=ncards[hand];
		draw_suit(hand,i,x,y);
		if (ncards[hand]>h)
		{	h=card[hand][ncards[hand]-1].x2;
			if (h<x+width-1) card[hand][ncards[hand]-1].x3=x+width-1;
		}
		y+=12;
	}
}

void draw_hands ()
{	int i;
	for (i=0; i<4; i++) draw_hand(i);
}
	
void draw_result ()
{	int i,ns,ew;
	static char str[32];
	ns=0;
	ew=0;
	for (i=0; i<round; i++)
	{	if (won[i]%2==0) ns++;
		else ew++;
	}
	strcpy(str,"N/S ");
	NumericToStr((double)ns,str+strlen(str),DTINTEGER);
	strcat(str," E/W ");
	NumericToStr((double)ew,str+strlen(str),DTINTEGER);
	strcat(str,"  ");
	WriteString(80,190,str,0);
}

void clear_selected ()
{	int i;
	for (i=0; i<4; i++) selected[i]=-1;
}

void invert_selected (int hand)
{	int i;
	i=selected[hand];
	if (i<0) return;
	FillRect(card[hand][i].x1,card[hand][i].y1,
		card[hand][i].x2,card[hand][i].y2,DRAW_XOR);
}

void select (int hand, int i)
{	invert_selected(hand);
	selected[hand]=i;
	invert_selected(hand);
}

int hascard (int hand, int suit)
{	int i;
	for (i=suit*13; i<suit*13+13; i++)
		if (C[i]==hand+1) return 1;
	return 0;
}

int play (int x, int y)
{	int i,j,k,c;
	for (i=0; i<4; i++)
	{	if (next!=-1 && next!=i) continue;
		for (j=0; j<ncards[i]; j++)
		{	if (card[i][j].x1<=x && card[i][j].y1<=y &&
				card[i][j].x3>=x && card[i][j].y2>=y)
			{	c=card[i][j].c;
				if (follow!=-1 && hascard(i,follow) && (c/13)!=follow) 
					continue;
				select(i,j);
				played[i][round]=c;
				if (next!=-1) mark(next);
				if (follow==-1 || next==-1)
				{	follow=c/13;
					start=i;
					winner=start;
					highest=c;
					next=i;
					started[round]=i;
				}
				else
				{	if (
						(c/13==highest/13 && c<highest) ||
						(c/13!=highest/13 && c/13==trump)
						)
					{	winner=next;
						highest=c;
					}
				}
				next=(i+1)%4;
				if (next==start) /* all played */
				{	for (k=0; k<4; k++)
					{	C[card[k][selected[k]].c]=
							-C[card[k][selected[k]].c];
						selected[k]=-1;
						draw_hand(k);
					}
					next=winner;
					follow=-1;
					won[round]=winner;
					round++;
					for (k=0; k<4; k++) played[k][round]=-1;
					draw_result();
				}
				mark(next);
				return 1;
			}
		}
	}
	return 0;
}

void restart ()
{	int i;
	if (next!=-1) mark(next);
	for (i=0; i<52; i++)
		if (C[i]<0) C[i]=-C[i];
	for (i=0; i<4; i++) selected[i]=-1;
	next=-1; follow=-1; 
	round=0;
}

void replay ()
{	restart();
	draw_hands();
}

void undo ()
{	int i;
	if (next!=-1) mark(next);
	if (follow=-1 && round>0)
	{	round--;
		for (i=0; i<4; i++)
		{	if (played[i][round]>=0) C[played[i][round]]=-C[played[i][round]];
			played[i][round]=-1;
		}
	}
	for (i=0; i<4; i++) selected[i]=-1;
	draw_hands();
	if (round>0) next=started[round]; 
	else next=-1;
	follow=-1;
	if (next!=-1) mark(next);
}

/* you have to declare the event handlers BANKED and extern
*/

extern BANKED void test_draw (VOID_PTR view);
extern BANKED void test_handle_event (VOID_PTR view,
    unsigned short *evType, unsigned char x, unsigned char y);

/* define the command constants (belongs to a header file)
*/

int id=100;

MENUITEM MainMenu[] =
{   {"Undo Trick",cmdUndo, 0},
	{"Replay Hand",cmdReplay, 0},
	{"Turn Right", cmdTurn, 0},
	{"Turn Left", cmdTurn1, 0},
	{"----",0, 0},
	{"Random Hand", cmdNew, 0},
	{"Describe", cmdDescribe, 0},
	{"----",0, 0},
	{"Clear", cmdClear, 0},
	{"Compute Hand", cmdCompute, 0},
	{"----",0, 0},
    {"Exit", cmCancel, 0},
	{"\0", 0, 0}
};

void draw_trump (int x, int y)
{	FillRect(x,y,x+12,y+10,DRAW_WHITE);
	if (trump==-1)
	{	WriteString(x,y,"NT",0);
	}
	else DrawIcon(x+3,y+2,icons[trump],PUT);
	DrawRect(x-2,y-2,x+14,y+14,DRAW_BLACK);
}

int change_trump (int x, int y)
{	if (round>0 || follow!=-1) return 0;
	if (x>48 && x<64 && y>188 && y<202)
	{	trump--;
		if (trump<-1) trump=3;
		draw_trump(50,190);
		return 1;
	}
	return 0;
}

void turn_hand ()
{	if (round>0 || follow!=-1) return;
	int i;
	for (i=0; i<52; i++)
	{	C[i]++;
		if (C[i]>4) C[i]=1;
	}
}

void turn1_hand ()
{	if (round>0 || follow!=-1) return;
	int i;
	for (i=0; i<52; i++)
	{	C[i]--;
		if (C[i]<1) C[i]=4;
	}
}

void test_draw (VOID_PTR view)
{   /* the pointer is really a pointer to a DESKBOX */
    PDESKBOX *dsk;
    int i;
    dsk=(PDESKBOX *)view;

    PDESKBOX_draw(view); /* default, clears the view */
    draw_hands();
    if (next!=-1) mark(next);
    if (follow!=-1)
    	for (i=0; i<4; i++) invert_selected(i);
    WriteString(5,190,"Trump",0);
    draw_trump(50,190);
    draw_result();
}

/* the event handler for the menu commands and for
 the main window
*/

void test_handle_event (VOID_PTR view,
    unsigned short *evType, unsigned char x, unsigned char y)
{   /* convert view to deskbox */
    PDESKBOX *dsk;
    dsk=(PDESKBOX *)view;

    /* call default handler (don't know why) */
    PDESKBOX_handleEvent(view,evType,x,y);

    /* switch events */
    if (*evType==evCommand)
    {   switch (TOWORD(x,y))
        {	case cmdNew :
        		generate();
        		draw_hands();
        		ClearEvent(evType);
        		break;
        	case cmdReplay :
        		replay();
        		ClearEvent(evType);
        		break;
        	case cmdUndo :
        		undo();	
        		ClearEvent(evType);
				break;
			case cmdCompute :
				restart();
				compute_hand();
				draw_hands();
        		ClearEvent(evType);
				break;
			case cmdTurn :
				turn_hand();
				draw_hands();
        		ClearEvent(evType);
				break;
			case cmdTurn1 :
				turn1_hand();
				draw_hands();
        		ClearEvent(evType);
				break;
			case cmdClear :
				strcpy(hand,"\n");
				set_hand_string();
        		ClearEvent(evType);
				break;
			case cmdDescribe :
				make_hand_string();
				set_hand_string();
        		ClearEvent(evType);
				break;
        }
    }
    
    if (*evType==evPenDown)
    {	ClearEvent(evType);
    	if (play(x,y)) return;
    	if (change_trump(x,y)) return;
    }
}

short main (void)
{
	generate();
	clear_selected();
    
    /* pointer to the main window (properly destroy it at end) */
    PDESKBOX *dsk;

    /* create a window covering all of the screen
       with a menu, a title and a close box */
    dsk = (PDESKBOX *)CreateDeskBox(id++,0,0,159,239,
        MK_FAR_PTR(test_title),MK_FAR_PTR(MainMenu),0,
        bafClose|bafDotTitle);
    dsk->options &= ~ofFindable; /* no find in this application */

	make_hand_string();

	Hand=(PTEXTFIELD *)CreateTextField(id++,
		5,210,155,225,hand,PRPFONT11N,14,498,
		MK_FAR_PTR("Enter Hand"));
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk,Hand);
	
	strcpy(hand,"\n");
	set_hand_string();
	
    /* assign the event handlers to this window */
    BankedAssign(dsk->handleEvent,test_handle_event);
    BankedAssign(dsk->draw,test_draw);

    /* seems to generate the main event loop */
    ExecView ((PGROUP *) dsk);

    /* destroy the window */
    Destroy ((VOID_PTR) dsk);

    return 0;
}

