/**********************************************************************
* Project:	Drobos for Avigo
* Module:	Main header
* File:		drobos.h
*
*	DRoboWHOids for Avigo Copyright (c) 1998 by Jouni Miettunen
*	DRoboWHOids for DOS Copyright (c) 1994 by Jouni Miettunen
*	which was based on unix robots by Allan Black (around 1984)
***********************************************************************
*
* Description:
*	DRoboWHOids (drobos) for Avigo. Avigo porting based on Sokoban
*	sample program from Freeware Avigo SDK made by G. Vermeulen
*
**********************************************************************/

#ifndef __DROBOS_H
#define __DROBOS_H

/***** Include files *****/
#include <avsys.h>
#include "avicons.h"
#include "avpref.h"
#include "gfx.h"

#define SPRITE(x,y) (_sprdata+(x/8)+(y*8))

/***** Defines *****/

#define PROGRAM_TITLE "DRoboWHOids"

/* Playing area offset from top of the screen */
#define OFFSET_Y 16
#define OFFSET_X 3
#define MX 19
#define MY 22

#define MODE_EXIT	0
#define MODE_CRASH	1
#define MODE_STAND	2
#define MODE_SONIC	3
#define MODE_NEW	4
#define MODE_ONETO	5
#define MODE_RUNME	6

#define CRASH_MULTIPLYER	10
#define STAND_MULTIPLYER	15
#define SONIC_MULTIPLYER	20

#define UPDATE_ALL   0xff
#define UPDATE_LEVEL 0x01
#define UPDATE_SCORE 0x02
#define UPDATE_SONIC 0x04
#define UPDATE_TELE  0x08
#define UPDATE_LAST  0x10
#define UPDATE_ONE2  0x20
#define UPDATE_BEST  0x40

#define EXIT_X1	145
#define EXIT_Y1	2
#define EXIT_X2	157
#define EXIT_Y2	12

#define MENU_X1 3
#define MENU_Y1 2
#define MENU_X2 15
#define MENU_Y2 12

#define OFFSET_SONIC_X	2
#define OFFSET_SONIC_Y	197
#define OFFSET_TELE_X	(OFFSET_SONIC_X)
#define OFFSET_TELE_Y	(OFFSET_SONIC_Y+14)
#define OFFSET_LAST_X	(OFFSET_TELE_X)
#define OFFSET_LAST_Y	(OFFSET_TELE_Y+14)
#define OFFSET_ONE2_X	(OFFSET_LAST_X)
#define OFFSET_ONE2_Y	(OFFSET_LAST_Y+14)

#define OFFSET_LEVEL_X	110
#define OFFSET_LEVEL_Y	(OFFSET_TELE_Y)
#define OFFSET_SCORE_X	(OFFSET_LEVEL_X)
#define OFFSET_SCORE_Y	(OFFSET_LEVEL_Y+14)

#define OFFSET_SONIC_LEN 65
#define OFFSET_TELE_LEN 65
#define OFFSET_LAST_LEN 65
#define OFFSET_ONE2_LEN 65

/* avas gives errors if this defined
typedef enum
{
	BUTTON_NONE = 0,
	BUTTON_EXIT,
	BUTTON_MENU,
	BUTTON_SMALL,
	BUTTON_LAST
} ButtonType;
*/

#define BUTTON_NONE	0
#define	BUTTON_EXIT	1
#define	BUTTON_MENU	2
#define	BUTTON_SMALL	3
#define	BUTTON_LAST	4

typedef struct
{
/*	ButtonType		type;*/
	int	type;
	unsigned char	title[16];
	unsigned char	x1;
	unsigned char	y1;
	unsigned char	x2;
	unsigned char	y2;
} BUTTON;

BUTTON
	buttonSonic =
	{
		BUTTON_SMALL,
		"Sonic",
		OFFSET_SONIC_X,
		OFFSET_SONIC_Y,
		OFFSET_SONIC_X +70,
		OFFSET_SONIC_Y + 12
	},
	buttonTele =
	{
		BUTTON_SMALL,
		"Teleport",
		OFFSET_TELE_X,
		OFFSET_TELE_Y,
		OFFSET_TELE_X +70,
		OFFSET_TELE_Y + 12
	},
	buttonLast =
	{
		BUTTON_SMALL,
		"LastStand",
		OFFSET_LAST_X,
		OFFSET_LAST_Y,
		OFFSET_LAST_X +70,
		OFFSET_LAST_Y + 12
	},
	buttonOnes =
	{
		BUTTON_SMALL,
		"One to One",
		OFFSET_ONE2_X,
		OFFSET_ONE2_Y,
		OFFSET_ONE2_X +70,
		OFFSET_ONE2_Y + 12
	},
	buttonExit =
	{
		BUTTON_EXIT,
		"",
		EXIT_X1,
		EXIT_Y1,
		EXIT_X2,
		EXIT_Y2
	},
	buttonMenu =
	{
		BUTTON_MENU,
		"",
		MENU_X1,
		MENU_Y1,
		MENU_X2,
		MENU_Y2
	};

/* Sprite definitions */
#define SPR_DROID_D SPRITE(0,0)
#define SPR_DROID_L SPRITE(8,0)
#define SPR_DROID_R SPRITE(16,0)
#define SPR_DROID_U SPRITE(24,0)
#define SPR_EMPTY SPRITE(32,0)
#define SPR_SCRAP SPRITE(40,0)
#define SPR_MAN SPRITE(48,0)
#define SPR_MASK SPRITE(56,0)
#define SPR_WALL SPRITE(0,8)
#define SPR_ZAP SPRITE(8,8)

#define TILE_EMPTY	0
#define TILE_WALL	1
#define TILE_DROID	2
#define TILE_DROID_D	3
#define TILE_DROID_L	4
#define TILE_DROID_R	5
#define TILE_DROID_U	6
#define TILE_MAN	7
#define TILE_SCRAP	8
#define TILE_ZAP	9

char* level_spr[] = 
{
	SPR_EMPTY,
	SPR_WALL,
	SPR_DROID_D,
	SPR_DROID_L,
	SPR_DROID_R,
	SPR_DROID_U,
	SPR_MAN,
	SPR_SCRAP,
	SPR_ZAP
};

/***** Global variables *****/
int
	gManx = 0,
	gMany = 0;
int
	gBestLevel = 0,
	gBestScore = 0,
	gLevel = 0,			/* Current game lavel */
	gDroids = 0,		/* Number of drobos alive */
	gPoints = 0,		/* Current score */
	gSonic = 0,			/* Number of Sonic Screwdrivers */
	gTele = 0,			/* Only first teleport is safe */
	gMode = MODE_EXIT;	/* Current game mode */

unsigned char
	gMap[MX][MY] = {{0}};

/***** Function prototypes */
int main();
void draw_button(BUTTON* button);
int handle_button(BUTTON* button);
void blit_sprite(int x,int y,unsigned char* spr);
void draw_tile(int x,int y);
void draw_level();
void move_man_ok(int dx,int dy);
int move_man();
int move_droids();
void move_mann(int dx,int dy);
void release_pen();
int handle_pen_press (int x,int y);
void init_screen();
void init_level();
void init_game();
void exit_game();
void exit_program();
void points_update(int nCount);
void draw_screen (int nUpdate);
void zap_around();
void do_teleport();
int do_laststand();

#endif /* __DROBOS_H */

/**********************************************************************/
/*************************** A HAPPY END ******************************/
/**********************************************************************/
