#include <stdio.h>
#include <stdlib.h>
#include <string.h>

FILE* infile=0;
FILE* outfile=0;
char* outfilename;
int bmph, bmpw, raww, nbytes=0;
unsigned char *bmpdata=0, *compdata=0;
;
unsigned char icon=0, compress=0, pixelw;

void exerr();

void openfiles(char* i,char* o)
{
    infile=fopen(i,"rb");
    if(!infile)
    {
        printf("cannot open '%s' for reading.\n",i);
        exerr();
    }

    outfile=fopen(o,"w");
    if(!outfile)
    {
        printf("cannot open '%s' for writing.\n",o);
        exerr();
    }
}

void closefiles(int rem)
{
    if(infile)
    {
        fclose(infile);
    }
    if(outfile)
    {
        fclose(outfile);
        if(rem)
        {
            remove(outfilename);
        }
    }
}

void exerr()
{
    closefiles(1);
    if(bmpdata)
    {
        free(bmpdata);
    }
    exit(1);
}

void readbmpheader()
{
    int i;
    
    i=0;
    fread(&i,1,2,infile);
    if(i!=0x4d42)
    {
        printf("error: bad bitmap file.\n");
        exerr();
    }
    fread(&i,1,4,infile);
    fread(&i,1,4,infile);
    fread(&i,1,4,infile);
    fread(&i,1,4,infile);
    fread(&i,1,4,infile);
    if( i!=64 && !icon)
    {
      printf("error: bitmap must be 64 pixels wide.\n");
      exerr();
    }
    pixelw = i;
    bmpw = (int)((i-1)/32+1) * 4; /* bytes per row in bmp. silly format. */
    raww = (i-1)/8 + 1;           /* raw bytes per row */
    fread(&i,1,4,infile);
    bmph=i;
    nbytes=raww*bmph;
    i=0;
    fread(&i,1,2,infile);
    if(i!=1)
    {
        printf("error: bitmap must be monochrome.\n");
        exerr();
    }
    i=0;
    fread(&i,1,2,infile);
    if(i!=1)
    {
        printf("error: bitmap must be monochrome.\n");
        exerr();
    }
    fread(&i,1,4,infile);
    if(i)
    {
        printf("error: bitmap must be uncompressed.\n");
        exerr();
    }
    fread(&i,1,4,infile);
    /* I have bmps, where this is 0 or something other strange */
    if(i!=8*bmph && !icon)
    {
        printf("error: bad icon size.\n");
        exerr();
    }
    fread(&i,1,4,infile);
    fread(&i,1,4,infile);
    fread(&i,1,4,infile);
    fread(&i,1,4,infile);
    fread(&i,1,4,infile);
    fread(&i,1,4,infile);
}

void readbmp()
{
    int i,x,y;

    for(y=0;y<bmph;y++)
    {
        for(x=0;x<bmpw;x++)
        {
          fread(&i,1,1,infile);
          if (x < raww)
          {
            bmpdata[x+((bmph-y)-1)*raww]=(unsigned char)~i;
          }
        }
    }
}

void compressbmp()
{
  unsigned char c;
  int i,j,k,count=0;

  compdata=(unsigned char*)malloc(raww*(bmph+1));
  bmpdata -= raww;                          /* activate first row */
  memset(bmpdata, 0, raww);                 /* clear first row    */

  for (i=0,j=0,k=raww; k<nbytes+raww; i++,j++,k++)
  {
    compdata[i]=bmpdata[j]^bmpdata[k];
    while ((compdata[i]==0x0||compdata[i]==0xff) && (k<nbytes+raww))
    {
      i++;
      i++;
      do
      {
        j++;
        k++;
        count++;
        compdata[i]=bmpdata[j]^bmpdata[k];
      } while ((compdata[i]==compdata[i-2]) && (k<nbytes+raww));
      compdata[i-1]=count;
      count=0;
    }
  }

  if (i < nbytes)  /* effectively compressed  */
  {
    free(bmpdata);
    bmpdata=compdata;
    nbytes=--i;
    compress = 255;
  }
  else
  {
    free(compdata);
    bmpdata += raww;
    compress = 0;
  }
}

void writebmp(char *iconname)
{
    int i,x,y,count=0;

    fprintf(outfile," .area _code\n");
    if (icon)
    {
      for (i=strlen(iconname);i > 0; i--)
      {
        if (iconname[i]=='.') iconname[i]=0;
        if (iconname[i]=='\\' || iconname[i]=='/')
        {
          iconname += ++i;
          i = 0;
        }
      }
      fprintf(outfile," .globl _%s\n",iconname);
      fprintf(outfile,"_%s:\n",iconname);
      fprintf(outfile," .db 0x%2.2x,0x%2.2x,0x%2.2x\n", pixelw, bmph, compress);
    }
    else
    {
      fprintf(outfile," .globl __sprdata\n");
      fprintf(outfile,"__sprdata:\n");
    }
    for(y=0;y<bmph && count<nbytes;y++)
    {
        fprintf(outfile," .db ");
        for(x=0;x<raww && count<nbytes;x++)
        {
            count++;
            fprintf(outfile,"0x%2.2x",bmpdata[x+y*raww]);
            if(x!=(raww-1) && count<nbytes)
            {
                fprintf(outfile,",");
            }
        }
        fprintf(outfile,"\n");
    }
}

int classifyArgs( int argc, char *rawargs[], char *fileargs[], char *optargs[] )
{
   int index, jndex, kndex;
   char *argptr;

   for ( index = 0, jndex = 0, kndex = 0; index < argc; index++ )
   {
      argptr = rawargs[index];
      if (*argptr == '-')
      {
         argptr++;
         optargs[kndex++] = argptr;
      }
      else
      {
         fileargs[jndex++] = argptr;
      }
   }

   return kndex;
}

int main(int argc,char* argv[])                         
{
    char n_options, n_files, index, help_flag = 0;
    char *fileargs[64], *optargs[64];
    

    n_options = classifyArgs( argc, argv, fileargs, optargs );
    n_files = argc - n_options;

    if ( n_files < 3 )
    {
      help_flag = 1;
    }

    for ( index = 0; index < n_options; index++ )
    {
      if ( (optargs[index][0] == 'i') ||
           (optargs[index][0] == 'I') ) icon = 1;
      if ( (optargs[index][0] == 'c') ||
           (optargs[index][0] == 'C') ) compress = 1;
    }

    if ( !icon && ( compress || n_files > 3 ) ) help_flag = 1;

    if ( help_flag )
    {
      printf("usage: bmp2asm [-i [-c]] bitmapfile asmfile [spritename]\n");
      printf("       -i makes an icon for DrawIcon().\n");
      printf("       -c makes a compressed icon. Only in conjunction with -i.\n");
      printf("       [spritename] The name you will use for the icon in your C-program.\n");
      printf("                    Again only in conjunction with -i.\n");
     
      exit(1);
    }

    if ( n_files < 4 )
      fileargs[3]=fileargs[2];

    outfilename=fileargs[2];
    openfiles(fileargs[1],fileargs[2]);
    readbmpheader();
    bmpdata=(unsigned char*)malloc(raww*(bmph+1));
    bmpdata+=raww; /* hide first row for compression */
    readbmp();
    if ( compress ) compressbmp();
    writebmp(fileargs[3]);
    free(compress ? bmpdata : bmpdata-raww);

    closefiles(0);

    return 0;
}
