/* Demo Calculator - based on pregnancy calculator
	set up as a Calculator app in the project preferences in AVGIDE
	while calc apps don't need icons, the IDE does - if you don't want an icon,
	manually edit the .epp file and comment out the RegisteredIcon line, and run depp
	from the command line
*/

#include "p100plib.h"
#include "ressdk.h"
#include "math.h"
#include "packet.h"
#include "f_sdkapi.h"

#include "p100icon.h"

#include "democalc.h"

/********************************************************** 
    This is a system variable.  This value will be kept in command field of 
    relative item in calcmenu.  It tells system where to jump to start next application.
**********************************************************/
extern unsigned short	StartRomBank;

const unsigned char txtAbout[] = "Demo Calc-FreeWare\nadd comments here";

/* next 2 used to recreate the calculator command menu */
const unsigned char CalcTitle[] = "Calculator";
const unsigned char CalcPrompt[] = "CHOOSE CALCULATOR TYPE:";

/* title must exactly match app name, so you can find your app in the menu */
const unsigned char DemoCalcTitle[] = "Demo Calc";

/* string used to check for valid preference data - make sure it fits in your structure */
const unsigned char txtPref[] = "Preg1";

/* misc text strings used for labels, picker titles, etc. */
const unsigned char txtSave[] = "Save";
const unsigned char txtAs[] = "As of ";
const unsigned char txtPreg[] = "Current term of pregnancy is ";
const unsigned char txtDelivery[] = "Delivery expected in ";
const unsigned char txtWeeks[] = " weeks and ";
const unsigned char txtDays[] = " days.";
const unsigned char txtLMP[] = "Last Menstrual Period";
const unsigned char txtEDD[] = "Estimated Date of Delivery";
const unsigned char pckLMP[] = "Last Menstr. Per.";
const unsigned char pckEDD[] = "Est. Delivery";
const unsigned char txtPast[] = "Past delivery date by ";
const unsigned char txtNotPreg[] = "Not pregnant yet!";

const MENUITEM MainMenu[] =
{
   {"About...",  	cmAbout, 	0},
   {"\0",			0, 		0}
};

_DATE today, lmp, edd;
short current;
unsigned char current_str[20];
unsigned short CalcType;
unsigned short TotalCalc;

/* a preference structure, change as needed (max 255 bytes) */
struct { unsigned char check[6]; _DATE lmp; } pref;

/* There could be 32 calculator apps, so make a structure to hold them all */
#define	MaxCalcNo 32
MENUITEM CalcMenu[MaxCalcNo];

/************************************************************************/



void DemoCalc_draw(VOID_PTR thisView)
{
	unsigned char next;
  	CONST_FAR_PTR fp1;
     double temp;

/*	There's probably a better way, but...
	If I place the PDESKBOX_draw call at the beginning, as below,
	  the numbers aren't updated when the screen is drawn.
	If I place it at the end, the DESKBOX routine clears out all the
	  writestrings and draw_icons...
	So I do it this way and put a dummy command in the event queue,
	  so everything gets done twice.  Hey, it works...
*/
	PDESKBOX_draw(thisView);

	fp1 = MK_FAR_PTR(txtAs);
	next = WriteString(0, 90, (unsigned char *)fp1, 0);
	next = WriteDate(next, 90, today, 0);

  	if (current < 0) {
		fp1 = MK_FAR_PTR(txtNotPreg);
		next = WriteString(0, 105, (unsigned char *)fp1, 0);
     }
     else {
		fp1 = MK_FAR_PTR(txtPreg);
		next = WriteString(0, 105, (unsigned char *)fp1, 0);

/*	Since there's no integer to string or char to double
	convert from char to int to double, then use NumericToStr
*/
		temp = current/7;
		NumericToStr(temp, current_str, DTINTEGER);
		next = WriteString(5, 117, current_str, 0);

		fp1 = MK_FAR_PTR(txtWeeks);
		next = WriteString(next, 117, (unsigned char *)fp1, 0);

		temp = current%7;
		NumericToStr(temp, current_str, DTINTEGER);
		next = WriteString(next, 117, current_str, 0);

		fp1 = MK_FAR_PTR(txtDays);
		next = WriteString(next, 117, (unsigned char *)fp1, 0);
	}

  	if (current > TERM) {
		fp1 = MK_FAR_PTR(txtPast);
		next = WriteString(0, 132, (unsigned char *)fp1, 0);

		temp = (current-TERM)/7;
		NumericToStr(temp, current_str, DTINTEGER);
		next = WriteString(5, 144, current_str, 0);
		fp1 = MK_FAR_PTR(txtWeeks);
		next = WriteString(next, 144, (unsigned char *)fp1, 0);

		temp = (current-TERM)%7;
		NumericToStr(temp, current_str, DTINTEGER);
		next = WriteString(next, 144, current_str, 0);
		fp1 = MK_FAR_PTR(txtDays);
		next = WriteString(next, 144, (unsigned char *)fp1, 0);
     }
     else {

		fp1 = MK_FAR_PTR(txtDelivery);
		next = WriteString(0, 132, (unsigned char *)fp1, 0);

		temp = (TERM-current)/7;
		NumericToStr(temp, current_str, DTINTEGER);
		next = WriteString(5, 144, current_str, 0);

		fp1 = MK_FAR_PTR(txtWeeks);
		next = WriteString(next, 144, (unsigned char *)fp1, 0);

		temp = (TERM-current)%7;
		NumericToStr(temp, current_str, DTINTEGER);
		next = WriteString(next, 144, current_str, 0);

		fp1 = MK_FAR_PTR(txtDays);
		next = WriteString(next, 144, (unsigned char *)fp1, 0);
	}
/*	Use ICON2DOT and ICONZIP to make the p100icon files
	the filename_ICON is the literal that selects the icon
	put p100icon.bin in the epp as the icon file*/
	DrawIcon( 65, 156, DEMO_ICON, PUT );

}

void LMP_handleEvent(VOID_PTR thisView, unsigned short *evType, unsigned char x, unsigned char y)
{
/*	Event handlers get called on all events, so you have to decide if it's the right event
	for each routine.  Left, Right, Top, and Bottom are macros that pick up the properties of
	thisView, so you don't have to calculate that yourself.  If you don't want a field to
	be modified, just clear the event without calling the default handleEvent
*/
   if (*evType == evPenDown && PressAtRange (x, y, Left, Top, Right, Bottom))
   {
	PDATEFIELD_handleEvent (thisView, evType, x, y);
	ClearEvent(evType);       /* Clear the event */
  	AddDate(&edd, &lmp, TERM);
  	current = DateDiff(&today, &lmp);
/*	Here's the dummy event to force a redraw */
	PutEvent(evCommand, HIGBYTE(cmLMP), LOWBYTE(cmLMP));
  }
}

void EDD_handleEvent(VOID_PTR thisView, unsigned short *evType, unsigned char x, unsigned char y)
{
   if (*evType == evPenDown && PressAtRange (x, y, Left, Top, Right, Bottom))
   {
	PDATEFIELD_handleEvent (thisView, evType, x, y);
	ClearEvent(evType);       /* Clear the event */
  	AddDate(&lmp, &edd, -TERM);
  	current = DateDiff(&today, &lmp);
/*	Here's another dummy event to force a redraw */
	PutEvent(evCommand, HIGBYTE(cmLMP), LOWBYTE(cmLMP));
  }
}

void DemoCalc_handleEvent(VOID_PTR thisView, unsigned short *evType, unsigned char x, unsigned char y)
{
	CONST_FAR_PTR fp1; 
	unsigned short	valCommand, i;

	valCommand = TOWORD(x,y);

	if (*evType == evKeyDown && x == CALCULATOR)
		/* see if the CALC icon was pressed */
	{
		/* if the last calculator, move to the first calculator, otherwise move the next one. */
		CalcType++;
		if (CalcType==TotalCalc) CalcType = CalcMenu[0].command;
		else CalcType = CalcMenu[CalcType].command;

		/* exit the calculator type application */
		PutEvent(evCommand,HIGBYTE(cmCancel),LOWBYTE(cmCancel));
		return;
	}

/*	Call the default handler to do the standard text/date/number pickers
*/
	PDESKBOX_handleEvent(thisView, evType, x, y);


	if(*evType == evCommand)
	{
		switch (valCommand)
		{
			case StartRomBank:
				break;

			case cmAbout:
				fp1 = MK_FAR_PTR(txtAbout);
				MessageBox(fp1, mfInformation | mfOKButton);
				break;

			case cmLMP:
				break;

			case cmSavePref:
				memcpy(&pref.lmp, &lmp, sizeof(_DATE));
 				dapSavePreference (CurrentAppID, (BYTE *)&pref, sizeof(pref));
				break;

			default:
				for (i=0;i<TotalCalc && valCommand!=CalcMenu[i].command;i++);
				if (i!=TotalCalc)
				{
					/* set the new calculator */
					CalcType = valCommand;

					/* exit the calculator type application */
					PutEvent(evCommand,HIGBYTE(cmCancel),LOWBYTE(cmCancel));
				}
				return;
		}
		ClearEvent(evType);       /* Clear the event */
/*	Need to re-run the draw routine to use the new data from the event */
		LoadBank (&(((PVIEW *)thisView)->draw));    /* Load the draw routine */
		((PVIEW *)thisView)->draw((PVIEW *) thisView);   /* execute the draw routine */
	}
}

/********************************************************************************
*
* Create a deskbox with whatever object you need
*
********************************************************************************/

far VOID_PTR CreateDemoCalcDeskbox(void)
{
	PDESKBOX *dsk;
	VOID_PTR retval;
	PVIEW *pv;
	CONST_FAR_PTR fp1,fp2;
	CONST_FAR_PTR fpMenu;
	unsigned short i;

	GetDate(&today);

	fp1 = MK_FAR_PTR(txtPref);
	dapReadPreference (CurrentAppID, 0, (BYTE *)&pref, sizeof(pref));

/*  See if preferences ever used before by checking for specific string
	If this is the first use, set up defaults and save
	Otherwise, use saved value
*/
	if (strcmp((char *)fp1, pref.check)) {
  		strcpy(pref.check, (char *)fp1);
		GetDate(&lmp);
      	GetDate(&pref.lmp);
		dapSavePreference (CurrentAppID, (BYTE *)&pref, sizeof(pref));
	}
	else {
		memcpy(&lmp, &pref.lmp, sizeof(_DATE));
	}
  	
	AddDate(&edd, &lmp, TERM);
  	current = DateDiff(&today, &lmp);

/*	Get the current calculator menu and scan to find this app
	Save in CalcType and use it to set lstDisplay (that's a lower case L!)
	and the default choice in the menu
*/	
  	GetCalcMenu ((BYTE *)CalcMenu);
	for (i=0;i<MaxCalcNo;i++)
	{
		/* Find the current selected item */
		if (CalcMenu[i].command==StartRomBank) CalcType = i;

		/* set display flag so that all the calculator will show in the control menu */
		if (CalcMenu[i].item[0]!=0) CalcMenu[i].flag = lstDisplay;
		else 
/*			stop when first character of app name is null*/
		{
			TotalCalc = i;
			break;
		}
	}

	SetFontType (PRPFONT7N);

/*	Create deskbox as desired, but use ComMenu and Place to look like a calc app
*/
	fpMenu = MK_FAR_PTR(MainMenu);
	fp1 = MK_FAR_PTR(CalcTitle);
	dsk = (PDESKBOX *) CreateDeskBox(1, 0, 0, 159, 239, fp1, fpMenu, 0, bafComMenu|bafPlace);
    dsk->options &= ~ofFindable;
	BankedAssign(dsk->handleEvent, DemoCalc_handleEvent);
	BankedAssign(dsk->draw, DemoCalc_draw);
 
/*	Setup the command menu using the GetCalcMenu array, with CalcType as the default
*/
	fpMenu = MK_FAR_PTR(CalcMenu);
	fp1 = MK_FAR_PTR(DemoCalcTitle);
	fp2 = MK_FAR_PTR(CalcPrompt);
	pv = (PVIEW *) CreateControlMenu(2, 0, 0, 0, 0, fpMenu, fp2, CalcType, cmtPrimaryFull);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk, (PVIEW *) pv);

/*	Insert objects as desired, such as labels, datefields, etc.
*/
	fp1 = MK_FAR_PTR(txtLMP);
	pv = (PVIEW *) CreateLabel(3, 5, 30, 150, 45, fp1, lbofAlignLeft|lbofDefineFont, PRPFONT11N);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk, (PVIEW *) pv);

	fp1 = MK_FAR_PTR(pckLMP);
	pv = (PVIEW *) CreateDateField(1, 80, 40, (unsigned char *)&lmp, fp1);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk, (PVIEW *) pv);
	BankedAssign(pv->handleEvent, LMP_handleEvent);

	fp1 = MK_FAR_PTR(txtEDD);
	pv = (PVIEW *) CreateLabel(4, 5, 60, 150, 85, fp1, lbofAlignLeft|lbofDefineFont, PRPFONT11N);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk, (PVIEW *) pv);

	fp1 = MK_FAR_PTR(pckEDD);
	pv = (PVIEW *) CreateDateField(5, 80, 70, (unsigned char *)&edd, fp1);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk, (PVIEW *) pv);
	BankedAssign(pv->handleEvent, EDD_handleEvent);
 
	fp1 = MK_FAR_PTR(txtSave);
	pv = (PVIEW *) CreateButton(6, 10, 200, 50, fp1, cmSavePref, bttBasic);
	LoadBank(&(dsk->insert));
	dsk->insert((VOID_PTR)dsk, (PVIEW *) pv);

	retval = dsk;
	return retval;

}

short main(void)
{
	PDESKBOX *dsk;
    unsigned short retval;
 
	ClearLCD(0);

/* Create the deskbox, then execute it
	ExecView returns with the command of the next calc app
	Repeatedly tapping the CALC icon is supposed to cycle thru
	all calc apps, but I haven't figured that one out yet...
	there doesn't seem to be a command generated when you tap the CALC icon
*/
	dsk = (PDESKBOX *)CreateDemoCalcDeskbox();
	retval = ExecView ((PGROUP *) dsk);

	Destroy ((VOID_PTR) dsk);

	if(retval == cmCancel)
	{
		/* return the value in menu command field to system which tell system 
	 	 * the next calculator application */
		retval = CalcType;
	}
	return retval;

}

