/*
 * Tektronix 8560 Unix System Kernel
 *
 *	Based on Western Electric Version 7 Unix
 *
 *	Tektronix Modifications from Western Electric code
 *	Copyright C, 1981, Tektronix Inc.
 *	All rights Reserved
 */

#ifdef SCCSID
/*static char *sccsid = "@(#)seg.h	4.3 dated 1/30/84	Tektronix 8560 Unix";*/
#endif
/*
 * KT-11 addresses and bits.
 */

#define	KISA	((physadr)0172340)	/* first kernel I-space address register */
#define	UISD	((physadr)0177600)	/* first user I-space descriptor register */
#define	UISA	((physadr)0177640)	/* first user I-space address register */
#define	UDSA	((physadr)0177660)	/* first user D-space address register */
#define	RO	02		/* access abilities */
#define	RW	06
#define	ED	010		/* extend direction */
#define	TX	020		/* Software: text segment */
#define	ABS	040		/* Software: absolute address */

/*
 * structure used to address
 * a sequence of integers.
 */
physadr	ka6;		/* 11/40 KISA6; 11/45 KDSA6 */

/*
 * address to access 11/70 UNIBUS map
 */
#define	UBMAP	((physadr)0170200)

/*
 * address to access Status Register 3
 */
#define SSR3	((physadr) 0172516)

/*
 * used to turn 22-bit addressing on and off
 */
#define ALLBITS 060

/*
 * Constants for 128k, 256k, and 4 mega-  byte increments (in clicks)
 */

#define KB128 04000
#define KB256 010000
#define MB4   0177777

#ifdef	UCB_BUFOUT
/*
 * definitions for remapping KD3
 */

#define	KISA0	((physadr) 0172340)
#define	KISA3	((physadr) 0172346)
#define	KDSA3	KISA3
#define	KISD3	((physadr) 0172306)
#define	KDSD3	KISD3
#define	SEG3	((caddr_t) 0060000)

#endif

