/*
 * Tektronix 8560 Unix System Kernel
 *
 *	Based on Western Electric Version 7 Unix
 *
 *	Tektronix Modifications from Western Electric code
 *	Copyright C, 1981, Tektronix Inc.
 *	All rights Reserved
 */

#ifdef SCCSID
/*static char *sccsid = "@(#)tty.h	4.2 dated 11/16/82	Tektronix 8560 Unix";*/
#endif

/*
 * the following defines determine which version of the terminal driver
 * will be compiled
 *
 *	sdg 4-14-80
 */
#define SMALL	1

#ifndef	SMALL
#define	SUPLCASE	1	/* support upper-case only terminals */
#define	SUPDELAY	1	/* support output delays */
#endif

#define	SUPESCECHO	1	/* echo ESC as $ */
#define SUPBSECHO	1	/* echo BS as BS SP BS if BSECHO bit on */
#define	SUPCTLECHO	1	/* echo control chars as ^<letter> */
#define	SUPXINFO	1	/* support t_flushc & t_status */
#define	SUPEOTOUT	1	/* allow EOT to be output in cooked */
#define	SUPNLECHO	1	/* echo NL after tun.t_eofc */
/* #define	SUPDTRFLAG	1	/* support DTR flagging */
/* #define	REALTAND	1	/* support REAL tandem mode */
/* #define	RELAXTTSTOP	1	/* any char undoes TTSTOP block */
#define	SUPOUTRAW	1	/* output RAW mode */

#ifdef	SUPOUTRAW
#define	SUPXINFO	1	/* support extra state info */
#endif

#ifdef	REALTAND
#define	SUPXSTATE	1	/* support extra state info */
#endif

#ifdef	SUPDTRFLG
#define	SUPXSTATE	1	/* support extra state info */
#define	SUPXINFO	1	/* support t_flushc, t_status & t_xflags */
#endif

/*
 * A clist structure is the head
 * of a linked list queue of characters.
 * The characters are stored in 4-word
 * blocks containing a link and several characters.
 * The routines getc and putc
 * manipulate these structures.
 */
struct clist
{
	int	c_cc;		/* character count */
	char	*c_cf;		/* pointer to first char */
	char	*c_cl;		/* pointer to last char */
};

/*
 * A tty structure is needed for
 * each UNIX character device that
 * is used for normal terminal IO.
 * The routines in tty.c handle the
 * common code associated with
 * these structures.
 * The definition and device dependent
 * code is in each driver. (kl.c dc.c dh.c)
 */

struct tc {
	char	t_intrc;	/* interrupt */
	char	t_quitc;	/* quit */
	char	t_startc;	/* start output */
	char	t_stopc;	/* stop output */
	char	t_eofc;		/* end-of-file */
	char	t_brkc;		/* input delimiter (like nl) */
};

#ifdef	SUPXINFO
struct ttxinfo {
	char	t_flush;	/* output flush */
	char	t_status;	/* type job status */
	unsigned t_xflags;	/* additional flag bits */
};
#endif

struct tty
{
	struct	clist t_rawq;	/* input chars right off device */
	struct	clist t_canq;	/* input chars after erase and kill */
	struct	clist t_outq;	/* output list to device */
	int	(* t_oproc)();	/* routine to start output */
	int	(* t_iproc)();	/* routine to start input */
	struct chan *t_chan;	/* destination channel */
	caddr_t	t_linep;	/* aux line discipline pointer */
	caddr_t	t_addr;		/* device address */
	dev_t	t_dev;		/* device number */
	short	t_flags;	/* mode, settable by ioctl call */
	short	t_state;	/* internal state, not visible externally */
	short	t_pgrp;		/* process group name */
	char	t_delct;	/* number of delimiters in raw q */
	char	t_line;		/* line discipline */
	char	t_col;		/* printing column of device */
	char	t_erase;	/* erase character */
	char	t_kill;		/* kill character */
	char	t_char;		/* character temporary */
	char	t_ispeed;	/* input speed */
	char	t_ospeed;	/* output speed */
	union {
		struct tc;
		struct clist t_ctlq;
	} t_un;
#ifdef	SUPXINFO
	struct	ttxinfo	t_xinfo;	/* extra information */
#endif
#ifdef	SUPXSTATE
	short unsigned t_xstate;	/* additional internal state bits */
#endif
};

#define	tun	tp->t_un

/*
 * structure of arg for ioctl
 */
struct	ttiocb {
	char	ioc_ispeed;
	char	ioc_ospeed;
	char	ioc_erase;
	char	ioc_kill;
	int	ioc_flags;
};

#define	TTIPRI	28
#define	TTOPRI	29

#define	CERASE	'\b'		/* default special characters */
#define	CEOT	004		/* EOT, cntl D */
#define	CKILL	025		/* NAK, cntl U */
#define	CQUIT	034		/* FS, cntl shift L */
#define	CINTR	003		/* ETX, cntl C */
#define	CSTOP	023		/* Stop output: ctl-s */
#define	CSTART	021		/* Start output: ctl-q */
#define	CBRK	0377		/* additional break character */
#define	CFLUSH	017		/* SI, control O */
#define	CSTATUS	0377		/* DC4, control T (eventually) */

/* limits */
#define	TTHIWAT	80
#define	TTLOWAT	40
#define	TTYHOG	256

/* modes */
#define	TANDEM	01
#define	CBREAK	02
#define	LCASE	04
#define	ECHO	010
#define	CRMOD	020
#define	RAW	040
#define	ODDP	0100
#define	EVENP	0200
#define	NLDELAY	001400
#define	TBDELAY	006000
#define	XTABS	006000
#define	CRDELAY	030000
#define	VTDELAY	040000
#define	BSECHO	0100000		/* echo <bs><sp><bs> for <bs> */

/* Hardware bits */
#define	DONE	0200
#define	IENABLE	0100

/* Internal state bits */
#define	TIMEOUT	01		/* Delay timeout in progress */
#define	WOPEN	02		/* Waiting for open to complete */
#define	ISOPEN	04		/* Device is open */
#define	FLUSH	010		/* outq has been flushed during DMA */
#define	CARR_ON	020		/* Software copy of carrier-present */
#define	BUSY	040		/* Output in progress */
#define	ASLEEP	0100		/* Wakeup when output done */

#ifndef	SUPXINFO
#define	XCLUDE	0200		/* exclusive-use flag against open */
#endif

#define	TTSTOP	0400		/* Output stopped by ctl-s */

#ifndef	SUPXINFO
#define	HUPCLS	01000		/* Hang up upon last close */
#endif

#define	TBLOCK	02000		/* tandem queue blocked */

#ifdef	SUPXINFO
#define	OFLUSH	04000		/* Output is being thrown away (^O) */
#endif

#ifdef	SUPDTRFLG
#define	TTFSTOP	010000		/* Output stopped by CTS dropping */
#define	DBLOCK	020000		/* input blocked due to DTR flagging */
#endif

#ifdef	REALTAND
#define	NONCLIST 040000		/* the current I/O operation is not off the clist */
#endif

/* #define	DKCMD	04000		/* datakit command channel */
/* #define	DKMPX	010000		/* datakit user-multiplexed mode */
/* #define	DKCALL	020000		/* datakit dial mode */
/* #define	DKLINGR	040000		/* datakit lingering close mode */
#define	CNTLQ	0100000		/* interpret t_un as clist */

/*
 * internal t_xstate bits
 */
#define	SNDSTRT	01		/* send tun.t_startc ASAP */
#define	SNDSTOP	02		/* send tun.t_stopc ASAP */
#define	DCHANGE	04		/* DBLOCK has changed state */

#ifdef	SUPXINFO
/*
 * t_xinfo.t_xflags bits
 */
#define	HUPCLS	01		/* Hang up on last close */
#define	XCLUDE	02		/* exclusive-use flag against open */
#define	DTRIFLG	04		/* DTR flagging enabled for input */
#define	DTROFLG	010		/* DTR flagging enabled for output */
#define	ESCECHO	020		/* echo escape as $ */
#define	CTLECHO	040		/* echo control chars as ^letter */

#ifdef	SUPOUTRAW
#define	OUTRAW	0100		/* output 8 bit characters */
#endif

#endif

/*
 * tty ioctl commands
 */
#define	TIOCGETD	(('t'<<8)|0)
#define	TIOCSETD	(('t'<<8)|1)
#define	TIOCHPCL	(('t'<<8)|2)
#define	TIOCMODG	(('t'<<8)|3)
#define	TIOCMODS	(('t'<<8)|4)
#define	TIOCGETP	(('t'<<8)|8)
#define	TIOCSETP	(('t'<<8)|9)
#define	TIOCSETN	(('t'<<8)|10)
#define	TIOCEXCL	(('t'<<8)|13)
#define	TIOCNXCL	(('t'<<8)|14)
#define	TIOCFLUSH	(('t'<<8)|16)
#define	TIOCSETC	(('t'<<8)|17)
#define	TIOCGETC	(('t'<<8)|18)
#define	TIOCRESO	(('t'<<8)|19)
#define	TIOCSETO	(('t'<<8)|20)
#define	TIOCGETO	(('t'<<8)|21)
#define	DIOCLSTN	(('d'<<8)|1)
#define	DIOCNTRL	(('d'<<8)|2)
#define	DIOCMPX		(('d'<<8)|3)
#define	DIOCNMPX	(('d'<<8)|4)
#define	DIOCSCALL	(('d'<<8)|5)
#define	DIOCRCALL	(('d'<<8)|6)
#define	DIOCPGRP	(('d'<<8)|7)
#define	DIOCGETP	(('d'<<8)|8)
#define	DIOCSETP	(('d'<<8)|9)
#define	DIOCLOSE	(('d'<<8)|10)
#define	DIOCTIME	(('d'<<8)|11)
#define	DIOCRESET	(('d'<<8)|12)
#define	FIOCLEX		(('f'<<8)|1)
#define	FIONCLEX	(('f'<<8)|2)
#define	MXLSTN		(('x'<<8)|1)
#define	MXNBLK		(('x'<<8)|2)
