#!/bin/csh -f

set tape=$1
if ("$tape" == "") then
	set tape=/dev/nrstc0
endif
set pass=1
set size=0

while (1)
 foreach bs (2 4 8 16 24 32 36 40 48 )
  @ size = 52428880 / ($bs * 1024)
  mt -f $tape rew
  echo "Writing $tape record size ${bs}k"
  scsi_timing write $tape ${bs}k $size
  mt -f $tape rew
  echo "Reading $tape record size ${bs}k"
  scsi_timing read $tape ${bs}k $size
  mt -f $tape rew
  echo "Writing $tape record size ${bs}k, fixed block mode"
  scsi_timing write $tape ${bs}k fixed
  mt -f $tape rew
  echo "Reading $tape record size ${bs}k, fixed block mode"
  scsi_timing read $tape ${bs}k fixed
  mt -f $tape rew
  @ bs = $bs + 1
  echo "Reading $tape record size ${bs}k"
  scsi_timing read $tape ${bs}k $size
 end
 echo Completed pass $pass
 @ pass = $pass + 1
end


