/* @(#)kptrace.c	2.1 12/21/87 */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

#include <errno.h>
#include <termio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#include "cdb.h"

struct termio vatty;

extern void Transmit();
int	vsigKludge = 0;
int	vsignal;
int	vcSecWait = 2;
int	vmsgqid;		/* message que msqid for talking to cu */

/* the following message types are exchanged between cu and cdb */
#define MSG_SHUTDOWN	1	/* sent by cdb when it is going to exit */
#define MSG_RESUME	2	/* sent by cdb when cu should resume control */
#define MSG_SCAN	3	/* sent by transmit when recieve should resume
					scanning for "*** sysdebug " */
#define MSG_SYSDEBUG	4	/* sent by transmit when recieve has sent signal
					indicating sysdebug was entered */
#define MSG_INITCOMM	5	/* sent by cdb when successfully starts up */


#define iBufMax	10
int	viBuf;
char	vrgBuf[iBufMax][128];
SBT	vsbRx;

#define cbMsgMax 256	/* max bytes host OR remote can tx OR rx at one time */
char	vsbTxLast[cbMsgMax]; /* copy of last transmisson */



/* S B   F   I N D E X */

local SBT SbFIndex(i)
int	i;
{
    if (i > 0)
	return(sbNil);
    if ((i += viBuf) < 0)
	i += iBufMax;
    return(vrgBuf[i]);
} /* SbFIndex */


/* R E A D   S B */

export int ReadSb(fn, sb, cb)
int	fn, cb;
FAST SBT	sb;
{
    FAST int	i, ret;
    char	ch;

    i = 0;
    while (--cb > 0) {
	ret = read(fn, &ch, 1);
	*sb++ = ch;
	i++;
	if (ret < 0)
	    return(ret);
	if (ret == 0)
	    break;
	if (ch == '\n' || ch == '\r')
	    break;
    } /* while */
    *sb = chNull;
    return(i);
} /* ReadSb */


/* F   W A I T   F O R */

local void FWaitFor(sbWait, cSeconds)
SBT	sbWait;
int	cSeconds;
{
    int		ret, err;

    vcsRemote = csReading;
    viBuf = 0;
    while (1) {
	alarm(cSeconds);

	ret = ReadSb(v->fnComm, vrgBuf[viBuf], sizeof(vrgBuf[viBuf]));
	err = errno;

	alarm(0);

	if (ret > 0) {
	    if (FHdrCmp(sbWait, vrgBuf[viBuf]))
		break;;
	    if (v->debuglevel >= 10)
		printf("%s", vrgBuf[viBuf]);
	} else if (ret < 0) {
	     /* Then we timed out OR we lost the line.
	      * Or .......
	      */
		break;;
	} /* if */

	if (++viBuf >= iBufMax)
	    viBuf = 0;
    } /* while */
    vcsRemote = csNil;
    if (vfInterruptPending) {
	vfInterruptPending = false;
	Fixer();
    }
} /* FWaitFor */

/* S E N D   M E S S A G E   T O   C U  */
local void FSendCuMsg(m)
int m;
{
	struct msgbuf msgb;

	msgb.mtype = m;
	msgsnd(vmsgqid,&msgb,0,0);
}



/* W A I T   F O R   D E B U G */

/* tell cu to resume processing and look for "*** sysdebug " */
local void FWaitForDebug()
{
	struct msgbuf msgb;

    	vfInWait = true;
	signal(SIGINT, Fixer);
	FSendCuMsg(MSG_RESUME);
	msgrcv(vmsgqid,&msgb,0,MSG_SYSDEBUG,0);
    	vfInWait = false;
}


/* G E T   P R O M P T */

local void GetPrompt()
{
    FWaitFor("cdb", vcSecWait);
} /* GetPrompt */


/* T R A N S M I T */

export void Transmit(sbTx)
SBT	sbTx;
{
    int		cbTx, cb;

    /* Transmit the string */
    if (sbTx != vsbTxLast)
	strcpy(vsbTxLast, sbTx);	/* save for re-transmission */
    
    cbTx = strlen(sbTx);

    if (v->fCommDebug) {
	char	sbTemp[200];
	strcpy(sbTemp, sbTx);
	sbTemp[strlen(sbTemp)-1] = '\n';
	printf("TxHost: %s", sbTemp);
    } /* if */

    if (v->fnComm <= 2)
	Panic("Transmit - v->fnComm: %d.", v->fnComm);

    vcsRemote = csWriting;
    cb = write(v->fnComm, sbTx, cbTx);
    vcsRemote = csWriteDone;

    if (cb != cbTx)
	SysPanic("Transmit: %d bytes to go, %d went.", cbTx, cb);
} /* Transmit */


/* P T R A C E */

export int Ptrace(pt, pid, adr, value)
int	pt, pid;
char	*adr;
int	value;
{
    int		ret;
    char	sbPt[100];

    if (v->fnComm == fnNil)
	return( ptrace(pt, pid, adr, value) );

    switch (pt) {
	default:
	    return( -1 );

	case ptReadI:
	case ptReadD:
	    /* put:	r adr
	     * get:	12345678
	     */
	    sprintf(sbPt, "r %x\r", adr);
	    Transmit(sbPt);
	    GetPrompt();
	    sscanf(SbFIndex(-2), "%x", &value);
	    return(value);

	case ptReadUser:
	    /* put:	x reg
	     * get:	12345678
	     */
	    sprintf(sbPt, "x %x\r", adr);
	    Transmit(sbPt);
	    GetPrompt();
	    sscanf(SbFIndex(-2), "%x", &value);
	    return(value);

	case ptWriteI:
	case ptWriteD:
	    /* put:	M adr hi-2-bytes lo-2-bytes
	     * get:	..... prompt
	     */
	    sprintf(sbPt, "M %x %x %x\r", adr, (value >> 16) & 0x0000ffff,
			value & 0x0000ffff);
	    Transmit(sbPt);
	    GetPrompt();
	    return(value);

	case ptWriteUser:
	    /* put:	m reg value
	     * get:	prompt
	     */
	    sprintf(sbPt, "m %x %x\r", adr, value);
	    Transmit(sbPt);
	    GetPrompt();
	    return(value);

	case ptResume:
	    /* put:	e
	     * get:	who knows!!!!
	     */
	    Transmit("e\r");
	    FWaitFor("e", vcSecWait);
	    return(0);

	case ptTerm:
	    Transmit("E\r");
	    FWaitFor("E", vcSecWait);
	    v->pid = 0;
	    vsigKludge = -1;
	    return(0);

	case ptSingle:
	    Transmit("s 1\r");
	    GetPrompt();
	    Transmit("e\r");
	    FWaitFor("e", vcSecWait);
	    return(0);

    } /* switch */
} /* Ptrace */


/* S E N D   S I G N A L */

export int SendSignal(sig)
int2	sig;
{
    char	sbPt[100];

    if (v->fnComm == fnNil)
	return(kill(v->pid, sig));

    printf("Please push the RED BUTTON to enter sys debug\n");
} /* SendSignal */


/* W A I T */

export int Wait(pstatus)
int	*pstatus;
{
    int		ret, sig;
    char	sbTemp[200];

    if (v->fnComm == fnNil)
	return(wait(pstatus));

    /* here we do what is necessary to *look like* "wait (2)" */

    if (vsigKludge != 0) {
	*pstatus = vsigKludge<0 ? 0 :(vsigKludge << 8) + 0x7f;
	vsigKludge = 0;
	return(v->pid);
    } /* if */

    FWaitForDebug();
    ReadSb(v->fnComm,sbTemp,sizeof(sbTemp));

    if (FHdrCmp("single", sbTemp)) {
	sig = SIGTRAP;
    } else if (FHdrCmp("for unknown", sbTemp)) {
	sig = SIGTRAP;
    } else if (FHdrCmp("interrupt", sbTemp)) {
	sig = SIGINT;
    } else if (FHdrCmp("call", sbTemp)) {
	sig = SIGINT;
    } else if (FHdrCmp("invalid", sbTemp)) {
	sig = SIGILL;
    } else if (FHdrCmp("breakpoint", sbTemp)) {
	sig = SIGTRAP;
    } else {
	sig = SIGTRAP;
    } /* if */

    *pstatus = (sig << 8) + 0x7f;

    GetPrompt();
    return(v->pid);
} /* Wait */


/* C R E A T E   T A R G E T */

export void CreateTarget()
{
    int		ret;
    char	sbBuf[200];

    if (v->fnComm == fnNil) {
	OsCreateTarget();	/* cause a NATIVE process to be born */
	return;
    } /* if */

    v->pid = 1;
    vsigKludge = SIGINT;

    printf("Force system into sysdebug (somehow....)\n");
    FWaitForDebug();
    FWaitFor("+ ", 1);
    Transmit("p\r");
    GetPrompt();

    AllBpInstall();
    printf("Target is now running\n");
} /* CreateTarget */


/* X   B L O C K   M O V E */

export void XBlockMove(pid, adrDest, adrSrc, cb)
int	pid;
ADRT	adrDest, adrSrc;
int	cb;
{
    /* transfer a block WITHIN the remote machine */
} /* XBlockMove */


/* X   B L O C K   T R A N S F E R */

export void XBlockTransfer(pid, adrDest, adrSrc, cbIn, fTx)
int	pid;
ADRT	adrDest, adrSrc;
int	cbIn;
FLAGT	fTx;
{
} /* XBlockTransfer */


/* C L O S E   C O M M */

export void CloseComm()
{
    int		ipr;
    char	sbBuf[cbMsgMax];

    if (v->fnComm != fnNil && v->pid ) {
	RemoveAllBp();
	Transmit("e\r");
	FWaitFor("e", vcSecWait);
    } /* if */
    FSendCuMsg(MSG_SHUTDOWN);	/* tell cu that cdb is closing down */
} /* CloseComm */


/* I N I T   C O M M */

export void InitComm(pr)
pPRR	pr;
{
    int n;

    /* get the message queue id and file descriptor number passed from cu */
    if (sscanf(pr->sbComm,":%d:%d",&vmsgqid,&n) != 2)
	UError("Invalid comm string from cu : %s", pr->sbComm);

    v->fnComm = n;
    v->os->adrReg0 = 0;	 /* Magic values */
    v->os->adrUser = 0;
    v->os->adrEntry = adrNil;	/* so we do NOT do ExecInit automatically */
    v->cpu->fBackupOnBpt = false;

    FSendCuMsg(MSG_INITCOMM);	/* tell cu that cdb is initialized */
} /* InitComm */
