/* $Header: assert.c,v 5.9 86/05/28 08:02:33 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

/* These routines maintain the list of assertions.  */

#include "cdb.h"


/* F   S A V E   A S S E R T I O N S */

export FLAGT FSaveAssertions(fp)
FILE	*fp;
{
    int		iad;
    FLAGT	fDidOne;
    pADR	ad;

    fDidOne = false;
    for (iad = 0, ad = v->rgAd; iad < v->iadMac; iad++, ad++) {
	fprintf(fp, "a %s\n", ad->sbCheck);
	if (ad->as != asActive)
	    fprintf(fp, "%d a s\n", iad);
	fDidOne = true;
    } /* for */

    if (fDidOne)
	/* set general assertion state correctly */
	fprintf(fp, "A %c\n", (v->as == asActive) ? 'a' : 's');

    return(fDidOne);
} /* FSaveAssertions */


/* L I S T   A S S E R T */

export void ListAssert()
{
    FAST int	i;

    if (v->iadMac == 0)
	UError("No assertions.");
    printf("Assertions as a group are %s\n\n",
		(v->as == asActive) ? "ACTIVE" : "SUSPENDED");
    for (i=0; i < v->iadMac; i++) {
	printf("%2d: %s %s\n", i,
	    (v->rgAd[i].as==asActive) ? "Active" : "Suspended",
	    v->rgAd[i].sbCheck);
    } /* for */
} /* ListAssert */


/* A D D   A S S E R T */

export void AddAssert(sbCheck, cb)
SBT	sbCheck;
int2	cb;
{
    int		iad;

    if (v->iadMac >= v->iadMax) {
	v->iadMax += 10;
	if (v->iadMax == 10) {
	    v->rgAd = (pADR) malloc(v->iadMax * cbADR);
	} else {
	    v->rgAd = (pADR) realloc(v->rgAd, v->iadMax * cbADR);
	} /* if */
	if (v->rgAd == 0)
	    Panic("Ran out of memory.");
    } /* if */
    iad = v->iadMac++;

    v->rgAd[iad].sbCheck = (SBT) malloc(cb+1);
    strcpy(v->rgAd[iad].sbCheck, sbCheck);
    v->rgAd[iad].sbCheck[cb] = chNull;

    v->rgAd[iad].as = asActive;
    if (!v->fQuiet)
	printf("Assertion %d: Active \"%s\"\n", iad, v->rgAd[iad].sbCheck);
    v->as = asActive;
    if (!v->fQuiet)
	printf("Assertions are ACTIVE\n");
} /* AddAssert */


/* M O D   A S S E R T */

export void ModAssert(iad, as)
int2	iad;
ASE	as;
{
    if (iad < 0 OR iad >= v->iadMac)
	UError("Bad assertion number: %d.", iad);

    v->rgAd[iad].as = as;
    if (as == asNil) {
	/* delete the assertoion */
	free(v->rgAd[iad].sbCheck);
	v->rgAd[iad] = v->rgAd[v->iadMac-1];	/* fold array back on itself */
	v->iadMac--;
    } else if (as == asActive) {
	/* if we turn one on, make sure MAIN switch is on */
	if (v->as == asActive)
	    v->as = asActive;
	return;
    } /* if */

    if (v->as == asSuspended)
	return;
    for (iad = 0; iad < v->iadMac; iad++)
	if (v->rgAd[iad].as == asActive)
	    return;

    if (!v->fQuiet)
	printf("Assertions are SUSPENDED\n");
    v->as = asSuspended;
} /* ModAssert */


/* F   D O   A S S E R T */

export FLAGT FDoAssert(pt)
int2	pt;
{
    int		iad, cmdSave;
    int4	cnt;

    cmdSave = vcmdDef;
    v->fRunAssert = false;  /* prevents recursive entry from RunProcess */
    for (cnt=(pt==ptSingle) ? 1 : -1;cnt != 0; --cnt) {
	/* we do the assertions BEFORE the line is executed */

	if (v->pid == pidNil)
	    return(true);

	for(iad=0; iad < v->iadMac; iad++) {
	    if ((v->rgAd[iad].as == asActive)
	       AND (FDoCommand(v->rgAd[iad].sbCheck, false))) {
		/* we hit an 'x' (exit) command - stop the parade! */
		printf("\nHit on assertion %d: \"%s\"\n",
			    iad, v->rgAd[iad].sbCheck);
		printf("Last line executed was:\n");
		PrintPosition(v->pcLast, fmtFile+fmtProc+fmtLn+fmtLine);
		printf("Next line to execute is:\n");
		SetViewPosition(v->acntx.pc);
		ShowViewPosition(fmtFile+fmtProc+fmtLn+fmtLine);
		v->fRunAssert = true;
		vcmdDef = cmdPrint;
		return(true);
	    } /* if */
	} /* for */

	v->pcLast = v->acntx.pc;	/* remember where the current line is */
	vcmdDef = cmdSave;

	/* step the process one statement's worth */
	SingleStep(cmdLineSingle, true);
	if (v->bp != bpNil) {
	    v->fRunAssert = true;
	    return(false);
	} /* if */
    } /* for */

    SetViewPosition(v->acntx.pc);	/* restore our context */
    v->fRunAssert = true;
    vcmdDef = cmdSave;
    return(true);
} /* FDoAssert */
