/* $Header: bp.c,v 6.3 86/09/03 10:48:43 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

/*
 * This file cantains the routines that manage the breakpoint list.
 */

#include "cdb.h"

local BPR vabpContinue = {adrNil, 0, 0, 0, 1, 1, "Q"};
export pBPR vbpContinue = &vabpContinue;
local BPR vabpStop = {adrNil, 0, 0, 0, 1, 1, "Q"};
export pBPR vbpStop = &vabpStop;

export FLAGT	vfNewBreaks = false;


/* F   S A V E   B P */

export FLAGT FSaveBp(fp)
FILE	*fp;
{
    int		ibp;
    FLAGT	fDidOne;
    pBPR	bp;
    char	sbBuf[200];

    fDidOne = false;
    for (ibp = 0, bp = v->rgBp; ibp < v->ibpMac; ibp++, bp++) {
	fprintf(fp, "0x%x bi %s\n", bp->adr, bp->sbBp);
	fDidOne = true;
    } /* for */
    return(fDidOne);
} /* FSaveBp */


/* L I S T   B P */

export void ListBp()
{
    FAST int	ibp;
    FAST pBPR	bp;

    /* Show all active breakpoints for the current process */

    if (v->ibpMac == 0)
	UError("No breakpoints set.");

    bp = v->rgBp;
    for (ibp=0; ibp < v->ibpMac; ibp++, bp++) {
	printf("%2d ", ibp);
	PrintPosition(bp->adr, fmtProc+fmtLn);
	printf("  count: %d", bp->count);
#ifdef CDB_DEBUG
	printf("  addr: %lx  inst: %d", bp->adr, bp->inst);
#endif /* CDB_DEBUG */
	if (bp->count <= 0)
	    printf(" (temp)");
	if (bp->sbBp[0] != chNull)
	    printf("   <%s>", bp->sbBp);
	printf("\n");
    } /* for */
} /* ListBp */


/* A L L   B P   I N S T A L L */

export void AllBpInstall()
{
    FAST int	ibp;

    /* Make sure ALL bp's are in the child */

    for (ibp=0; ibp < v->ibpMac; ibp++)
	if (v->rgBp[ibp].inst == 0)
	    InstallBp(v->rgBp+ibp);
} /* AllBpInstall */


/* R E M O V E	 A L L	 B P */

export void RemoveAllBp()
{
    FAST int	ibp;
    FAST pBPR	bp;

    if ((v->ps != psStopped) AND (v->ps != psNoChild))
	UError("You may not remove breakpoints from a non-stopped process.");

    /* Make sure NO bp's are in the child */

    for (ibp=0, bp=v->rgBp; ibp < v->ibpMac; bp++, ibp++)
	RemoveBp(bp);
} /* RemoveAllBp */


/* C L E A R   B P */

export void ClearBp(bp)
pBPR	bp;
{
    FAST int	ibp = bp - v->rgBp;

    /* Remove one bp from the current list. Move the others up one slot */

    if ((v->ps != psStopped) AND (v->ps != psNoChild))
	UError("You may not remove breakpoints from a running process.");

    if ((bp == bpNil) OR (ibp >= v->ibpMac))
	return;

    RemoveBp(v->rgBp + ibp);
    ShowBp(bp, false);
    v->ibpMac--;

    /* cause rest to move up */
    for ( ; ibp < v->ibpMac; ibp++)
	v->rgBp[ibp] = v->rgBp[ibp+1];
} /* ClearBp */


/* C L E A R   A L L */

export void ClearAllBp()
{
    FAST int	ibp;
    FAST pBPR	bp;

    /* Clear ALL bp's */

    for (ibp=0, bp=v->rgBp; ibp < v->ibpMac; bp++, ibp++)
	ShowBp(bp, false);

    RemoveAllBp();
    v->ibpMac = 0;
    if (!v->fQuiet)
	printf("All breakpoints deleted\n");
} /* ClearAllBp */


/* B P	 F   I F D   I L N */

export pBPR BpFIfdIln(ifd, iln)
int2	ifd, iln;
{
    FAST int	ibp;
    FAST pBPR	bp;

    /* Given an file/line number, return the bp there, if any. */

    if (ifd == ifdNil)
	return(bpNil);

    for (ibp=0, bp=v->rgBp; ibp < v->ibpMac; bp++, ibp++)
	if ((bp->ifd == ifd) AND (bp->iln == iln))
	    return(bp); 
    return(bpNil);
} /* BpFAdr */


/* B P	 F   A D R */

export pBPR BpFAdr(adr)
FAST ADRT	adr;
{
    FAST int	ibp;
    FAST pBPR	bp;

    /* Given an address, return the bp there, if any. */

    if (adr == adrNil)
	return(bpNil);

    for (ibp=0, bp=v->rgBp; ibp < v->ibpMac; bp++, ibp++)
	if (bp->adr == adr)
	    return(bp); 
    return(bpNil);
} /* BpFAdr */


/* B P	 F   P R O C E S S */

export pBPR BpFProcess(adr)
ADRT	adr;
{
    FAST int	ibp;
    FAST pBPR	bp, bpRet;

    /* This is called whenever a process has stopped.
     * We remove all 0-count temps and process the
     * other breakpoints for break counts.
     *
     * If we are stopped at a break, its bp is returned.
     */

    bpRet = bpNil;
    for (ibp=0, bp=v->rgBp; ibp < v->ibpMac; bp++, ibp++) {
	if (bp->count == 0) {
	    if (bp->adr == adr)
		bpRet = vbpStop;
	    ClearBp(bp);
	    ibp--;	/* ClearBp shuffles things, back up one */
	    bp--;
	    continue;
	} /* if */

	if ((bp->adr != adr) OR (bp->inst == 0))
	    continue; /* wrong address OR not installed */

	/* This break is at the correct address, adjust its count */
	if (bp->count < 0) {
	    /* it's a temp break */
	    if ((bp->count += 1) == 0) {
		v->abp = *bp; /* transfer into the holding slot */
		bpRet = &v->abp;
		ClearBp(bp);
		ibp--;
		bp--;
	    } else {
		bpRet = vbpContinue;
	    } /* if */
	} else {
	    /* it's a permanent break */
	    if ((bp->count -= 1) <= 0) {
		bp->count = 1;	/* we refresh it if it goes 0 */
		bpRet = bp;
	    } else {
		bpRet = vbpContinue;
	    } /* if */
	} /* if */
    } /* for */

    v->bp = bpRet;
    return(bpRet);
} /* BpFProcess */


/* B P	 F   A D D   B P */

export pBPR BpFAddBp(adr, count, sbCmd, cb)
ADRT	adr;
int2	count, cb;
SBT	sbCmd;
{
    FAST pBPR	bp;

    /* Add a breakpoint to the current process */

    if (adr == adrNil)
	UError("Attempt to set breakpoint at invalid address.");

    /* see if we already have this one - if so, remove it */
    bp = BpFAdr(adr);
    if (bp != bpNil) {
	if (count == 0)
	    return(bp); /* temp bp's do NOT cause removal */
	ClearBp(bp);
    } /* if */

    if (v->ibpMac >= v->ibpMax) {
	v->ibpMax += 10;
	if (v->ibpMax == 10) {
	    v->bp = bpNil;
	    v->rgBp = (pBPR) malloc(v->ibpMax*cbBPR);	/* allocate bp table */
	} else {
	    v->rgBp = (pBPR) realloc(v->rgBp, v->ibpMax*cbBPR);
	} /* if */
	if (v->rgBp == 0)
	    Panic("Ran out of memory.");
    } /* if */

    bp = v->rgBp + v->ibpMac;
    v->ibpMac++;

    bp->adr = adr;
    bp->count = count;
    bp->ifd = IfdIlnFAdr(&bp->iln, adr);
    if (sbCmd == sbNil) {
	bp->sbBp[0] = chNull;
    } else {
	strncpy(bp->sbBp, sbCmd, cb);
	bp->sbBp[cb] = chNull;
    } /* if */
    bp->inst = 0;	/* forces it to be installed at next run */
    ShowBp(bp, true);
    return(bp);
} /* BpFAddBp */


/* B P	 F   S E T */

export pBPR BpFSet(bpc, fTemp, cnt, sbCmd, cb)
int2	bpc, cnt, cb, fTemp;
SBT	sbCmd;
{
    ADRT	adr;
    int		ipd, ifdSave, ipdSave, ilnSave;
    char	sbTok[50], sbTemp[100];
    pBPR	bp;
    CNTXR	acntx;
    TKE		tk;

    /* Set one of a number of fancy breaks - uplevel, proc begin, exit... */

    /* the ifd is set to nil at the end */
    ipd = ipdSave = v->ipd;
    ifdSave = v->ifd;
    ilnSave = v->iln;

    acntx = v->acntx;

    if (cnt >= 0) {		/* they want to do this stack relative */
	if (v->pid == pidNil)
	    UError("Command is stack-relative, but there is no child process.");

	while ((cnt > 0) AND ! acntx.fEndOfStack) {
	    NextFrame(&acntx);
	    --cnt;
	} /* if */
	if (acntx.fEndOfStack)
	    UError("Stack isn't that deep!");
    } /* if */

    switch (bpc) {
	default:
	    UError("Unknown breakpoint type `%d'.", bpc);

	case bpcBegin:
	    ipd = (cnt >= 0) ? IpdFAdr(acntx.pc) : v->ipd;
	    OpenIpd(ipd, true); /* force it open */
	    adr = AdrFIpdIln(v->ipd, v->iln);
	    break;

	case bpcEnd:
	    ipd = (cnt >= 0) ? IpdFAdr(acntx.pc) : v->ipd;
	    adr = AdrFEndOfProc(ipd);
	    break;

	case bpcUp:
	    /* move past instruction which fixes the stack pointer */
	    adr = AdrFStackFix(acntx.pc);
	    if (vfNewBreaks) {
		sprintf(sbTemp, "Q;if ((int)$fp == 0x%x) {%sH}{c}", acntx.fp,
			    (fTemp) ? "d;" : "");
		fTemp = false;
		sbCmd = sbTemp;
		cb = strlen(sbCmd);
	    } /* if */
	    break;

	case bpcProc:	/* trace breakpoint */
	    if (cnt >= 0) {
		if ((ipd = IpdFAdr(acntx.pc)) == ipdNil)
		    UError("No symbols for that procedure.");
		v->ipd = ipd;
	    } else {
		TkPeek();
		if ( (tk == tkStr)
		   AND ((ipd = IpdFName(vsbTokPeek)) != ipdNil) ) {
		    TkNext();	/* actually eat it */
		    v->ipd = ipd;
		} /* if */
	    } /* if */

	    /* set break at entrance */
	    sbCmd = "Q;bU {Q;\"Exiting %s: \";$result/n;c};\"Entering \";1t;c";
	    sprintf(sbTemp, sbCmd, SbFIpd(ipd));
	    sbCmd = sbTemp;
	    cb = strlen(sbCmd);
	    OpenIpd(ipd, true);	/* force it open */
	    adr = AdrFIpdIln(ipd, v->iln);
	    break;
    } /* switch */

    if (adr != adrNil)
	bp = BpFAddBp(adr, ((fTemp) ? -1 : 1), sbCmd, cb);

    v->ifd = ifdNil;
    OpenIfd(ifdSave);
    v->iln = ilnSave;
    v->ipd = ipdSave;
    return(bp);
} /* BpFSet */


/* Fork Save Hack - clean it up laster........  */

struct FSS {
	int2	pid;
	ADRT	adr;
	uint4	inst;
	};
#define ifsMax 512
struct FSS vrgFs[ifsMax];
int	vifsMac = 0;

/* S A V E   F O R K   B P */

export void SaveForkBp(bp)
pBPR	bp;
{
    vrgFs[vifsMac].adr = bp->adr;
    vrgFs[vifsMac].inst = bp->inst;
    vrgFs[vifsMac].pid = v->pid;
    vifsMac++;
} /* SaveForkBp */


/* B P   F   F O R K    S A V E */

export pBPR BpFForkSave(pid, adr)
int2	pid;
ADRT	adr;
{
    int		ifs;
    static BPR	abp;

    for (ifs = 0; ifs < vifsMac; ifs++)
	if ((vrgFs[ifs].pid == pid) AND (vrgFs[ifs].adr == adr)) {
	    abp.adr = adr;
	    abp.inst = vrgFs[ifs].inst;
	    return(&abp);
	} /* if */
    return(bpNil);
} /* BpFForkSave */
