/* $Header: cdb.h,v 6.2 86/09/01 17:20:08 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

#include <stdio.h>

#define int1	char
#define uint1	unsigned char
#define int2	short
#define uint2	unsigned short
#define int4	long
#define uint4	unsigned long

#include "config.h"

extern char *malloc();
extern free();
extern long lseek();
extern int errno;
extern char *strchr(), *strrchr(), *strcpy(), *strncpy(), *strcat(), *strncat();
extern int strlen(), strspn();
extern long time();
extern char *getenv();

/* random stuff */
#define false 0
#define true  1

#define bits unsigned	/* makes bit fields definitions shorter */
#define FAST register

#define NAR	10000	/* Not A Register */

#define export		/* something that belongs in ext.h  */
#define exportdefine
#define local static	/* something not to be known outside of this module */

#define NOT(x)	(!(x))
#define AND &&
#define OR  ||

#define seekBegin	0	/* these are used with lseek() and fseek() */
#define seekRelative	1
#define seekEnd		2

typedef char *SBT;
#define sbNil ((SBT)0)
#define chNull '\0'
#define nil ((char *)0)	/* good for where a general nil pointer is needed */
#define FLAGT uint2
typedef uint4	ADRT, *pADRT;
#define	adrNil ((ADRT) 0xffffffff)

/* and now  - The Symbol Table! - Ta Da! */
#include "sym.h"

/* define token type */
typedef uint2 TKE, *pTKE;
extern TKE	vtk;
extern TKE	TkNext();

#define cbSbBpMax 100	/* max length of BP commands */

typedef struct BPS {    /* breakpoint */
	ADRT	adr;		/* address of breakpoint */
	uint4 	inst;		/* instruction that lives there */
	int2	ifd;		/* file this maps to, if any */
	int2	iln;		/* line, if any */
	int2	count;		/* number of times to hit before stop */
	int2	countInit;	/* re-initialize main count */
	char	sbBp[cbSbBpMax];	/* commands for bp */
	} BPR, *pBPR;
#define cbBPR sizeof(BPR)
#define bpNil ((pBPR)0)
#define ibpNil  -1

/* break point codes */
#define bpcNil		0
#define bpcBegin	1
#define bpcEnd		2
#define bpcUp		3
#define bpcProc		4

/* assertion states */
#define asNil	   	0       /* assertions are not being used */
#define asActive	1       /* assertions ARE being used */
#define asSuspended     2       /* being used, but temporarily suspended */
typedef int ASE, *pASE;

typedef struct {	/* the assertion descriptor */
	SBT	sbCheck;	/* points to command list for this check */
	ASE	as;		/* state of THIS assertion check */
	} ADR, *pADR;
#define cbADR sizeof(ADR)


/*
 * Multivalued union used in expression
 * evaluator for all types
 */
/* This does NOT want to be defined on our int1, int2, etc.! */
typedef union {
	char	valChar;
	unsigned char	valUChar;
	short	valShort;
	unsigned short	valUShort;
	int	valInt;
	unsigned int	valUInt;
	long	valLong;
	unsigned long	valULong;
	float	valFloat;
	double	valDouble;
	ADRT	valAdr;
	int	*valPtr;
#ifdef LONGLONG
	long long		valLongLong;
	unsigned long long	valULongLong;
#endif /* LONGLONG */
	char	*sbName;
	struct {
		float	valReal;
		float	valImaginary;
		} valComplex;
	} VALU, *pVALU;
#define cbVALU sizeof(VALU)

typedef struct {	/* run-time Stack Element record */
	SYMR	asym;		/* copy of original symbol */
	TIR	ti;		/* type info */
	int4	isymRef;	/* -> to base type if struct/union/enum/etc */
	int4	isymTypedef;	/* typedef location, if used */
	VALU	val;		/* current value of this thing */
	int2	bitsWidth;	/* bit field width */	
	int4	bitsOffset;	/* bit field offset from start of struct */
	RNGR	rgRng[idimMax];	/* dimensions are actually subranges */
	} SER, *pSER;
#define seNil ((pSER)0)
#define cbSER sizeof(SER)

#define chLCB	'{'
#define chRCB	'}'
#define FUpper(ch) (((ch) >= 'A') AND ((ch) <= 'Z'))

/* display format */
#define dfNil		0
#define dfDecimal       1
#define dfUnsigned      2
#define dfOctal		3
#define dfHex		4
#define dfFFloat	5
#define dfEFloat	6
#define dfGFloat	7
#define dfChar		8
#define dfByte		9
#define dfPStr		10
#define dfStr		11
#define dfProc		12
#define dfAdr		13
#define dfStruct	14
#define dfType		15
#define dfEnum		16
#define dfProcLine	17
#define dfInstruction	18
#define dfCompiler	19
#define dfStandard	20
#define	dfBoolean	21
#define	dfComplex	22
#define dfCommon	23
#define dfBinary	24
typedef int     DFE, *pDFE;

typedef struct MODES {  /* used for passing around output format info */
	DFE	df;	/* display format */
	int2	len;	/* length of item (if meaningful) */
	int2	cnt;	/* number of times to apply the format */
	int2	imap;	/* selects map set to use (normally 0) */
	} MODER, *pMODER;
#define cbMODER sizeof(MODER)
#define modeNil ((pMODER)0)

typedef struct MAPS {
	ADRT    b1;
	ADRT    e1;
	ADRT    f1;
	ADRT    b2;
	ADRT    e2;
	ADRT    f2;
	} MAPR, *pMAPR;
#define fnNil -1

/* format control for PrintPos */
#define fmtNil		0       /* we don't want nothin' printed */
#define fmtFile		0x01    /* print the file name */
#define fmtProc		0x02    /* print the procedure name */
#define fmtLn		0x04    /* print the line number */
#define fmtLine 	0x08    /* print the current line */
#define fmtEol		0x10    /* print an end-of-line */
#define fmtInst		0x40	/* print instruction */
#define fmtSrcLineOnly	0x80

/* command types */
#define cmdNil	  	0
#define cmdPrint	1       /* print lines */
#define cmdDisplay      2       /* display the contents of a variable */
#define cmdUpArrow      3       /* display contents of previous location */
#define cmdLineSingle	4       /* statement step */
#define cmdMachSingle	5       /* instruction step */
#define cmdLineProc	6       /* statement step - DON'T follow proc calls */
#define cmdMachProc	7       /* inst. step - DON'T follow proc calls */
typedef int CMDE, *pCMDE;

typedef struct {	/* signal action record */
	bits	fStop : 1;	/* if true, stop on signal */
	bits	fReport : 1;	/* if true, report signal */
	bits	fIgnore : 1;	/* if true, ignore signal */
	char	sbSa[cbSbBpMax]; /* commands for signal */
	} SAR, *pSAR;
#define cbSAR (sizeof(SAR))
#define saNil ((pSAR)0)

/* these are internal names for registers, REAL offsets are in vrgReg */
#define 	u0	0
#define 	u1	1
#define 	u2	2
#define 	u3	3
#define 	u4	4
#define 	u5	5
#define 	u6	6
#define 	u7	7
#define 	u8	8
#define 	u9	9
#define 	u10	10
#define 	u11	11
#define 	u12	12
#define 	u13	13
#define 	u14	14
#define 	u15	15
#define		uregMax 21


/* address spaces for looking at child */
#define spaceText 1
#define spaceData 2

#define pidNil 0

/* requests for `access' */
#define accRead	 	0
#define accWrite	1

/* requests for `ptrace' system call */
#define ptChild	 	0
#define ptReadI	 	1
#define ptReadD	 	2
#define ptReadUser      3
#define ptWriteI	4
#define ptWriteD	5
#define ptWriteUser     6
#define ptResume	7
#define ptTerm	  	8
#define ptSingle	9

/* the following are NEW ptrace requests add for multiprocess work */
#define ptMultiChild	10	/* we own you and your firstborn */
#define ptReleaseChild	11	/* go `way ya bother me, Kid.... */
#define ptPpid		12	/* give us pid of parent of this process */
#define ptCmdName	13	/* return name of executable */

/* these were from `#include <fcntl.h>' on a System III */
#define O_RDONLY	0
#define O_WRONLY	1
#define O_RDWR  	2

#include "tk.h"
/* these are alternate names for some tokens */
#define tkModulo tkPercent
#define tkBitAnd tkAmper
#define tkMul tkStar
#define tkLT tkLAB
#define tkGT tkRAB
#define tkXOR tkUpArrow	
#define tkBitOr tkBar

/* sex codes (also known as Blue Laws) */
#define bitSexNil	0
#define bitSexLittle	1
#define bitSexBig	2

#define byteSexNil	0
#define byteSexLittle	1
#define byteSexBig	2

/* Floating point classes */
#define fpcNil		0
#define fpcMit		1
#define	fpcDec		2


#define cbArgsMax	1024	/* size of command line */

typedef struct CPUS {
	int1	cbChar;		/* size (in bytes) of char, int, etc. */
	int1	cbShort;
	int1	cbInt;
	int1	cbLong;
	int1	cbFloat;
	int1	cbDouble;
	int1	cbPointer;
	int1	cbRegister;
	/* "style" information */
	int1	bitSex;		/* bit ordering with in word */
	int1	byteSex;	/* byte ordering with long */
	int1	alignment;	/* "int" alignment - 0, 1, or 3 */
	int1	fpc;		/* floating point class */
	/* registers */
	int2	iregMax;	/* size of rgReg */
	pSER	rgReg;		/* points at register goodies */
	/* miscellaneous */
	int4	instBp;		/* a breakpoint instruction */
	int2	cbBp;		/* number of bytes in BP */
	int2	cBadMax;	/* see BpFSingle */

	bits	fApIsFp : 1;	/* AP is the same as FP */
	bits	fBackupOnBpt : 1;	/* PC points past BPT instruction */
	bits	fCalleeStackCleanup : 1;	/* E.g. Vax & CCI */
	} CPUR, *pCPUR;
#define cpuNil ((pCPUR)0)
#define cbCPUR sizeof(CPUR)

/* process state */
#define psNil		0
#define psNoChild	1	/* no live process */
#define psStopped	2	/* live process - stopped at BP or SIG */
#define psRunning	3	/* live process - currently running */
#define psDying		4	/* process is being killed */
#define psFork		5	/* process is result of a fork */
#define psExec		6	/* process has just done an exec */
#define psContinue	7	/* analyze stop */
#define psMax		8

/* communication state */
#define csNil		0	/* comm is quiescent */
#define csReading	1	/* we are waiting for reply from remote */
#define csWriteDone	2	/* we finished writing and are about to read */
#define csWriting	3	/* we are writing to remote */

/* Wait-ing types */
#define wtNil		0
#define wtTty		1	/* tty input */
#define wtAnything	2
#define wtAnyProcess	3
#define wtProcess	4	/* for a specific process */

typedef struct OSS {	/* OS dependent stuff */
	ADRT	adrTty;		/* address of child's channel 0 tty buffer */
	int2	sigTrap;	/* breakpoint signal */
	int2	sigMax;		/* number of signal */
	pSAR	mpSigSa;	/* signal action records */
	/* these next three will be adrNil if inapplicable - e.g. remote */
	ADRT	adrReg0;	/* location of register 0 in "user" */
	ADRT	adr_u_ar0;	/* offset to pointer to reg0 */
	ADRT	adrUser;	/* base address of user structure IN KERNEL!!!*/
	ADRT	adrEntry;	/* offset to u.entloc or whatever */
	ADRT	dadrEntMax;	/* maximum we might be away from entry */
	int4	instSyscall;	/* system call instruction */
	bits fIntegerOffsets : 1;  /* we need to add sizeof(int) - sizeof(x) */
	bits fClearFp : 1;	/* we clear the FP when we create new child */
	} OSR, *pOSR;
#define cbOSR sizeof(OSR)
#define osNil ((pOSR)0)

typedef struct CNTXS {	/* Context Record - used for walking the stack */
	ADRT	pc;
	ADRT	fp;
	ADRT	ap;
	ADRT	sp;
	ADRT	csp;	/* a Pyramidism - the control stack pointer */
	bits	fEndOfStack : 1;
	} CNTXR, *pCNTXR;
#define cbCNTXR sizeof(CNTXR)
#define cntxNil ((pCNTXR)0)

typedef struct PRS {	/* per process values */
	SBT	sbName;			/* nickname for this process */
	    /* Runtime goodies */
	int2	pid;			/* process id */
	int2	pidParent;		/* Hi, Mom! */
	int	pgrpSave;		/* process's previous process grp */
	int2	status;			/* status at last stop */
	CNTXR	acntx;			/* current context info */
	int2	ps;			/* process state */
	int	iln, slop;		/* line number & offset from line */
	    /* dynamically accessible things MUST be INT */
	int	lc;			/* language code */
	int	fCommDebug;		/* debug remote communications */
	int	debuglevel;		/* controls debugger debugging output */
	int	tracelevel;		/* level of tracing */
	int	sigOrig, sig;		/* signal we stopped on */
	    /* Object pointers */
	pCPUR	cpu;			/* cpu dependent stuff */
	pOSR	os;			/* os dependent stuff */
	    /* remote communications */
	SBT	sbComm;			/* name of communications port */
	int2	fnComm;			/* communications channel */
	int2	iBaud;			/* index into baud rate table */
	    /* Random stuff */
	    /* bits from all over the place */
	    /* 13 used, 19 to go */
	bits	fQuiet : 1;		/* silences many messages during BP */
	bits	fDoingSingle : 1;	/* indicates last 'run' was single */
	bits	fAtSyscall : 1;		/* single stepping over system call */
	bits	fMachineStep : 1;	/* we are instruction stepping */
	bits	fRunAssert : 1;		/* check for active assertions */
	bits	fPureText : 1;		/* instructions are shared/read-only*/
	bits	fStty : 1;		/* Use stty each child start/stop */
	bits	fForkedProcess : 1;	/* Don't Deallocate entire PRR */

	    /* multi-process bits */
	bits	fStopOnExec : 1;	/* stop immediately after exec */
	bits	fStopOnFork : 1;	/* stop BOTH process after fork */
	bits	fClearStop : 1;		/* single-step set StopOnExec */
	bits	fRemoveBpsOnFork : 1;	/* child does NOT get parent's BPs */
	bits	fDebugChildren : 1;	/* indicates we WANT the kids */

	ADRT	adrStartLow;		/* Normally adr of _start */
	ADRT	adrStartHigh;	/* Normally adr of routine AFTER _start */
	ADRT	adrInit;		/* main for C, program for Pascal */
	ADRT	adrInst;		/* last address we examined */
	ADRT	adrText;		/* base address of the code area */
	ADRT	adrData;		/* base address of the data area */
	SBT	sbInit;			/* statement step start address */

	    /* various primary file info */
	HDRR	hdr;			/* copy of HDR from sbCdb */
	SBT	sbCdb;			/* cdb symbol file */
	int2	fnCdb;	 		/* file number of cdb symbol file */
	SBT	sbExec;			/* executable file */
	int2	fnExec;	 		/* file number of executable file */
	SBT	sbCore;			/* core file */
	int2	fnCore;	 		/* file number of core file */
	int4	mtimeExec;		/* last time exec was changed */
	MAPR	mapExec;		/* map of executable file */
	MAPR	mapCore;		/* map of core file */
	SBT	*rgSbDir;		/* alternate directories for source */
	int2	idirMac;		/* number in use */
	int2	idirMax;		/* number allocated */
	    /* pointers to memory resident copies of ... */
	pPDR	rgPd;			/* procedure descriptore array */
	int2	ipd;			/* current procedure */
	pFDR	rgFd;			/* file descriptore array */
	int2	ifd;			/* current file */
	    /* AUX Cache variables */
	int4	iauxLo, iauxLim;	/* min/max indicies in cache */
	int4	iauxCacheMax;		/* cache size */
	pAUXU	auxCache;		/* auxillary symbol cache */
	    /* LINE Cache variables */
	int4	ilineLo, ilineLim;	/* min/max indicies in cache */
	int4	ilineCacheMax;		/* cache size */
	pLINER	lineCache;		/* line symbol cache */
	pLINER	line;			/* current line symbol */
	    /* SYM Cache variables */
	int4	isymLo, isymLim;	/* min/max indicies in cache */
	int4	isymCacheMax;		/* cache size */
	pSYMR	symCache;		/* symbol cache */
	pSYMR	sym;			/* the `current' symbol */
	int4	isym;			/* sym index for surrent sym */
	    /* ISS (String Space) Cache variables */
	int4	issLo, issLim;		/* min/max indicies in cache */
	int4	issCacheMax;		/* cache size */
	SBT	sbCache;		/* string cache */
	    /* Typedefs */
	pTDR	rgTd;			/* typedef array */
	    /* Breakpoints */
	int2	ibpMac;			/* current/max number BPR's in use */
	int2	ibpMax;			/* number allocated */
	pBPR	rgBp;			/* array of BPR's */
	int2	ibtMac;			/* trace points */
	int2	ibtMax;			/* number allocated */
	pBPR	rgBt;			/* array of tracing BPR's */
	int2	cCallNest;		/* used for dynamic call graph */
	pBPR	bp;			/* pointer to current BPR */
	BPR	abp;			/* holding slot for a breakpoint */
	int	ipdFork;		/* ditto */
	    /* Assertion info */
	int2	iadMac;			/* in use */
	int2	iadMax;			/* allocated */
	pADR	rgAd;			/* the list of assertions */
	ADRT	pcLast;			/* last address seen during assert */
	ASE	as;			/* state of the assertions as a whole */
	    /* procedure call from the command line stuff */
	ADRT	adrBreak; /* the place we break at when doing proc calls */
	ADRT	adrCall;  	/* location of call instruction in _end_ */
	int2	cNestProc;	/* nesting depth of proc's from cmd line */
	char	sbSave[100]; /* where we put saved command AFTER proc is done */
	    /* command line per process cruft */
	SBT	sbCmd;			/* current command line */
	SBT	sbCmdStart;		/* remembered for freeing purposes */
	    /* string storage in child */
	ADRT	adrSbStart;		/* where the buffer starts */
	ADRT	adrSb;			/* where we store next byte in buffer */
	ADRT	adrSbMax;		/* first adr AFTER buffer */
	SBT	sbArgsChild;  		/* args for child */
	    /* debugger local variables */
	int2	ilvMac;			/* number of locals used */
	int2	ilvMax;			/* number allocated */
	pSER	rgLv;			/* pointer to local variables */
	int2	stackdepth;		/* default depth for params/locals */
	pSER	seDot;			/* last expression result */
	} PRR, *pPRR;
#define cbPRR sizeof(PRR)
#define prNil ((pPRR)0)

#include "ext.h"  /* external declarations for all `export'ed procedures */
