/* $Header: cgram.y,v 5.20 86/07/18 06:14:40 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

/* DON'T TOUCH THIS IN ANYWAY OR THE WORLD WILL BREAK IN TWO!!! */
/* This is true to ending comment about 50 lines down */

%nonassoc	precLow
%left   	tkComma
%nonassoc	precGlobal
%nonassoc	precLocal
%right		tkAssign tkAssPlus tkAssMinus tkAssMult tkAssDiv tkAssMod tkAssXOR  tkAssBAND tkAssBOR tkAssLeft tkAssRight
%left   	tkQuest
%left   	tkLOR
%left		tkLAND
%left		tkBar
%left		tkUpArrow
%left		tkAmper
%left		tkEqual tkNotEqual
%left		tkLAB tkRAB tkLE tkGE
%left		tkLShift tkRShift
%left		tkPlus tkMinus
%left		tkStar tkDiv tkPercent
%left		precDeref precAddress precUMinus
%right		tkBang tkTilda tkPlusPlus tkMinusMinus tkSizeof precCoersion
%left		tkLSB tkLP tkDot tkPtr
%nonassoc	precLessHigh
%nonassoc	precHigh

/* start symbol */
%start  nontStart

/* the following stuff is in don't touch land because of the order
 * that yacc shoves its stuff (and the stuff it shoves) into the
 * resulting file.
 */
%{
#include "cdb.h"
%}

%union {
    SER    ase;
    }
%{

#define yyerror(x) if (yychar) {strcpy(vsbErr,x); yyerrok; yychar=0; vtkLast= -1; goto yynewstate;} else UError(vsbErr)

#define YYSTYPE SER

/* this macro will do the assign operations like +=,*= etc. */
#define AssignOp(src,dest,operand,operation)\
	    aseTmp1 = src;\
	    operation(& aseTmp2, & aseTmp1, & operand);\
	    Assign(& src, & aseTmp2);\
	    dest = src;

/* END OF DON'T TOUCH */

export char	vsbErr[200];	/* last error committed */
static	int	vipdGram, vilnGram;
static SBT	vsbGram;
static SER	aseTmp1, aseTmp2, aseTmp3; /* temps */

%}
%%

/* beginning of productions */

nontStart:  nontE
	{
	    vase = $1;
	}
    |
	{
	    vase.asym.st = stNil;
	}
    |   error
    ;

/* this is a seperate production for ',' otherwise yacc complains */

nontE:
	nontE tkComma nontE
	{
	    $$ = $3;
	}
    |   nontExpr
	{
	    $$ = $1;
	}
    ;

/* basically this is all of the binary operations */

nontExpr:
	nontExpr tkStar nontExpr
	{
	    Mul(& $$, & $1, & $3);
	}

    |   nontExpr tkDiv nontExpr
	{
	    Div(& $$, & $1, & $3);
	}

    |   nontExpr tkPercent nontExpr
	{
	    Mod(& $$, & $1, & $3);
	}

    |   nontExpr tkPlus nontExpr
	{
	    Add(& $$, & $1, & $3);
	}

    |   nontExpr tkMinus nontExpr
	{
	    Subtract(& $$, & $1, & $3);
	}

    |   nontExpr tkRShift nontExpr
	{
	    RShift(& $$, & $1, & $3);
	}

    |   nontExpr tkLShift nontExpr
	{
	    LShift(& $$, & $1, & $3);
	}

    |   nontExpr tkLAB nontExpr
	{
	    LT(& $$, & $1, & $3);
	}

    |   nontExpr tkRAB nontExpr
	{
	    GT(& $$, & $1, & $3);
	}

    |   nontExpr tkLE nontExpr
	{
	    LE(& $$, & $1, & $3);
	}

    |   nontExpr tkGE nontExpr
	{
	    GE(& $$, & $1, & $3);
	}

    |   nontExpr tkEqual nontExpr
	{
	    EQ(& $$, & $1, & $3);
	}

    |   nontExpr tkNotEqual nontExpr
	{
	    NE(& $$, & $1, & $3);
	}

    |   nontExpr tkAmper nontExpr
	{
	    BAnd(& $$, & $1, & $3);
	}

    |   nontExpr tkUpArrow nontExpr
	{
	    XOr(& $$, & $1, & $3);
	}

    |   nontExpr tkBar nontExpr
	{
	    BOr(& $$, & $1, & $3);
	}

    |   nontExpr tkLAND nontExpr
	{
	    LAnd(& $$, & $1, & $3);
	}

    |   nontExpr tkLOR nontExpr
	{
	    LOr(& $$, & $1, & $3);
	}

    /* '?:' -  this is a fun one, here's the scheme:
		We must evaluate everything because this might be embedded
		in some more complicated expression. When we are in the
		false code (i.e. a ? b : c -- if a is true, c is the false
		code) evaluate everything except those things that change
		state (Assignment and procedure calls).

		'vfInFalse' is the flag for this and the code takes into
		account nested '?:' statements.
    */
    |   nontExpr tkQuest
	{
	    GetVal(& $1);
	    Coerce(vseCnLong, & $1);
	    $$.val.valLong = vfInFalse;
	    vfInFalse = vfInFalse || ($1.val.valLong == 0);
	}
	 nontExpr tkColon
	{
	    vfInFalse = $3.val.valLong || !vfInFalse;
	}
	nontExpr %prec tkQuest
	{
	    $$ = ($1.val.valLong != 0) ? $4 : $7;
	    GetVal(& $$);
	    vfInFalse = $3.val.valLong;
	}

    |   nontExpr tkAssign nontExpr
	{
	    Assign(& $1, & $3);
	    $$ = $1;
	}
    |   nontExpr tkAssPlus nontExpr
	{
		AssignOp($1, $$, $3,Add);
	}

    |   nontExpr tkAssMinus nontExpr
	{
	    AssignOp($1, $$, $3,Subtract);
	}

    |   nontExpr tkAssMult nontExpr
	{
	    AssignOp($1, $$, $3,Mul);
	}

    |   nontExpr tkAssDiv nontExpr
	{
	    AssignOp($1, $$, $3,Div);
	}

    |   nontExpr tkAssMod nontExpr
	{
	    AssignOp($1, $$, $3,Mod);
	}

    |   nontExpr tkAssXOR nontExpr
	{
	    AssignOp($1, $$, $3,XOr);
	}

    |   nontExpr tkAssBAND nontExpr
	{
	    AssignOp($1, $$, $3,BAnd);
	}

    |   nontExpr tkAssBOR nontExpr
	{
	    AssignOp($1, $$, $3,BOr);
	}

    |   nontExpr tkAssLeft nontExpr
	{
	    AssignOp($1, $$, $3,LShift);
	}

    |   nontExpr tkAssRight nontExpr
	{
	    AssignOp($1, $$, $3,RShift);
	}

    /* procedure call-- get the args then do the call */
    |   nontExpr tkLP 
	{
	    /* at this point we set up the pointer for args */
	    if (vseArgs == (pSER) -1) /* first time*/
		vseArgs = & yyv[YYMAXDEPTH];
	    $$.val.valLong = (long) vseArgs; /* KLUDGE?!?!?!??! */
	}
	nontExprList tkRP
	{
	    if ($1.ti.tq0 == tqProc) {
		if (!vfInFalse)
		    DoProc(& $$, & $1, vseArgs, $3.val.valLong);
		vseArgs = (pSER) $3.val.valLong; /* reset */
	    } else if (($1.ti.tq1 == tqProc) AND ($1.ti.tq0 == tqPtr)) {
		/* we will dereference it for them */
		if (!vfInFalse) {
		    GetOrig(&$1);
		    $1.asym.sc = scNil;
		    Coerce(vseAdr, & $1);
		    $1.asym.value = $1.val.valAdr;
		    DoProc(& $$, & $1, vseArgs, $3.val.valLong);
		} /* if */
		vseArgs = (pSER) $3.val.valLong; /* reset */
	    } else {
		UError("Illegal function");
	    }
	}
		
    |	nontIdent tkHash tkNumber
       	{
	    /* given procname#linenumber, give address */
	    vsbGram = SbFIss($1.asym.iss);
	    vipdGram = IpdFName(vsbGram);
	    Coerce(vseCnInt, &$3);
	    vilnGram = $3.val.valInt;

LineToAdrKludge:
	    if (v->rgPd[vipdGram].iline == 0) {
		UError("I have no line numbers for procedure \"%s\"", vsbGram);
	    } else {
		CopyTy(& $$, vseCnULong);
		$$.val.valAdr = $$.asym.value =
		   AdrFIfdIln(IfdFAdr(v->rgPd[vipdGram].adr), vilnGram);
		if ($$.val.valAdr == adrNil)
		    UError("Line %d does not map to code in procedure %s",
			vilnGram, vsbGram);
		$$.ti.bt = btAdr;
		$$.ti.fConstant = true;
		$$.asym.st = stExpr;
	    } /* if */
	}

    |	tkHash tkNumber
       	{
	    vipdGram = v->ipd;
	    Coerce(vseCnInt, &$2);
	    vilnGram = $2.val.valInt;
	    vsbGram = SbFIpd(v->ipd);
	    goto LineToAdrKludge;
	}

    |   nontTerm	    %prec precLow
	{
	    $$ = $1;
	    GetAdr(& $$);
	    if (($$.ti.bt == btFloat) OR ($$.ti.bt == btDouble))
		ValFSe(&$$);
	}
    ;

/* these are basically single op type stuff */

nontTerm:
	tkAmper nontTerm	%prec precAddress
	{
	    GetAdr(& $2);
	    if ( ($2.ti.fConstant)
	       AND ($2.ti.tq0 == tqNil)
	       AND ($2.ti.bt != btStruct)
	       AND ($2.ti.bt != btUnion) )
		UError("Operand for '&' incorrect");
	    /* we turn it into a constant pointer to itself */
	    $$ = $2;
	    $$.val.valAdr = $2.asym.value;
	    $$.ti.fConstant = true;
	    AddTq(&$$, tqPtr);
	}

    |   nontTerm tkLSB nontExpr tkRSB	%prec tkLSB
	{
	    int		cb;

	    GetOrig(& $1);
	    GetOrig(& $3);

	    if (($1.ti.tq0 != tqArray) 
	       AND ($1.ti.tq0 != tqPtr)) {
		/* we allow this to act the same as if $1 were
		 * the name of an array of the type of $1.
		 */
		AddTq(&$1, tqArray);
		$1.val.valAdr = $1.asym.value;
	    } /* if */

	    Add(&$$, & $1, & $3);
	    $$.asym.sc = scNil;
	    if ($$.ti.tq0 == tqNil)
		Coerce(vseAdr, & $$);
	    $$.asym.value = $$.val.valAdr;
	    RemoveTq(& $$);	/* get rid of array/pointer-ness */
	    $$.ti.fConstant = false;
	    GetVal(& $$);
	    if (($$.ti.tq0 == tqArray) OR ($$.ti.tq0 == tqProc))
		$$.val.valAdr = $$.asym.value;
	    $$.asym.iss = issNil;
	}

    |   tkMinus nontTerm	%prec precUMinus
	{
	    GetOrig(& $2);
	    aseTmp1 = $2;
	    ZeroBlock(& aseTmp1.val, sizeof (VALU));
	    Subtract(& $$, & aseTmp1, & $2);
	}

    |   tkBang nontTerm
	{
	    Bang(& $$, & $2);
	}

    |   tkTilda nontTerm
	{
	    Tilda(& $$, & $2);
	}

    |   tkPlusPlus nontTerm
	{
	    aseTmp1 = *vseCnChar;
	    aseTmp1.val.valChar = 1;
	    GetAdr(& $2);
	    aseTmp2 = $2;
	    Add(& aseTmp3, & aseTmp2, & aseTmp1);
	    Assign(& $2, & aseTmp3);
	    $$ = $2;
	}

    |   tkMinusMinus nontTerm
	{
	    aseTmp1 = *vseCnChar;
	    aseTmp1.val.valChar = 1;
	    GetAdr(& $2);
	    aseTmp2 = $2;
	    Subtract(& aseTmp3, & aseTmp2, & aseTmp1);
	    Assign(& $2, & aseTmp3);
	    $$ = $2;
	}

    |   nontTerm tkPlusPlus
	{
	    aseTmp1 = *vseCnChar;
	    aseTmp1.val.valChar = 1;
	    GetAdr(& $1);
	    aseTmp2 = $1;
	    aseTmp3 = $1;
	    GetOrig (& aseTmp3);	/* need 'before' value */
	    Add(& $$, & aseTmp2, & aseTmp1);
	    Assign(& $1, & $$);
	    $$ = aseTmp3;
	    $$.ti.fConstant = true;
	    $$.asym.iss = issNil;
	}


    |   nontTerm tkMinusMinus
	{
	    aseTmp1 = *vseCnChar;
	    aseTmp1.val.valChar = 1;
	    GetAdr(& $1);
	    aseTmp2 = $1;
	    aseTmp3 = $1;
	    ValFSe(& aseTmp3);
	    /* GetOrig (& aseTmp3);	/* need 'before' value */
	    Subtract(& $$, & aseTmp2, & aseTmp1);
	    Assign(& $1, & $$);
	    $$ = aseTmp3;
	    $$.ti.fConstant = true;
	    $$.asym.iss = issNil;
	}

    |   tkArg tkLP nontExpr tkRP
	{
	    /* $arg(x)  - returns the x'th INT arg */
	    char	sbName[10];

	    GetVal(& $3);
	    Coerce(vseCnInt, &$3);
	    $$ = *vseInt;
	    GetArgN(&$$, $3.val.valInt);
	    sprintf(sbName, "$arg(%d)", $3.val.valInt);
	    $$.asym.iss = IssFSb(sbName);
	}

    |   tkInside tkLP nontIdent tkRP
	{
	    int		ipd;

	    /* returns true if current pc is in the named procedure */

	    $$ = *vseCnInt;
	    $$.asym.iss = $1.asym.iss;
	    $$.val.valInt = IpdFAdr(v->acntx.pc)
				== IpdFName(SbFIss($3.asym.iss));
	}

    |   tkSizeof nontTerm
	{
	    GetAdr(& $2);
	    $$ = *vseCnInt;
	    $$.val.valInt = CbFSe(& $2);
	}

    |   tkLP nontType  tkRP nontTerm    %prec precCoersion
	{
	    /* type cast to KEYWORD type */
	    GetOrig(& $4);
	    Coerce(& $2, & $4);
	    $$ = $4;
	}

    |   nontIdent
	{
	    $$ = $1;
	    if (($$.ti.bt == btFloat) OR ($$.ti.bt == btDouble))
		ValFSe(&$$);
	}

    |   tkNumber
	{
	    $$ = yylval;
	    $$.asym.st = stNumber;
	}

    |   tkFltConstant
	{
	    $$ = yylval;
	    $$.asym.st = stExpr;
	}

    |   tkStrConstant
	{
	    $$ = *vseCnAdr;
	    $$.asym.value = AdrFStore(vsbLex, strlen(vsbLex) + 1);
	    $$.val.valAdr = $$.asym.value;
	}
    |   tkCharConstant
	{
	    $$ = *vseCnChar;
	    $$.asym.st = stExpr;
	    $$.val.valChar = vsbTok[0];
	}

    |	nontTerm tkDot nontIdent
	{
	    $$.asym.iss = $3.asym.iss;	/* give result the field name */
	    GetAdr(& $1);

	    if (vfStrict) {
		if ( ($1.ti.tq0 != tqNil)
		 OR ((($1.ti.bt != btStruct)
		    AND ($1.ti.bt != btUnion))) ) {
    printf("You may not use the \".\" operator on something of this type\n");
		PxSe(&$1, true);
		UError("");
		} /* if */
	    } /* if */

	    FField(& $1, & $$);
	}

    |	nontTerm tkPtr nontIdent
	{
	    GetVal(& $1);

	    if (vfStrict) {
		if ( ($1.ti.tq0 != tqPtr)
		 OR ((($1.ti.bt != btStruct)
		    AND ($1.ti.bt != btUnion))) ) {
    printf("You may not use the \"->\" operator on something of this type\n");
		PxSe(&$1, true);
		UError("");
		} /* if */
	    } /* if */

	    if ($1.ti.tq0 == tqNil)
		Coerce(vseAdr, & $1);
	    $1.asym.value = $1.val.valAdr;
	    $$.asym.iss = $3.asym.iss;	/* give result the field name */
	    FField(& $1, & $$);
	}

    |	tkStar nontTerm			%prec precDeref
	{
	    GetOrig(& $2);

	    $$ = $2;
	    $$.asym.sc = scNil;
	    if ($$.ti.tq0 == tqNil)
		Coerce(vseAdr, & $$);
	    $$.asym.value = $$.val.valAdr;
	    $$.ti.fConstant = false;
	    RemoveTq(& $$);	/* get rid of array/pointer-ness */
	    GetVal(& $$);
	    if (($$.ti.tq0 == tqArray) OR ($$.ti.tq0 == tqProc))
		$$.val.valAdr = $$.asym.value;
	    $$.asym.iss = issNil;
	}

    |	tkDot
	{
	    $$ = *v->seDot;
	}

    |   tkColon nontIdent		%prec precGlobal
	{
	    $$ = $2;
	    if (!FGlobal(& $$))
		UError("No such global: %s", SbFIss($2.asym.iss));
	}

    |   tkNumber tkHash nontIdent	%prec precLocal
	{
	    $$ = $3;
	    Coerce(vseCnInt, &$1);
    	    if (!FLocal(& $$, ipdNil, $1.val.valInt))
		UError("No such local: %s", SbFIss($3.asym.iss));
	}

    |   nontIdent tkHash nontIdent	%prec precLocal
	{
	    int	ipd;

	    $$ = $3;
	    ipd = IpdFName(SbFIss($1.asym.iss));
    	    if (!FLocal(& $$, ipd, -1))
		UError("No such local: %s", SbFIss($3.asym.iss));
	}

    |	tkLP nontE tkRP
	{
	    $$ = $2;
	    $$.asym.st = stExpr;
	}
    ;

nontIdent:  tkStr
	{
	    $$.asym.st = stStr;
	    $$.asym.iss = IssFSb(vsbLex);
	}
    ;

nontExprList:   /* empty */
    |   nontExprList2
    ;

nontExprList2:  nontExpr	%prec tkComma
	{
	    GetVal(& $1);
	    *(--vseArgs) = $1;
	}
    |   nontExpr tkComma nontExprList2
	{
	    GetVal(& $1);
	    *(--vseArgs) = $1;
	}
    ;

nontType:   nontBase nontDesc
	{
	    int		tq, i, idim, idimTemp;
	    $$ = $1;

	    /* Tack on $2's info */
	    idim = 0;	/* first, count their dimensions */
	    for (i = 0; i < itqMax; i++) {
		if ((tq = TqFSe(&$$, i)) == tqNil)
		    break;
		if (tq == tqArray)
		    idim++;
	    } /* for */

	    idimTemp = 0;
	    for (i = 0; i < itqMax; i++) {
		if ((tq = TqFSe(&$2, i)) == tqNil)
		    break;
		AddTq(&$$, tq);
		if (tq == tqArray) {
		    /* add this to the dimensions we already have */
		    if (idim >= idimMax)
			UError("%s has more than %d dimensions",
			    SbFIss($$.asym.iss), idimMax);
		    $$.rgRng[idim++] = $2.rgRng[idimTemp++];
		} /* if */
	    } /* for */

	    /* $$.ti = $2.ti;	/* KLUDGE?!?!?! - YES! */
	    $$.ti.bt = $1.ti.bt;
	    $$.ti.fConstant = true;
	}

nontDesc:	       %prec precLow
	{ /* no abstractor ( *, [], () ) */
	    CopyTy(& $$, vseInit);
	}

    |   nontFDesc
	{
	    $$ = $1;
	}
    |   tkLP nontFDesc tkRP     %prec precLessHigh
	{
	    $$ = $2;
	    $$.asym.st = stType;
	}
    ;

nontFDesc: tkStar nontDesc         %prec precHigh
	{
	    AddTq(& $2, tqPtr);
	    $$ = $2;
	}
    |   nontDesc tkLSB tkRSB	%prec precHigh
	{
	    /* KLUDGE ! I KNOW this ain't right! */
	    if ($1.asym.st != stType) {
		AddTq(& $1, tqArray);
	    } else {
		AddTq(& $1, tqArray);
	    }
	    $$ = $1;
	}

    |   nontDesc tkLP tkRP      %prec precHigh
	{
	    if ($1.asym.st != stType) {
		AddTq(& $1, tqProc);
	    } else {
		AddTq(& $1, tqProc);
	    }
	    $$ = $1;
	}
    ;

nontBase: tkStruct nontIdent
	{
	    $$.asym.iss = $2.asym.iss;
	    if (!FTypeFName(& $$, tkStruct))
		UError("Struct identifier (%s) not found", SbFIss($2.asym.iss));
	}

    |	tkUnion nontIdent
	{
	    $$.asym.iss = $2.asym.iss;
	    if (!FTypeFName(& $$, tkUnion))
		UError("Union identifier (%s) not found", SbFIss($2.asym.iss));
	}

    |	tkEnum nontIdent
	{
	    $$.asym.iss = $2.asym.iss;
	    if (!FTypeFName(& $$, tkEnum))
		UError("Enum identifier (%s) not found", SbFIss($2.asym.iss));
	}

    |	tkTypedef
	{
	    CopyTy(& $$, & $1);
	}

    |	tkUnsigned tkChar
	{
	    CopyTy(& $$, vseCnUChar);
	}

    |   tkUnsigned tkShort
	{
	    CopyTy(& $$, vseCnUShort);
	}

    |   tkUnsigned tkInt
	{
	    CopyTy(& $$, vseCnUInt);
	}

    |   tkUnsigned tkLong
	{
	    CopyTy(& $$, vseCnULong);
	}

    |    tkChar
	{
	    CopyTy(& $$, vseCnChar);
	}

    |    tkShort
	{
	    CopyTy(& $$, vseCnShort);
	}

    |    tkInt
	{
	    CopyTy(& $$, vseCnInt);
	}

    |    tkLong
	{
	    CopyTy(& $$, vseCnLong);
	}

    |    tkFloat
	{
	    CopyTy(& $$, vseCnFloat);
	}

    |    tkDouble
	{
	    CopyTy(& $$, vseCnDouble);
	}
    ;
%%
