/* $Header: cmd.c,v 6.6 86/09/11 18:13:32 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

#include "cdb.h"
#include "signal.h"
#include "errno.h"

static char	vsbOffset[15] = "---> "; /* used to offset comments */
static char	vsbTarget[100];	/* used for string searches */
static char	vchSearch = '/';	/* contains either ? or / */

export FLAGT	vfIgnoreCase = true;
export CMDE	vcmdDef;
export char	vsbFileTemp[256]; /* name of ifdTemp file */

MODER	vamodeInst = {dfInstruction, -1, 1, 0};


/* S E T   C M D */

export void SetCmd(sb)
SBT	sb;
{
    if (v->sbCmdStart != sbNil)
	free(v->sbCmdStart);
    v->sbCmd = v->sbCmdStart = SbFAlloc(sb);
} /* SetCmd */


/* I L N   F   N O R M A L I Z E */

export int IlnFNormalize(ifd, iln)
int	ifd, iln;
{
    if (iln < 1)
	iln = 1;
    else if (iln >= v->rgFd[ifd].ilnMac)
	iln = v->rgFd[ifd].ilnMac - 1;
    return(iln);
} /* IlnFNormalize */


/* C A L L   S H E L L */

export void CallShell(sbCmd)
SBT	sbCmd;
{
    SBT		sbShell;
    char	sbBuffer[100];

    if ((sbCmd == sbNil) OR (*sbCmd == chNull)) {
	sbShell = getenv("SHELL");
	if (sbShell == sbNil)
	    sbShell = "/bin/sh";
	sprintf(sbBuffer, "%s -i", sbShell);
	sbCmd = sbShell;
    } /* if */
    system(sbCmd);
    if (!v->fQuiet)
	printf("\nBack in %s, debugging %s.\n", vsbDebugName, v->sbExec);
} /* CallShell */


/* E A T   C M D   L I S T */

export char * EatCmdList(pcnt)
int2	*pcnt;
{
    SBT		sbCmd, sbTemp;
    TKE		tk;

    sbCmd = v->sbCmd;
    tk = TkPeek();
    if (tk == tkNil)
	return(sbNil);

    if (tk != tkLCB) {
	/* give caller the rest of line */
	v->sbCmd = sbTemp = sbCmd + strlen(sbCmd);
    } else {
	tk = TkNext();	/* eat { */
	sbCmd = v->sbCmd;
	sbTemp = SbFEob(v->sbCmd) - 1;
	v->sbCmd = sbTemp + 1;
    } /* if */
    while ((*sbCmd == ' ') OR (*sbCmd == '\t'))
	sbCmd++;
    *pcnt = sbTemp - sbCmd;
    return(sbCmd);
} /* EatCmdList */


/* E A T   F I L E N A M E */

local void EatFilename(sbName, psbIn)
SBT	sbName, *psbIn;
{
    int		cch;
    SBT		sbIn;

    sbIn = *psbIn;
    while (*sbIn == '\t' OR *sbIn == ' ')
	sbIn++;
    cch = strcspn(sbIn, "\t ;}");
    strncpy(sbName, sbIn, cch);
    sbName[cch] = chNull;
    *psbIn = sbIn + cch;
} /* EatFilename */


/* S B   F   E O B */

export SBT SbFEob(sb)
SBT	sb;
{
    int		cNest;
    FLAGT	fString = false;

    /* return pointer to AFTER chRCB, or to the chNull */
    cNest = (*sb == chLCB) ? 0 : 1;
    while (*sb) {
	if ((*sb == '\\') AND (sb[1] == '"')) {
	    sb += 2;
	    continue;
	}
	if (fString) {
	    if (*sb == '"')
		fString = false;	/* end of string literal */
	} else if (*sb == '"') {
	    fString = true;		/* beginning of string literal */
	} else if (*sb == chLCB) {
	    cNest++;			/* additional nesting */
	} else if (*sb == chRCB) {
	    if (--cNest <= 0)
		return(sb+1);
	}
	sb++;
    } /* while */
    return(sb);
} /* SbFEob */


/* G O T O   I L N */

export void GotoIln(iln)
int2	iln;
{
    ADRT	adr;

    adr = AdrFIfdIln(v->ifd, iln);
    if (IpdFAdr(adr) != IpdFAdr(v->acntx.pc))
	UError("You can't goto a line outside of the current procedure.");
    PutReg(upc, adr);
} /* GotoIln */


/* F   C H K   C O M M A N D */

local FLAGT FChkCommand()
{
    FLAGT	fCommand;
    char	chCmd, chNext;
    SBT		sbCmds, sbTwoChars;
    TKE		tk;

    /* We guess whether we have a command or an expression.
     * We start with the current token.
     * This is a little weird because we try to do the `right' thing
     */

    if (vtk == tkCharConstant)
	return(false);

    sbCmds = "aAbBcCdDeEfFghHiIklLMNpPqQrRsStTvwWxYzZ\n<>-+@?/^!~;{}";
    sbTwoChars = "<>bcisSY";	/* commands of two or more characters */

    tk = vtk;
    chCmd = vsbTok[0];
    fCommand = (tk == tkNil);
    if (strchr(sbCmds, chCmd) != sbNil) {
	/* the first letter LOOKS like a command, keep going */
	fCommand = (vcbTok == 1);
	if ((vcbTok > 1)
	   AND ((tk == tkStr) OR (tk== tkRShift) OR (tk == tkLShift))) {
	    /* It is longer than 1 character, might be a variable name */
	    chNext = vsbTok[1];
	    if ( (vcbTok == 2)
	       AND (strchr(sbTwoChars, chCmd) != sbNil) ) {
		fCommand =   (chCmd == 'b' AND strchr("bBituUxX", chNext))
			  OR ((chCmd == 'c' OR chCmd == 'C')
					AND strchr("uU", chNext))
			  OR (chCmd == 'Y' AND strchr("chopqs", chNext))
			  OR (chCmd == 'i' AND chNext == 'f')
			  OR ((chCmd == 's' OR chCmd == 'S')
			     AND (chNext == 'I' OR chNext == 'i'))
			  OR (chCmd == '<' AND chNext == '<')
			  OR (chCmd == '>' AND chNext == '>');
	    } /* if */
	} /* if */
	/* a final chance to change our minds */
	TkPeek(); /* load peek token information */
	if (   (tk == tkStr)
	   AND (*v->sbCmd != ' ')
	   AND (vsbTokPeek[0] != chNull)
	   AND !(strchr(";\175", vsbTokPeek[0])) ) {
	    fCommand = false;
	} /* if */
    } /* if */
    return(fCommand);
} /* FChkCommand */


/* F   D O   C O M M A N D */

export FLAGT FDoCommand(sbCmdIn, fTop)
char	*sbCmdIn;
FLAGT	fTop;
{
    char	ch, chBp, chCmd, chNext;
    char	sbName[80], sbBuf1[200], sbBuf2[200];
    SBT		sb, sbBp, sbTemp;
    int		valInt;
    int2	iln, cLn, cnt, ifd, ipd;
    int2	sig, i, ilnSave, bpc;
    pBPR	bp;
    pPRR	pr;
    FLAGT	fHaveValue, fOutput, fDidit, fDoit, fCommand, fMachineStatement;
    ADRT	adr;
    TKE		tk;
    ASE		as;
    SER		aseExpr, aseT, *seExpr = &aseExpr, *seT = &aseT;
    VALU	val;
    FLAGT	fFreedProcess;

    /* the commands */
    SetCmd(sbCmdIn);

    tk = TkNext();
    do {
	if ((tk == tkStr) AND (FSbCmp("help", vsbTok))) {
	    Help();
	    vcmdDef = cmdNil;
	    continue;
	} else if (tk == tkStrConstant) {
	    printf("%s", vsbTok);
	    vcmdDef = cmdNil;
	    continue;
	} /* if */

	fHaveValue = false;
	fCommand = FChkCommand();
	*seExpr = *v->seDot;

	if (!fCommand) {
	    /* Assume it is a beginning expression */
	    SetViewPosition(adrNil);
	    SeFExpr(seExpr);
	    if (seExpr->asym.st != stNil) {
		/* we got something - get value for those who care */
		*seT = *seExpr;
		Coerce(vseInt, seT);
		seT->ti.fConstant = seExpr->ti.fConstant;
		val = ValFSe(seT); /* many just want value */
		valInt = val.valInt;
		fHaveValue = true;
	    } else {
		UError("Unknown name '%s'.", vsbTok);
	    } /* if */
	} /* if */

	cnt = 1;
	chCmd = vsbTok[0];
	chNext = vsbTok[1];

	switch (chCmd) {
	    default:
		    vcmdDef = cmdNil;
#ifdef V7_PRINTF
		    UError("Unknown command `%c' (0%o)\n.", chCmd, chCmd);
#else
		    UError("Unknown command `%c' (%#o)\n.", chCmd, chCmd);
#endif /* V7_PRINTF */

	    case '\n':
	    case '~':
	    case chNull:		/* default command */
		    if (!fHaveValue) {
			switch (vcmdDef) {
			    case cmdPrint:
				/* we print it, if we have it */
				
				if ((v->rgFd[v->ifd].iline != 0)
				   AND (! v->rgFd[v->ifd].fNoSource)) {
				    v->iln = IlnFNormalize(v->ifd, v->iln+1);
				    v->slop = 0;
				    ShowViewPosition(fmtLn+fmtSrcLineOnly);
				    if (vfWindows AND !vfEofSeen)
					UpLine(true);
				    break;
				} /* if */

				/* else we fall through and treat it
				 * as a disassembly request.
				 */
				*v->seDot = *vseCnAdr;
				v->seDot->val.valAdr = v->adrInst;
				*vmode = vamodeInst;
				vcmdDef = cmdDisplay;

				/* fall through */

			    case cmdUpArrow:
			    case cmdDisplay:
				IncFSeMode(v->seDot, vmode,
					((vcmdDef == cmdUpArrow) ? -1 : 1) );
				DisplaySe(v->seDot, vmode, true, true, true);
				printf("\n");
				break;

			    case cmdLineSingle:
				printf("s: ");
				SingleStep(vcmdDef, false);
				break;

			    case cmdMachSingle:
				printf("si: ");
				SingleStep(vcmdDef, false);
				break;

			    case cmdMachProc:
				printf("Si: ");
				SingleStep(vcmdDef, false);
				break;

			    case cmdLineProc:
				printf("S: ");
				SingleStep(vcmdDef, false);
				break;
			} /* switch */
		    } else if (seExpr->asym.st == stNumber) {
			if (valInt > 0)
			    v->iln = valInt;
			 else
			     v->iln += valInt;
			v->iln = IlnFNormalize(v->ifd, v->iln);
			v->slop = 0;
			ShowViewPosition(fmtLn+fmtSrcLineOnly);
			if (vfWindows)
			    UpLine(true);
			vcmdDef = cmdPrint;
		    } else  {
			*v->seDot = *seExpr;
			vmode->df = dfNil;
			vmode->len = -1;
			vmode->cnt = 1;
			vmode->imap = 0;
			vcmdDef = cmdDisplay;
			DisplaySe(v->seDot, vmode, true, true, true);
			printf("\n");
		    } /* if */
		    break;

	    case '+':	/* go forward N (1) line and print it */
	    case '-':	/* go backward N (1) line and print it */
		    i = LongFExpr(seT, tkNil);
		    if (seT->asym.st == stNil)
			i = 1;
		    v->iln += (chCmd=='-') ? -abs(i) : abs(i);
		    v->iln = IlnFNormalize(v->ifd, v->iln);
		    ShowViewPosition(fmtLn+fmtSrcLineOnly);
		    if (vfWindows)
			UpLine(true);
		    vcmdDef = cmdPrint;
		    break;

	    case '!':
		    sbTemp = EatCmdList(&cnt);
		    strncpy(sbName, sbTemp, cnt);
		    sbName[cnt] = chNull;
		    CallShell(sbName);	/* shell escape */
		    vcmdDef = cmdNil;
		    break;

	    case '^':	/* attempt to move backward, displaying memory */
		    GetMode(vmode);
		    IncFSeMode(v->seDot, vmode, -1);
		    DisplaySe(v->seDot, vmode, true, true, true);
		    printf("\n");
		    vcmdDef = cmdUpArrow;
		    break;

	    case '/':	/* 2 commands:  'X/Y' == display *X in format Y
			 *		'/hi mom' == search FORWARDS and print
			*/
	    case '@':	/* 2 commands:  'X@Y' == display X in format Y */
	    case '?':	/*	'?hi mom' == search BACKWARDS and print */
		    if (!fHaveValue) {
			/* search for something */
			if (*v->sbCmd != chNull) {
			    strcpy(vsbTarget, v->sbCmd);
			    *v->sbCmd = chNull;
			} /* if */
			vchSearch = chCmd;
			Find(vsbTarget, (chCmd=='?'));
			v->slop = 0;
			vcmdDef = cmdPrint;
		    } else {
			*v->seDot = *seExpr;
			if (chCmd == '/') {
			    /* this prints the CONTENTS of an address */
			    GetMode(vmode);
			    DisplaySe(v->seDot, vmode, true, true, true);
			    vcmdDef = cmdDisplay;
			} else {
			    /* this prints an ADDRESS */
			    vmode->df = dfAdr;
			    vmode->len = v->cpu->cbPointer;
			    vmode->cnt = 1;
			    GetMode(vmode);
			    DisplaySe(v->seDot, vmode, true, false, false);
			    vcmdDef = cmdNil;
			} /* if */
			printf("\n");
		    } /* if */
		    break;

	    case '<':	/* playback commands */
		    EatFilename(sbName, &v->sbCmd);
		    SetPlayback(sbName, false, (chNext == '<'));
		    break;

	    case '>':	/* record commands */
		    fOutput = (chNext == '>');
		    tk = TkPeek();
		    if ((tk == tkSemi) OR (tk == tkNil)) {
			StateRecord();
			break;
		    }
		    if (vsbTokPeek[1] == chNull) {
		        if (  (vsbTokPeek[0] == 't')
			   OR (vsbTokPeek[0] == 'f')) {
			    TkNext();	/* actually eat next token */
			    if (fOutput)
				vfOutput = (vsbTok[0] == 't');
			    else
				vfRecord = (vsbTok[0] == 't');
			    break;
		        } else if (vsbTokPeek[0] == 'c') {
			    TkNext();	/* actually eat next token */
			    if (fOutput)
				SetOutput(sbNil);
			    else
				SetRecord(sbNil);
			    break;
		        } /* if */
			/* we fall through on other, 1 character filenames */
		    } /* if */
		    EatFilename(sbName, &v->sbCmd);
		    if (fOutput)
			SetOutput(sbName);
		    else
			SetRecord(sbName);
		    break;

	    case ';':	/* just a command delimiter */
		    vcmdDef = cmdNil;
		    break;

	    case 'A':	/* modify main assertion state */
		    tk = TkPeek();
		    if (tk != tkNil) {
			TkNext();
			v->as = ((*vsbTok == '1') OR
				(*vsbTok == 'a')) ? asActive : asSuspended;
		    } else {
			if (v->iadMac <= 0)
			    UError("There are currently no assertions.");
			v->as = (v->as==asSuspended) ? asActive : asSuspended;
			printf("Assertions are %s\n", (v->as==asSuspended) ?
				    "SUSPENDED" : "ACTIVE");
		    }
		    vcmdDef = cmdNil;
		    break;

	    case 'a': /* maintain assertion list */
		    if (fHaveValue) {
			TkNext();
			switch (vsbTok[0]) {
			    case 'a':
				as = asActive;
				break;

			    case 'd':
				as = asNil;
				break;

			    case 's':
				as = asSuspended;
				break;
			    default:
			       UError("Invalid assertion maintenance command.");
			} /* switch */
			ModAssert(valInt, as);
			break;
		    } /* if */
		    if ((sbTemp=EatCmdList(&cnt)) != sbNil)
			AddAssert(sbTemp, cnt);
		    break;

	    case 'B': /* list all breakpoints */
		    ListBp();
		    break;

	    case 'b':	/* set (set again) a break point */
		    chBp = chNext;
		    sbBp = EatCmdList(&cnt);
		    bp = bpNil;
		    if (chBp == chNull) {
			/* vanilla breakpoint */
			if (! fHaveValue) {
			    adr = AdrFIfdIln(v->ifd, v->iln);
			} else {
			    /* there are two flavors - iln and addr */
			    if (seExpr->asym.st == stNumber) {
				/* normal line number */
				adr = AdrFIfdIln(v->ifd, valInt);
			    } else {
				/* raw address */
				adr = seExpr->val.valAdr;
				if (adr == v->rgPd[IpdFAdr(adr)].adr)
				    adr = AdrFPreamble(adr);
			    } /* if */
			} /* if */
			bp = BpFAddBp(adr, 1, sbBp, cnt);
		    } else if (chBp == 'i') {
			/* instruction level break */
			if (fHaveValue) {
			    ValFSe(seExpr);
			    Coerce(vseCnAdr, seExpr);
			    adr = seExpr->val.valAdr;
			} else {
			    adr = v->adrInst;
			} /* if */
			bp = BpFAddBp(adr, 1, sbBp, cnt);
		    } else {
			SetViewPosition(adrNil);
			ch = chBp | 040;	/* convert to lower */
			i = (fHaveValue) ? valInt : (ch=='u') ? 1 : -1;
			bpc = (ch == 'u') ? bpcUp :
					(ch == 'b') ? bpcBegin :
					(ch == 't') ? bpcProc :
					(ch == 'x') ? bpcEnd : bpcNil;
			bp = BpFSet(bpc, (chBp != ch), i, sbBp, cnt);
		    } /* if */
		    if ((bp != bpNil) AND (!v->fQuiet)) {
			printf("Break set at ");
			PrintPosition(bp->adr, fmtProc+fmtLn+fmtEol);
		    } /* if */
		    vcmdDef = cmdNil;
		    break;

	    case 'C':
	    case 'c':
		    if (chNext != chNull) {
			/* they want to set a breakpoint, too */
			i = (fHaveValue) ? valInt : 1;
			BpFSet(bpcUp, chNext == 'U', i, sbNil, 0);
			fHaveValue = false;
		    } /* if */

		    if (fHaveValue) {
			/* we have a continuance count */
			i = valInt;
			if (v->bp != bpNil)
			    v->bp->count = i;
		    } /* if */

		    i = LongFExpr(seT, tkNil);
		    if (seT->asym.st != stNil) {
			adr = AdrFIfdIln(v->ifd, i);
			bp = BpFAddBp(adr, -1, "", 0);
		    } /* if */

		    if (chCmd == 'C') {
			v->sig = v->sigOrig;
			if ((v->sig == v->os->sigTrap)
			   AND (v->os->mpSigSa[v->sig].fIgnore))
			    v->sig = 0;	/* this prevents *extreme* weirdness */
		    } /* if */
		    if (viprMax == 1) {
			RunProcess(ptResume, psRunning, !vfAnalyzeStop);
			if (vfAnalyzeStop)
			    /* This says that a 'c' in a breakpoint
			     * command string is ALSWAYS the last
			     * command - like it or not!
			     * This solves ugly recursion problem.....
			     */
			    return(true);
		    } else {
			/* multiprocess */
			RunProcess(ptResume, psRunning, false);
		    } /* if */

		    vcmdDef = cmdNil;
		    break;

	    case 'D':
		    ClearAllBp();
		    vcmdDef = cmdNil;
		    break;

	    case 'd':
		    adr = adrNil;
		    if (!fHaveValue) {
			/* if they want default, try current line number */
			SetViewPosition(adrNil);
			adr = AdrFIpdIln(v->ipd, v->iln);
			if (bpNil == BpFAdr(adr, false))
			    /* no such line OR no break, try it with the pc */
			    adr = v->acntx.pc;
		    } else if ((valInt >= 0) AND (valInt < v->ibpMac)) {
			/* give them named break */
			adr = v->rgBp[valInt].adr;
		    } /* if */

		    bp = BpFAdr(adr, false);
		    if (bp == bpNil) {
			printf("No such breakpoint\n");
			ListBp();
		    } else {
			ClearBp(bp);
		    } /* if */

		    vcmdDef = cmdNil;
		    break;

	    case 'e':
		    vcmdDef = cmdPrint;
		    if (fHaveValue) {
			OpenStack(valInt);
			break;
		    } /* if */
		    tk = TkPeek();
		    if (tk == tkNil) {
			SetViewPosition(adrNil);
			PrintPosition(adrNil, fmtFile+fmtProc+fmtLn+fmtEol);
		    } else {
			fDidit = false;
			EatFilename(sbName, &v->sbCmd);
			if ( (strchr(sbName, '.') == sbNil)
			   AND ((ipd = IpdFName(sbName)) != ipdNil) ) {
			    /* assume it's a procedure name */
			    OpenIpd(ipd, true);
			    ShowViewPosition(fmtFile+fmtProc
					+fmtLn+fmtLine+fmtEol);
			    fDidit = true;
			} else {
			    /* assume it's a file name */
			    if ((ifd = IfdFName(sbName)) == ifdNil) {
				ifd = ifdTemp;
				strcpy(vsbFileTemp, sbName);
				v->rgFd[ifd].iss = IssFSb(vsbFileTemp);
				v->ifd = ifdNil;
			    } /* if */
			    OpenIfd(ifd);
			    ShowViewPosition(fmtFile+fmtLn+fmtLine);
			    fDidit = true;
			} /* if */
			if (!fDidit)
			    UError("No such procedure or file name: %s.",
				sbName);
		    } /* if */
		    break;

	    case 'E':
		    cnt = (fHaveValue) ? valInt : 0;
		    OpenStack(cnt);
		    vcmdDef = cmdPrint;
		    break;

	    case 'F':	/* find and fix bug */
		    FindAndFix();
		    break;

	    case 'f':	/* set address display format */
		    tk = TkNext();
		    if (tk == tkStrConstant) {
			strncpy(vsbFmt, vsbTok, 20); /* snarf */
			vsbFmt[20-1] = chNull;	/* just to be safe */
		    } else if ((tk == tkSemi) OR (tk == tkNil)) {
			vsbFmt[0] = chNull;
		    } else {
			UError("Bad argument to the 'f' command.");
		    } /* if */
		    vcmdDef = cmdNil;
		    break;

	    case 'g':	/* 'goto' command (I'm SORRY!!!!!!!!) */
		    valInt = LongFExpr(seT, tkNil);
		    if (seT->asym.st == stNil) {
			UError("I need a linenumber.");
		    } /* if */
		    GotoIln(valInt);
		    break;

	    case 'H':   /* Halt - i.e. throw away rest of the command line */
		    SetCmd(sbNil);
		    if (v->fQuiet) {
			/* they don't know where they are - tell them */
			v->fQuiet = false;
			printf("\n%s\n", SbFSignal(v->sigOrig));
			ShowViewPosition(fmtFile+fmtProc+fmtLn+fmtLine+fmtEol);
		    } /* if */
		    break;

	    case 'h':	/* show history */
		    h_print();
		    break;

	    case 'i':	/* conditional command */
		    fDoit = LongFExpr(seT, tkNil);
		    if (seT->asym.st == stNil)
			fDoit = false;
		    tk = vtk;	/* look ahead by expression parser */
		    if (tk != tkLCB)
			UError("Missing {.");
		    if (!fDoit) {
			v->sbCmd = SbFEob(v->sbCmd); /* eat the first block */
			tk = TkNext();
			if (tk != tkLCB)
			    continue;	/* we ate first part of next command */
		    } /* if */
		    break;

	    case chLCB:	/* beginning of block. eat block. Mmmm, block good! */
		    v->sbCmd = SbFEob(v->sbCmd);
			/* returns ptr to matching RCB+1 */
		    break;

	    case chRCB:	/* end of block */
		    break;	/* we just throw it away */

	    case 'I':	/* information about cdb's state */
		    ShowState();
		    vcmdDef = cmdNil;
		    break;

	    case 'k':
		    if (v->pid == pidNil)
			UError("No process to kill.");
		    if (!YesNo("Really kill child? "))
			break;	/* their finger slipped or something */
		    KillChild();
		    printf("process killed\n");
		    vcmdDef = cmdNil;
		    break;

	    case 'l':
		    ListSomething();
		    break;

	    case 'L':
		    i = fmtFile+fmtProc+fmtLn+fmtLine+fmtEol;
		    if (v->fMachineStep)
			i += fmtInst;
		    SetViewPosition(v->acntx.pc); /* puts us at current break */
		    ShowViewPosition(i);
		    vcmdDef = cmdPrint;
		    break;

	    case 'M':	/* print|set map values */
		    DoMap();
		    vcmdDef = cmdNil;
		    break;

	    case 'N':	/* change size of source code display window */
		    TkNext();
		    i = atoi(vsbTok);
		    TkNext();
		    SetSrcWw(i, atoi(vsbTok));
		    MarkLine(v->iln);
		    UpLine(true);
		    break;

	    case 'P':	/* process management commands */
		    if ((viprMax == 1) AND ! vfAttach) {
			ListPr(prNil);
			break;
		    } /* if */

		    if (fHaveValue) {
			pr = PrFIpr(valInt);
			if (pr == prNil)
			    UError("No such process.");
			sbTemp = SbFAlloc(v->sbCmd);
			SetCmd(sbNil);	/* clear commands of outgoing */
			SetGlobalPr(pr);
			SetCmd(sbTemp); /* and use the saved commands */
			free(sbTemp);
		    } /* if */

		    tk = TkNext();
		    if (tk == tkNil && !fHaveValue) {
			ListPr(prNil);
		    } else {
			strcpy(sbBuf1, vsbTok);
			sb = sbBuf1;
			fFreedProcess = false;
			while (*sb) {
			    switch (*sb) {
				default:
				    printf("\
    Process management subcommands:\n\
       Example '1 P s 2' would make process 1 the active\n\
			 process and send it an interrupt\n\
    b	Toggle breakpoint inheritance after fork'ing\n\
    c	Toggle debug-my-Children flag\n\
    e	Toggle stop-after-Exec flag\n\
    f	Toggle stop-after-Fork flag\n\
    E	Add a new top level process by name\n\
    F	Free process to continue running\n\
    P	Add a new top level process by process id\n\
    s n	Send signal number n to process\n");
				    break;

				case 'b':
				    v->fRemoveBpsOnFork = !v->fRemoveBpsOnFork;
				    break;

				case 'c':
				    v->fDebugChildren = !v->fDebugChildren;
				    break;

				case 'e':
				    v->fStopOnExec = !v->fStopOnExec;
				    break;

				case 'f':
				    v->fStopOnFork = !v->fStopOnFork;
				    break;

				case 'E':
				    tk = TkNext();
				    if ((tk != tkStr) AND (tk != tkStrConstant))
					UError("I need a program name.");
				    pr = PrFInitPr(vsbTok);
				    SetGlobalPr(pr);
				    break;

				case 'F':
				    FreeProcess(v);
				    fFreedProcess = true;
				    break;

				case 'P':
				    tk = TkNext();
				    if (tk != tkNumber)
					UError("I need a process number.");
				    i = atoi(vsbTok);
				    if (vfAttach AND v != prNil) {
					if (Ptrace(ptMultiChild,i,0,0) == -1){
					    switch(errno) {
					    default:
						UError("Can not attach to process %d.",i);
					    case ESRCH:
						UError("Process %d does not exist.",i);
					    case EPERM:
						UError("You do not have permission to attach to process %d.",i);
					    }
					}
					v->pid = i;
					v->pidParent = pidNil;
					SendSignal(SIGINT);
					Waiter(wtProcess,v->pid);
				    } else {
				    	PrFAttachProcess(atoi(vsbTok));
				    }
				    break;

				case 's':
				    tk = TkNext();
				    if (tk != tkNumber)
					UError("I need a simple signal number.");
				    i = atoi(vsbTok);
				    SendSignal(i);
				    break;

			    } /* switch */
			    *sb++;
			} /* while */
			if (! v->fQuiet) {
			    if(fFreedProcess) {
				ListPr(prNil);
			    } else {
				ListPr(v);
			    } /* if */
			}
		    } /* if */
		    break;

	    case 'p':
		    if (fHaveValue) {
			i = valInt;
			if (i < 0)
			    v->iln += i;
			else
			    v->iln = i;
			v->iln = IlnFNormalize(v->ifd, v->iln);
			v->slop = 0;
		    } /* if */
		    cnt = LongFExpr(seT, tkNil);
		    if ((seT->asym.st == stNil) OR (cnt <= 0))
			cnt = 1;
		    if (vfWindows) {
			SetViewPosition(adrNil);
			ShowViewPosition(fmtFile+fmtProc+fmtLn+fmtLine+fmtEol);
		    } else {
			PrintLine(v->iln, cnt, true, stdout);
		    } /* if */
		    vcmdDef = cmdPrint;
		    break;

	    case 'q':
		    ch = ChFChoice("Quit? [nsy] ", "nsy");
		    if (ch == 'n') {
			break;
		    } if (ch == 's') {
			SaveAll();
		    } /* if */
		    CdbExit(0);
		    /* NOTREACHED */
		    break;

	    case 'Q':	/* quiet command, just eat it */
		    v->fQuiet = !v->fQuiet;
		    break;

	    case 'r':
	    case 'R':
		    v->fDoingSingle = false;
		    NewChild((chCmd == 'R') ? sbNil : v->sbCmd, false);
		    if (v->bp == bpNil)
			RunProcess(ptResume, psRunning, viprMax == 1);
		    vcmdDef = cmdNil;
		    break;

	    case 'S':
	    case 's':
		    i = (fHaveValue) ? valInt : 1;
		    fMachineStatement = false;
		    if (chNext == 'I') {
			fMachineStatement = true;
			chNext = 'i';
		    } /* if */

		    vcmdDef = (chCmd=='s') ?
			((chNext == 'i') ? cmdMachSingle : cmdLineSingle)
			: ((chNext == 'i') ? cmdMachProc : cmdLineProc);

		    while (i--) {
			if (fMachineStatement) {
			    do {
				SingleStep(vcmdDef, false);
				if ((v->pid == pidNil) /* child died/term'ed */
				   OR (v->bp != bpNil)) /* REAL breakpoint */
				    break;
			    } while (v->slop != 0);
			} else {
			    SingleStep(vcmdDef, false);
			} /* if */

			if ((v->pid == pidNil) /* child died/terminated */
			   OR (v->bp != bpNil)) /* REAL breakpoint */
			    break;
		    } /* while */
		    break;

	    case 'T':
	    case 't':
		    i = (fHaveValue) ? valInt : 20; /* default to 20 deep */
		    TkPeek();
		    StackTrace(i, (chCmd=='T')); /* do locals, too, on T */
		    vcmdDef = cmdNil;
		    break;

	    case 'v':
		    EditFile(v->ifd, v->iln);
		    break;

	    case 'W':
		    cnt = 21;
	    case 'w':
		    if (fHaveValue)
			v->iln = IlnFNormalize(v->ifd, valInt);
		    v->slop = 0;
		    ilnSave = v->iln;
		    if (cnt == 1)
			cnt = 11;	/* i.e. - we didn't come through W */
		    i = LongFExpr(seT, tkNil);
		    if ((seT->asym.st != stNil) AND (i >= 1))
			cnt = i;
		    iln = Max(v->iln-cnt/2, 1);
		    cLn = Min(cnt/2, v->iln-iln);
		    if (vfWindows) {
			CenterWw(v->iln);
			MarkLine(v->iln);
			UpLine(true);
		    } else {
			PrintLine(iln, cLn, true, stdout);
			/* shows them which line they are on */
			if (vfpWwSrc != NULL)
			    fprintf(vfpWwSrc, ">");
			else
			    printf(">");
			v->iln++;
			cLn = Min(cnt-cLn, v->rgFd[v->ifd].ilnMac-v->iln+1);
			PrintLine(v->iln, cLn, true, stdout);
		    } /* if */
		    v->iln = ilnSave;
		    vcmdDef = cmdPrint;
		    break;

	    case 'x':	/* clear command line and exit current level */
		    if ((!fHaveValue) OR (valInt == 0))
			SetCmd(sbNil);
		    return(true);

	    case 'Y':	/* commands used for demo's */
		    switch (chNext) {
			case '\0':
			    /* this line is a comment */
			    if (vfComment) {
				if (*v->sbCmd != chNull) {
				    Highlight(true);
				    printf("%s%s\n", vsbOffset, v->sbCmd+1);
				    Highlight(false);
				} else {
				    printf("\n");
				} /* if */
			    } /* if */
			    SetCmd(sbNil);
			    break;

			case 'c':
			    /* a "no pause" command */
			    if (tkNil == TkPeek())
				SetCmd("\n");;	/* stuff a <cr> in there */
			    printf("%s%s\n", "cdb >", v->sbCmd);
			    break;

			case 'h':
			    /* set the comment highlight ON and OFF value */
			    SetCmd(sbNil);
			    break;

			case 'o':
			    /* set the comment offset to the given string */
			    strcpy(vsbOffset, v->sbCmd+1);
			    SetCmd(sbNil);
			    break;

			case 'p':
			    /* pause for the given number of seconds */
			    i = LongFExpr(seT, tkNil) - vsleepDemo;
			    if (i > 0)
				sleep(i);
			    break;

			case 'q':
			    CdbExit(0);
			    break;

			case 's':
			    /* Change the sleep time.
			     * We allow this only if it was already in effect.
			     */
			    if (vsleepDemo != 0)
				vsleepDemo = LongFExpr(seT, tkNil);
			    break;
		    } /* switch */
		    break;

	    case 'z':	/* 'zignals' processing */
		    sig = (fHaveValue) ? valInt : v->sigOrig;
		    TkNext();
		    strcpy(sbBuf1, vsbTok);
		    sbBp = EatCmdList(&cnt);
		    if (sbBp == sbNil)
			sbBuf2[0] = 0;
		    else
			strncpy(sbBuf2, sbBp, cnt);
		    sbBuf2[cnt] = chNull;
		    SaMaintain(sig, sbBuf1, sbBuf2);
		    break;

	    case 'Z':	/* toggle case sensitivity */
		    vfIgnoreCase = !vfIgnoreCase;
		    vcaseMod = (vcaseMod) ? 0 : 040;
		    printf("Searches will %sbe case sensitive\n",
			(vcaseMod!=0) ? "NOT " : "");
		    vcmdDef = cmdNil;
		    break;
	} /* switch */

	if ((vtk != tkSemi) AND (chCmd != 'i')) {
	    while ((tk = TkNext()) != tkSemi)
		if (tk == tkNil)
		    return(fTop);
	} /* if */
    } while ((tk = TkNext()) != tkNil);
    
    return(fTop);
} /* FDoCommand */
