/* $Header: cmdline.c,v 5.14 86/06/05 09:11:40 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

/* This file contains the routines that read the commnad line from the TTY and
 * maintain the record & playback files.
 * TkNext(), in tk.c, the tokenizer, is what most routines call to actually get
 * something from the current command line.
 */

#include "cdb.h"

extern char *gets();

export FILE	*vfpOutput, *vfpRecord, *vfpPlayback;
char	vsbRecord[50], vsbOutput[50];
export int4	vcStepPlayback, vsleepDemo;
export FLAGT	vfComment, vfOutput, vfRecord, vfEofSeen = false;;
export SBT 	vsbGet;	/* points to buffer for Waiter tty input */

#define chEOF 04	/* a ^D */
#define cbSbCmd 200	/* max command length */
#define cbSbQuery 20	/* max query (Yes/No) length */


/* N E X T   C M D */

export void NextCmd(sbBuffer, cbBuffer, sbPrompt)
SBT	sbBuffer, sbPrompt;
int2	cbBuffer;
{
    FLAGT	fDoit, fPrompt = true;
    SBT		sbCmd, sbTemp;
    char	sbQuery[cbSbQuery];

    while (vfpPlayback != NULL) {

	sbBuffer[0] = chNull;
	sbCmd = fgets(sbBuffer, cbBuffer, vfpPlayback);

	if (sbCmd == sbNil) {
EndOfFile:
	    /* end-of-file for playback */
	    fclose(vfpPlayback);
	    vfpPlayback = NULL;
	    vcStepPlayback = 1;
	    break; /* which will put us into the TTY code */
	} /* if */

	if ((sbTemp = strrchr(sbCmd, '\n')) != NULL)
	    *sbTemp = chNull;	/* step on new-line */

	if (*sbCmd == '~') {
	    /* Make the command prettier than a '~' */
	    sbCmd++;
	    /* *sbCmd = ' '; */
	} /* if */

	if ((vcStepPlayback == 0)
	   OR (--vcStepPlayback > 0)) {
	    if ((*sbCmd != 'Y') OR (!vfComment))
		printf("%s%s\n", sbPrompt, sbCmd);
	} else {	/* we are doing playback stepping */
	    if (vfComment == true) {
		if (*sbCmd == 'Y') {
		    vcStepPlayback = 1;
		    return;
		} /* if */
		printf("%s%s", sbPrompt, sbCmd);
		if (vsleepDemo == 0) {
		    printf("	[HIT <CR> TO CONTINUE] ");
		} else {
		    printf("\n");
		    if (FTimedInput(vsleepDemo)) {
			/* timed out */
			vcStepPlayback = 1;
			return;
		    } /* if */
		    /* they want to take control, kill future timing
		     * and fall through to normal input code.
		     */
		    SetDemoTimer(0);
		    printf("	[HIT <CR> TO CONTINUE] ");
		} /* if */
	    } else {
		printf("%s%s  (<cr>, <#>, C, Q, S or ?): ", sbPrompt, sbCmd);
	    } /* if */

	    fDoit = false;
	    while (!fDoit) {
		gets(sbQuery);
		fDoit = true;
		switch (*sbQuery) {
		    default:	fDoit = false;
				break;

		    case 'Q':   goto EndOfFile;
				break;

		    case 'S':   vcStepPlayback = 1;
				goto ContinueMainLoop;
				break;

		    case 'C':   vcStepPlayback = 0;
				break;

		    case chNull:
				vcStepPlayback = 1;
				break;

		    case '?':
	    printf("<cr> executes THIS command line,\n");
	    printf("<#> does that number of command lines,\n");
	    printf("S skips this command,\n");
	    printf("Q quits playback mode,\n");
	    printf("C continues until the end of ALL playback files.\n");
	    printf("%s%s  (<cr>, <#>, C, Q, S or ?): ", sbPrompt, sbCmd);
				fDoit = false;
				break;

		    case '0': case '1': case '2': case '3':
		    case '4': case '5': case '6': case '7':
		    case '8': case '9':
				vcStepPlayback = atoi(sbQuery);
				break;

		} /* switch */
	    } /* while */
	} /* if */

	return;
ContinueMainLoop: ;
    } /* while */

    /* there is no playback file, read from terminal */
    v->fQuiet = false;	/* since we need TTY input, we get noisy */
    if (fPrompt)
	printf("%s", sbPrompt);
    vsbGet = sbBuffer;
    sbBuffer[0] = 0;

    Waiter(wtTty, 0);

    sbCmd = vsbGet;

    if (sbCmd == sbNil) {
	sbBuffer[0] = chNull;
    } else if (*sbCmd == '%') {
	h_modify(sbCmd);
    } else if (*sbCmd == '#') {
	h_set(sbCmd);
    } else if (*sbCmd == chNull) {
	sbCmd[0] = '~';
	sbCmd[1] = chNull;
    } /* if */
} /* NextCmd */


/* D E B U G   I T */

export void DebugIt(fTopLevel)
FLAGT	fTopLevel;
{
    int		i, cnt;
    FLAGT	fRet;
#define cbCmdMax	200
    char	sbCmd[cbCmdMax];

    if (fTopLevel)
	SetPrompt("%s >", vsbDebugName);
    else
	SetPrompt("%s >>", vsbDebugName);

    fRet = true;
    while (fRet) {
	cnt = 1;
	vcNest = 0; 	/* nesting level for printing structure indents */
	NextCmd(sbCmd, cbCmdMax, vsbPrompt);
	if (*sbCmd == chNull) {
	    printf("   "); /* clear away the ^D */
	    cnt = strlen(vsbPrompt) + 3;
	    while (cnt--)
		printf("\010");  /* backspace over prompt */
	    cnt = 10;
	    sbCmd[0] = '~';
	    sbCmd[1] = chNull;
	    vfEofSeen = true;
#if (OP_SYS == BSD42)
	/* These turkeys don't know the meaning of the word compatibility! */
	    clearerr(stdin);
#endif
	} /* if */

	for (i=0; (i < cnt) AND fRet; i++) {
	    RecordCmd(sbCmd);
	    fRet = FDoCommand(sbCmd, fTopLevel);
	} /* for */
	vfEofSeen = false;
    } /* while */
    SetPrompt("%s >", vsbDebugName);
} /* DebugIt */


/* R E C O R D	 C M D */

export void RecordCmd(sbCmd)
SBT	sbCmd;
{
    h_insert(sbCmd);	/* it's history, now */

    if ((*sbCmd != '>') AND (*sbCmd != '<')) {
	if (vfRecord AND (vfpRecord != NULL))
	    fprintf(vfpRecord, "%s\n", sbCmd);	/* make a recording */
	if (vfOutput AND (vfpOutput != NULL))
	    fprintf(vfpOutput, "%s\n", sbCmd);	/* make a recording */
    } /* if */
} /* RecordCmd */


/* Y E S   N O */

export int YesNo(sbPrompt)
SBT	sbPrompt;
{
    char	sbAnswer[cbSbQuery];

    NextCmd(sbAnswer, cbSbQuery, sbPrompt);
    RecordCmd(sbAnswer);
    return(sbAnswer[0] == 'y' OR sbAnswer[0] == 'Y');
} /* YesNo */


/* C H   F   C H O I C E */

export char ChFChoice(sbPrompt, sbChoice)
SBT	sbPrompt, sbChoice;
{
    char	*sbTemp, sbResponse[cbSbQuery];

    sbTemp = sbNil;
    while (sbTemp == sbNil) {
	NextCmd(sbResponse, cbSbQuery, sbPrompt);
	RecordCmd(sbResponse);
	if ((sbChoice[0] != ' ') AND (sbResponse[0] == '~'))
	    return(sbChoice[0]);	/* give them default */
	sbTemp = strchr(sbChoice, sbResponse[0]);
    } /* while */
    return(*sbTemp);
} /* ChFhoice */


/* S E T   P L A Y B A C K */

export void SetPlayback(sbPlayback, fQuiet, fSinglestep)
SBT	sbPlayback;
FLAGT	fQuiet, fSinglestep;
{
    FILE	*fpTemp;

    if (vfpPlayback != NULL)
	fclose(vfpPlayback);
    if ((sbPlayback == sbNil) OR (*sbPlayback == chNull))
	UError("No playback name specified.");
    if ((fpTemp = fopen(sbPlayback, "r")) == NULL)
	UError("Can't open %s as playback file: %s.", sbPlayback,
			SbFError(errno));
    if (!fQuiet)
	printf("Playing back from %s\n", sbPlayback);
    vfpPlayback = fpTemp;
    vcStepPlayback = (fSinglestep) ? 1 : 0;
} /* SetPlayback */


/* S E T   O U T P U T */

export void SetOutput(sbOutput)
SBT	sbOutput;
{
    FILE	*fpTemp;

    if (vfpOutput != NULL) {
	if (!v->fQuiet)
	    printf("Closing output file\n");
	fclose(vfpOutput);
	vfOutput = false;
	vfpOutput = NULL;
    } /* if */
    if ((sbOutput == sbNil) OR (*sbOutput == chNull))
	return;
    if ((fpTemp = fopen(sbOutput, "w")) == NULL)
	UError("Can't open %s as output file.", sbOutput);
    strncpy(vsbOutput, sbOutput, 49);
    vfOutput = true;
    vfpOutput = fpTemp;
} /* SetOutput */


/* S E T   R E C O R D */

export void SetRecord(sbRecord)
SBT	sbRecord;
{
    FILE	*fpTemp;

    if (vfpRecord != NULL) {
	if (!v->fQuiet)
	    printf("Closing record file\n");
	fclose(vfpRecord);
	vfRecord = false;
	vfpRecord = NULL;
    } /* if */
    if ((sbRecord == sbNil) OR (*sbRecord == chNull))
	return;
    if ((fpTemp = fopen(sbRecord, "w")) == NULL)
	UError("Can't open %s as record file.", sbRecord);
    strncpy(vsbRecord, sbRecord, 49);
    vfRecord = true;
    vfpRecord = fpTemp;
} /* SetRecord */


/* S T A T E   R E C O R D */

export void StateRecord()
{
    if (vfpOutput != NULL)
	printf("Sending OUTPUT to \"%s\".\n", vsbOutput);
    if (vfpRecord != NULL) {
	printf("Sending COMMANDS to \"%s\".\n", vsbRecord);
    }
    printf("Output recording is %s.\n", (vfOutput) ? "ON" : "OFF");
    printf("Command recording is %s.\n", (vfRecord) ? "ON" : "OFF");
} /* StateRecord */


/* S H O W   S T A T E */

export void ShowState()
{
    printf("Debugging %s, %d files %d procedures.\n",
		v->sbExec, v->hdr.ifdMax, v->hdr.ipdMax);
    if (v->fnCore != fnNil)
	printf("Core file is %s.\n", v->sbCore);
     else
	printf("No core file.\n");
    if (v->pid != pidNil)
	printf("There is an active child process, #%d.\n", v->pid);
     else
	printf("No active child process.\n");
    if (v->iadMac == 0)
	printf("No assertions.\n");
     else if (v->as == asSuspended)
	printf("Assertions are suspended.\n");
     else
	printf("%d assertions are active.\n", v->iadMac);
    StateRecord(vfRecord);
    printf("Searches are %scase sensitive.\n",
	(vcaseMod!=0) ? "NOT " : "");
} /* ShowState */


/* P L A Y B A C K   F I L E */

export void PlaybackFile(sbFile)
SBT	sbFile;
{
    char	*sbTemp, *sbTemp2, sbCmd[200];
    FILE	*fp;

    /* This routine is called when you have a file that you
     * want to playback with no prompts, no commands printed,
     * and no user interaction.
     */

    if ((fp = fopen(sbFile, "r")) == NULL)
	return;

    while (true) {
	sbCmd[0] = chNull;
	sbTemp = fgets(sbCmd, 200, fp);
	if (sbTemp == sbNil) {
	    fclose(fp);
	    return;
	} /* if */

	if ((sbTemp2 = strrchr(sbCmd, '\n')) != NULL)
	    *sbTemp2 = chNull;	/* step on new-line */

	if (*sbTemp == '~')
	    *sbCmd = ' ';

	RecordCmd(sbCmd);
	FDoCommand(sbCmd, true);
    } /* while */
} /* PlaybackFile */
