BEGIN	{
	    RCS = "$Header: config.awk,v 6.2 86/09/15 09:32:24 peter Exp $";
	    list = "abcdefghijklmnopqrstuvwxyz";
	    if (FS != " ") {
		isysSelect = index(list, FS);
		if (isysSelect == 0)
		    exit(1);
		fGotit = 0;
	    } else {
		fGotit = 1;
		isysSelect = 0;
	    }
	    fIndirect = 0;
	    FS = " ";
	    isysCur = 0;
	}

/^LOOKFOR/	{
	    if (isysSelect == isysCur)
		sbMore = substr($0, 8);
	    next;
	}

/^FIND/	{
	    if (sbMore == substr($0, 5)) {
		isysSelect = isysCur;
		sbMore = "";
		next;
	    }

	}

/^@/	{
	    ++isysCur;
	    if (isysSelect == 0) {
		printf "\t%s\t%s\n", substr(list, isysCur, 1), substr($0, 2);
	    } else if (isysSelect == isysCur) {
		fGotit = 1;
		printf "SYSNAME = %s\n", substr($0, 2) >> "SYS.make";
		print "/* This file is automatically created by config */" > "SYS.h"
		printf "#define SYS_NAME \"%s\"\n", substr($0, 2) >> "SYS.h";
	    }
	    next;
	}

/^#define/ {
	    if (isysSelect == isysCur) {
		print $0 >> "SYS.h"
	    }
	    next;
	}

/^\$/	{   next; }
/^$/	{   next; }
/^-/	{   next; }

	{
	    if (isysSelect == isysCur) {
		print $0 >> "SYS.make"
	    }
	    next;
	}

END	{
	    if (fGotit == 0) {
	      printf "There is no system '%s'.\n", substr(list, isysSelect, 1);
	    }
	}
