/* $Header: config.h,v 6.5 86/09/15 09:32:10 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

#include "SYS.h"

/* SYS names */
#define ONYXIII	1
#define VAX41	2
#define VAX41c	3
#define VAX42	4
#define REG68	5
#define SUN42	6
#define SUNGH42	7
#define NSC32V	8
#define VAX41S42 9
#define ELXSI64	10
#define MEGA42	11
#define AR68V	12
#define ISI42	13
#define P60V	14
#define VAXV	15
#define CTVMega	16
#define CTVMini	17
#define CCI42	18
#define ATT3B2	19
#define CPC19V	20
#define PY9X42	21
#define SYM3242	22
#define	OPUS32V	23
#define	INTER32V	24
#define	HS550	25
#define	MX32V	26
#define IN386V	27

/* CPU definitions */
#define Z8000	1
#define VAX	2
#define M68000	3
#define N32000	4
#define I8086	5
#define CCI632	6
#define A3B2	7
#define PY9X	8
#define I80386	9

/* Operating system definitions */
#define SYSIII	1
#define BSD41	2
#define BSD41c	3
#define BSD42	4
#define V7	5
#define REGULUS	6
#define MSDOS	7
#define SYSV	8

#define O_S OP_SYS

/* Manufacturer definitions */
#define ONYX	1
#define DEC	2
#define IBM	3
#define ALCYON	4
#define SUN	5
#define PLEXUS	6
#define MEGA	7
#define ARETE	8
#define ISI	9
#define CT	10
#define CCI	11
#define ATT	12
#define CPC	13
#define XYZ	14
#define ELXSI	15
#define PYRAMID	16
#define GOULD	17
#define INTEL	18
#define NSC	19
#define MOTOROLA	20
#define SYMMETRIC	21
#define OPUS	22
#define SIEMENS	23
#define FAIRCHILD	24
#define INTERGRAPH	25
#define ENCORE	26

/* Compiler definitions */
#define GH68	1

#ifdef HOST_CPU
    /* This allows the host CPU code to compile differently */
#undef CPU
#define CPU HOST_CPU
#endif

/* CPU defaults */
#if (CPU == M68000)

#ifndef BPT_INST
#define BPT_INST	0x4e410000	/* trap 1 */
#endif

#define CB_BP		2
#define ALIGNMENT_MASK	1
#define BYTE_SEX	byteSexBig
#define BIT_SEX		bitSexBig
#define FPISAP		1
#endif /* (CPU == M68000) */

#if (CPU == VAX)
#define BPT_INST	03
#define CB_BP		1
#define ADR_PROC_BASE	2
#define ALIGNMENT_MASK	0
#define BYTE_SEX	byteSexLittle
#define BIT_SEX		bitSexLittle
#define CALLE_STACK_CLEANUP	1
#endif /* (CPU == VAX) */

#if (CPU == I80386)
#define ALIGNMENT_MASK	0
#define BYTE_SEX	byteSexLittle
#define BIT_SEX		bitSexLittle
#define FPISAP		1
#define	DADR_ENTMAX	4
#define BPT_INST 	0xcc
#define CB_BP		1
#endif /* (CPU == I80386) */

#if (CPU == N32000)
#define ALIGNMENT_MASK	0
#define BYTE_SEX	byteSexLittle
#define BIT_SEX		bitSexLittle
#define FPISAP		1
#define INST_SYSCALL	0xe2
#define	DADR_ENTMAX	4
#define BPT_INST 	0xf2
#define CB_BP		1
#define CLEAR_FP	0
#endif /* (CPU == N32000) */

#if (CPU == CCI632)
#define CB_BP	1		/* size of a breakpoint */
#define BPT_INST	0x30000000	/* a breakpoint instruction */
#define ALIGNMENT_MASK	3
#define BYTE_SEX	byteSexBig
#define BIT_SEX		bitSexBig
#define NO_STACK_CLEANUP	1
#endif /* (CPU == CCI632) */

#if (CPU == A3B2)
#define BPT_INST	0x2e000000	/* a BPT instruction */
#define CB_BP		1
#define ALIGNMENT_MASK	3
#define BYTE_SEX	byteSexBig
#define BIT_SEX		bitSexBig
#define FPISAP		1
#endif /* (CPU == A3B2) */

#if (CPU == PY9X)
#define CB_BP	4		/* size of a breakpoint */
#define BPT_INST	0xf0000000	/* a BPT instruction */
#define ALIGNMENT_MASK	3
#define BYTE_SEX	byteSexBig
#define BIT_SEX		bitSexBig
#define FPISAP		1
#define NO_STACK_CLEANUP	1
#endif /* (CPU == PY9X) */

#if (CPU == PDN)
#define CB_BP	2		/* size of a breakpoint */
#define BPT_INST	0xf0000000	/* a BPT instruction */
#define ALIGNMENT_MASK	1
#define BYTE_SEX	byteSexBig
#define BIT_SEX		bitSexBig
#define FPISAP		1
#endif /* (CPU == PDN) */

/* the following give us the default values */

#define ANY_BSD ( (O_S == BSD41) || (O_S == BSD41c) || (O_S == BSD42) )

#ifndef REMOTE_OS
#define REMOTE_OS O_S
#endif

#ifndef HOST_CPU
#define HOST_CPU CPU
#endif

#ifndef CALLEE_STACK_CLEANUP
#define CALLEE_STACK_CLEANUP	0
#endif

#ifndef FPISAP
#define FPISAP		0
#endif

#ifndef BPT_BACKUP
#define BPT_BACKUP	0
#endif

#ifndef REGT
#define REGT unsigned int
#endif

#ifndef ADR_USER
/* address of struct user in kernel address space */
#define ADR_USER adrNil
#endif

#ifndef ADR_REG0
#define ADR_REG0 adrNil
#endif

#ifndef ADR_U_AR0
#define ADR_U_AR0 adrNil
#endif

#ifndef cbStorageMax
#define cbStorageMax	(0x7ffff000L)
#endif

#ifndef INTEGER_OFFSETS
/* A big-endian machine (e.g. 68000) with parameters on integer boundaires */
#define INTEGER_OFFSETS	0
#endif

#ifndef ADR_PROC_BASE
#define ADR_PROC_BASE 0
#endif

#ifndef CLEAR_FP
#define CLEAR_FP	1
#endif

#ifndef ADR_TEXT_BASE
#define ADR_TEXT_BASE	0L
#endif

#ifndef cbCodeOffset
#define cbCodeOffset	1024
#endif

#ifndef ADR_CALL
#define ADR_CALL	adrNil
#define ADR_BREAK	adrNil
#endif

#ifndef PID_FIRST_USER
#define PID_FIRST_USER	3
#endif

#ifndef STRUCT_RETURN_OFFSET
#define STRUCT_RETURN_OFFSET	0
#endif

#ifndef NO_UNDERSCORES
#define NO_UNDERSCORES	0
#endif

#ifndef PERCENT_SIGNS
#define PERCENT_SIGNS 0
#endif

#ifndef upc
#define 	usp	16
#define 	upc	17
#define 	ufp	18
#define 	upsw	19
#define		uap	20
#endif

#ifndef CHECK_REG_PARAMS
#define CHECK_REG_PARAMS	0
#else
#undef ALSO_EQUAL
#define ALSO_EQUAL	1
#endif

#ifndef ALSO_EQUAL
#define ALSO_EQUAL	0
#endif

