/* $Header: cpu68.c,v 6.3 86/09/01 17:20:42 peter Exp $ */

/* This program is an unpublished work fully protected by the
 * United States Copyright Laws and is considered a TRADE SECRET
 * belonging to Third Eye Software, Inc.
 */

/* ******************************************************* */
/*							   */
/* This is the Motorola 68000 (and 68010 and 68020) module */
/*							   */
/* ******************************************************* */

#if 0
exportdefine X_InitRegisters	1
exportdefine X_ListRegisters	1
#endif

#include "cdb.h"

#include <errno.h>
#include <sys/param.h>

#if (OP_SYS == SYSV)
#include <signal.h>
#include <sys/types.h>
#endif

#include <sys/dir.h>
#include <sys/user.h>

#if ((OP_SYS == BSD42) || (OP_SYS == BSD41c))
#include <machine/reg.h>
#else
#include <sys/reg.h>
#endif


CPUR	vacpu68;	/* where we put 68000 relative info */
ADRT	vadrRegBase;	/* used in GetMask/DoReg */

#if (HOST_CPU == M68000)
/* these are 'export'ed in main.c */
pCPUR	vcpuHost = &vacpu68;
#endif

#if (SYS == P60V)
#define R8	AR0
#define R9	AR1
#define R10	AR2
#define R11	AR3
#define R12	AR4
#define R13	AR5
#define R14	AR6
#define SP	USP
#define R15	SP
#undef PS
#define PS	SR
#endif /* (SYS == P60V) */

#if (SYS == AR68V)
#define R0	D0
#define R1	D1
#define R2	D2
#define R3	D3
#define R4	D4
#define R5	D5
#define R6	D6
#define R7	D7
#define R8	A0
#define R9	A1
#define R10	A2
#define R11	A3
#define R12	A4
#define R13	A5
#define R14	A6
#define R15	A7
#define PS	SR
#endif

#if (SYS == SUN42)
#define R8	AR0
#define R9	AR1
#define R10	AR2
#define R11	AR3
#define R12	AR4
#define R13	AR5
#define R14	AR6
#define R15	AR7
#endif

#ifndef FP
#define FP	R14
#endif /* FP */

export int2 vrgOffset[] = {
	R0,  R1,  R2,  R3,
	R4,  R5,  R6,  R7,
	R8,  R9,  R10, R11,
	R12, R13, R14, R15,
	SP,  PC,  FP,  PS,
	FP
	};

#define	IntFSb(sb) ((int)sb)

export SER vrgReg[40];		/* array of register variables */
export int viregMax;


/* A D R   F   S T A C K   F I X */

export ADRT AdrFStackFix(adr)
ADRT	adr;
{
    int2	inst;

    /* given an address immediately after a procedure call, step over any
     * stack fix-up instructions.
     */

#define TST_INST	0x4a5f
#define TSTL_INST	0x4a9f
#define CMPML_INST	0xbf8f
#define ADDW_INST	0xdefc
#define ADDQ_INST	0x500f
#define ADDN_INST	0x504f

    GetBlock(adr, spaceText, (ADRT)&inst, 2);
    if ( (inst == TST_INST)
       OR (inst == TSTL_INST)
       OR (inst == CMPML_INST)
       OR ((inst & 0xf13f)  == ADDQ_INST))
	adr += 2;
    else if ((inst & 0xf1ff) == ADDN_INST)
	adr += 4;
    return(adr);
} /* AdrFStackFix */


/* A D R   F   P R E A M B L E */

export ADRT AdrFPreamble(adr)
ADRT	adr;
{
    /* given the first address in a procedure, return the address of the
     * first `real' instruction - ie. after the csav0 or the brb whatever
     */

    int		op, ipd, iln;

#   define BRA		0x60
#   define LINK		0x4e

    /* First we try it based on opening brackets */
    ipd = IpdFAdr(adr);
    if (v->rgPd[ipd].iline != 0)
	return(AdrFirstFIpd(ipd));

    /* then we do it based on skipping over branch */
    op = GetByte(adr, spaceText);	/* get instruction */
    if (op == BRA) {
	adr++;
	op = GetByte(adr, spaceText);
	adr++;
	if (op == 0)
	    adr += 2;	/* it's a long branch */
    } else if (op == LINK) {
	adr += 4;
    } /* if */

    return(adr);
} /* AdrFPreamble */


/* F   A T   C A L L */

export FLAGT FAtCall(adr)
ADRT	adr;
{
#define JSR_INST	0x4e80
#define BSR_INST	0x6100
#define cbInsMax	2

    int2	inst = 0;
    /* return true or false based on whether the instruction at adr
     * is a procedure call of any kind.
     */

    GetBlock(adr, spaceText, (ADRT)&inst, cbInsMax);
    v->fAtSyscall = ((inst & 0xffff) == v->os->instSyscall);
    return(((inst & 0xff00) == BSR_INST) OR ((inst & 0xffc0) == JSR_INST));
} /* FAtCall */


/* R E T   F   S P */

export ADRT RetFSp(sp)
ADRT	sp;
{
    ADRT	adr;
    /* given the stack pointer immediately after a procedure call,
     * return the return address
     */
    GetBlock(sp, spaceData, (ADRT)&adr, v->cpu->cbPointer);
    return(adr); /* get return */
} /* RetFSp */



/* N E X T   I N S T   A D R   F   A D R */

local ADRT NextInstAdrFAdr(adr)
ADRT adr;
{
    vfOutputSuppress = true;
    PrintInstruction(adr);
    vfOutputSuppress = false;
    return(adr + vcbInst);
} /* NextInstAdrFAdr */


/* A D R   R E G   F   C N T X */

local ADRT AdrRegFCntx(cntx, reg)
pCNTXR cntx;
ADRT reg;
{
    ADRT	fp, pc;
    FAST ADRT	adr;
    ADRT	adrRet;
    ADRT	adrNext;
    ADRT	adrBase;
    pPDR	pd;
    uint1	op;
    int2	offset;
    uint4	mask;
    uint2	maskImage;
    uint4	maskSave, maskTest;
    int4	longOffset;
    int		inc, i, c;

#   define cInstMax	15

#   define MOVL		0x2e
#   define MOVEML	0x48
#   define MISC		0x4e
#   define LINK		0x4e
#   define LINK20	0x48
#   define BRA		0x60
#   define TST		0x4a

#   define maskReverse	0x10000000

    pc = cntx->pc;
    fp = cntx->fp;

    pd = v->rgPd + IpdFAdr(pc);
    if (pd->dadrRegBase == adrNil) {
	adr = pd->adr;	/* get start of this proc */

	/*
	 * Step throught the code looking for a link instruction.
	 * Some procedures will not have a link instruction.
	 */

	adrNext = adr;
	adrBase = adrNil;
	for(c = 0; c < cInstMax; ++c) {
	    adr = adrNext;
	    adrNext = NextInstAdrFAdr(adr);
	    op = GetByte(adr, spaceText);	/* get instruction */

	    if(op == BRA) {
		/*
		 * handle the normal case where the preamble code is
		 * generated at the end of the procedure so the first
		 * instruction is a branch/jump to the end
		 */
		adr++;
		op = GetByte(adr, spaceText);
		adr++;
		if (op == 0) {
		    GetBlock(adr, spaceText, (ADRT)&offset, 2);
		    adr += offset;
/* (CPU == M68020) */
		} else if (op == 0xff) {
		    GetBlock(adr, spaceText, (ADRT)&longOffset, 4);
		    adr += longOffset;
/* (CPU == M68020) */
		} else {
		    adr += op;
		} /* if */
		adrNext = adr;
		continue;
	    } /* if */

#if (MFG == SUN)
             if (op == 0xdf) {
                adr++;
                op = GetByte(adr, spaceText);
                adr++;
                if(op == 0xfc) {
                    GetBlock(adr, spaceText, (ADRT)&longOffset, 4);
                    pd->dadrRegBase += longOffset;
                }
            }
#endif /* (MFG == SUN) */

#if (MFG == ISI)
	    if (op == MOVL) {
		adr++;
		op = GetByte(adr, spaceText);
		if(op == 0x87) {
		    mask = 0x0080;
		    break;
		}
		if(op == 0x8d) {
		    mask = 0x2000;
		    break;
		}
	    }
#endif

	    if (op == MISC) {	/* also is JMP */
		adr++;
		op = GetByte(adr, spaceText);
		adr++;
		/*
		 * if we hit a trap instruction or a
		 * return instruction we are done
		 */
		if((op & 0xf0) == 0x70 || (op & 0xf0) == 0x40) {
		    pd->dadrRegBase = 0;
		    pd->maskReg = 0;
		    return(adrNil);
		} /* if */

		/*
		 * if we hit a jmp, follow it if the target is (pc)
		 */
		if((op & 0xfe) == 0xf8) {
		    if(op & 0x01) {
			GetBlock(adr, spaceText, (ADRT)&offset, 2);
			adrNext = offset;
		    } else {
			GetBlock(adr, spaceText, (ADRT)&longOffset, 4);
			adrNext = longOffset;
		    }
		    continue;
		}

		/*
		 *	check for short link instruction
		 */
		if((op & 0xf8) == 0x50) {
		    GetBlock(adr, spaceText, (ADRT)&offset, 2);
		    adrBase = offset;
		    pd->dadrRegBase = adrBase;
		    continue;
		} /* if */
	    } /* if */

	    if (op == MOVEML) {
		adr++;
		op = GetByte(adr, spaceText);
		adr++;

/* (CPU == M68020) */
		/* check for 68020 32 bit link instruction */
		if ((op & 0xf8) == 0x08) {
		    GetBlock(adr, spaceText, (ADRT)&longOffset, 4);
		    adrBase = longOffset;
		    pd->dadrRegBase = adrBase;
		    continue;
		} /* if */
/* (CPU == M68020) */

		if (op & 0x80) {
		    GetBlock(adr, spaceText, (ADRT)&maskImage, 2);
		    adr += 2;
		    mask = maskImage;
		    if((op & 0x38) == 0x20) {
			mask |= maskReverse;
		    }
		    pd->maskReg = mask;
		    /* modify dadrRegBase if an offset is specified */
		    if(op == 0xef) {
			GetBlock(adr, spaceText, (ADRT)&offset, 2);
			pd->dadrRegBase += offset;
		    }
		    else if(op == 0xee) {
			GetBlock(adr, spaceText, (ADRT)&offset, 2);
			pd->dadrRegBase = offset;
			break;
		    }
		    break;
		} /* if */
	    } /* if */
	} /* for */
    } /* if */

    mask = pd->maskReg;
    vadrRegBase = fp + pd->dadrRegBase;
    maskSave = mask & 0x0000ffff;	/* only lower 16 bits are used */
    if (mask & maskReverse) {
	reg = 15 - reg;
	inc = - v->cpu->cbRegister;
    } else {
	inc = v->cpu->cbRegister;
    } /* if */

    maskTest = 1 << reg;
    adrRet = adrNil;

    if (maskSave & maskTest) {
	/* it has a saved copy of this register */
	adrRet = vadrRegBase;	/* set to base of saved registers */
	if (mask & maskReverse)
	    adrRet += inc;

	for (i = 0; i < reg; i++) {
	    if (maskSave & 1)
		adrRet += inc;	/* a saved reg takes up space */
	    maskSave >>= 1;
	} /* for */
    } /* if */

    return(adrRet);
} /* AdrRegFCntx */

/*  D O   R E G */

export void DoReg(seReg, cntx)
pSER	seReg;
pCNTXR	cntx;
{
    int		inc, maskSave, maskTest, i;
    ADRT	adrRet, reg, adr;
    CNTXR	acntx;

    /* Given a desired fp and the register, we walk back up the stack,
     * looking for frames that may have saved this register.  If we find
     * one, we figure out the memory address of the saved register and
     * continue.  Only when we reach our desired frame, after (perhaps)
     * seeing this register get saved N times, do we actually know for sure
     * where the %@#%$# thing is!
     */

    reg = seReg->asym.value;
    adrRet = reg;	/* by default we assume it is still in the reg */

    for (acntx = v->acntx; acntx.fp != cntx->fp; NextFrame(&acntx)) {
	if (acntx.fp == 0)
	    Panic("Clobbered stack(?)");

	/* find out the address this register is stored at in this frame */

	if((adr = AdrRegFCntx(&acntx, reg)) != adrNil) {
		seReg->asym.sc = scRegImage;	/* REAL storage class */
		adrRet = adr;	
	}
    } /* for */

    seReg->asym.value = adrRet;
} /* DoReg */


/* N E X T   F R A M E */

export int NextFrame(cntx)
pCNTXR	cntx;
{
    /* Set the context values to be the next frame
     * OR we give them an fp of 0 to indicate end-of-stack.
     * Returns true if we had to slide around a
     * proc-call-from-the-command-line mini frame.
     */

    if ((v->adrStartLow <= cntx->pc) AND (v->adrStartHigh > cntx->pc)) {
	/* this check handles the case where ONLY "start" is on the stack */
	/* there is nothing beyond the start frame */
	cntx->fEndOfStack = true;
	return(false);
    } /* if */

    cntx->fEndOfStack = false;
    cntx->pc = GetWord(cntx->fp + v->cpu->cbPointer, spaceData);
    cntx->fp = GetWord(cntx->fp, spaceData);
    cntx->ap = cntx->fp;	/* they are the same */

    if (cntx->pc == v->adrBreak) {
	/* this frame is the end of a proc-call from the command line */
	cntx->pc = GetWord(cntx->fp + v->cpu->cbPointer, spaceData);
	cntx->fp = GetWord(cntx->fp, spaceData);
	cntx->ap = cntx->fp;
	return(true);
    } /* if */

    /* see if this is the 'start' frame */
    if ((v->adrStartLow <= cntx->pc) AND (v->adrStartHigh > cntx->pc)) {
	cntx->fEndOfStack = true;
    } else {
	cntx->fEndOfStack = (cntx->fp == 0);
    } /* if */

    return(false);
} /* NextFrame */


/* I N I T   R E G I S T E R S */

export void InitRegisters(cpu)
pCPUR	cpu;
{
    ADRT	adr;
    pSER	se;

    cpu->rgReg = vrgReg;
    se = vrgReg;

    InitSpc(se++, "result", u0, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "fp", ufp, stExpr, scRegister, tqPtr, btInt, false);
    InitSpc(se++, "sp", usp, stExpr, scRegister, tqPtr, btInt, false);
    InitSpc(se++, "pc", upc, stExpr, scRegister, tqPtr, btInt, false);

    InitSpc(se++, "d0", u0, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "d1", u1, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "d2", u2, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "d3", u3, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "d4", u4, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "d5", u5, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "d6", u6, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "d7", u7, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "a0", u8, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "a1", u9, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "a2", u10, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "a3", u11, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "a4", u12, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "a5", u13, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "a6", u14, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "a7", u15, stExpr, scRegister, tqNil, btInt, false);

#if (MFG == ISI)
#define FP_REGS	((ADRT)(((struct user *)0)->u_68881_regs));
#endif /* (MFG == ISI) */

#ifdef FP_REGS
    adr = FP_REGS;
    InitSpc(se++, "fd0", adr, stExpr, scUserStruct, tqNil, btDouble, false);
    adr += 8;
    InitSpc(se++, "fd1", adr, stExpr, scUserStruct, tqNil, btDouble, false);
    adr += 8;
    InitSpc(se++, "fd2", adr, stExpr, scUserStruct, tqNil, btDouble, false);
    adr += 8;
    InitSpc(se++, "fd3", adr, stExpr, scUserStruct, tqNil, btDouble, false);
    adr += 8;
    InitSpc(se++, "fd4", adr, stExpr, scUserStruct, tqNil, btDouble, false);
    adr += 8;
    InitSpc(se++, "fd5", adr, stExpr, scUserStruct, tqNil, btDouble, false);
    adr += 8;
    InitSpc(se++, "fd6", adr, stExpr, scUserStruct, tqNil, btDouble, false);
    adr += 8;
    InitSpc(se++, "fd7", adr, stExpr, scUserStruct, tqNil, btDouble, false);
    adr += 8;

    InitSpc(se++, "f0", adr, stExpr, scUserStruct, tqNil, btFloat, false);
    adr += 4;
    InitSpc(se++, "f1", adr, stExpr, scUserStruct, tqNil, btFloat, false);
    adr += 4;
    InitSpc(se++, "f2", adr, stExpr, scUserStruct, tqNil, btFloat, false);
    adr += 4;
    InitSpc(se++, "f3", adr, stExpr, scUserStruct, tqNil, btFloat, false);
    adr += 4;
#endif /* FP_REGS */

    cpu->iregMax = se - vrgReg;;
} /* InitRegisters */


/* L I S T   R E G I S T E R S */

export void ListRegisters(sbRegs)
SBT	sbRegs;
{
    int		i;
    pSER	se;
    MODER	amode;

    vmode->cnt = 1;
    vmode->df = dfNil;
    vmode->len = -1;
    GetMode(vmode);

    if ((v->pid == pidNil) AND (v->fnCore == fnNil))
	UError("No process.");

    if ((vmode->df != dfPStr) AND (vmode->df != dfStr)) {
	/* then we can use a more compact form */
	ColOn();
	if (vmode->df == dfNil)
	    amode = *vmode;
	se = v->cpu->rgReg;
	DisplaySe(se++, vmode, true, true, true); /* result */
	PadTo(20);
	if (amode.df == dfNil)
	    *vmode = amode;
	DisplaySe(se++, vmode, true, true, true); /* fp */
	PadTo(40);
	if (amode.df == dfNil)
	    *vmode = amode;
	DisplaySe(se++, vmode, true, true, true); /* sp */
	PadTo(60);
	if (amode.df == dfNil)
	    *vmode = amode;
	DisplaySe(se++, vmode, true, true, true); /* pc */
	printf("\n\n");

	if (amode.df == dfNil)
	    *vmode = amode;
	for (i = 4; i < v->cpu->iregMax; i += 4) {
	    DisplaySe(se++, vmode, true, true, true);
	    if (amode.df == dfNil)
		*vmode = amode;
	    PadTo(20);
	    DisplaySe(se++, vmode, true, true, true);
	    if (amode.df == dfNil)
		*vmode = amode;
	    PadTo(40);
	    DisplaySe(se++, vmode, true, true, true);
	    if (amode.df == dfNil)
		*vmode = amode;
	    PadTo(60);
	    DisplaySe(se++, vmode, true, true, true);
	    if (amode.df == dfNil)
		*vmode = amode;
	    printf("\n");
	} /* for */
	ColOff();
    } else {
	se = v->cpu->rgReg;
	for (i = 0; i < v->cpu->iregMax; i++, se++) {
	    if ( (sbRegs != sbNil)
		  AND (!FHdrCmp(sbRegs, SbFIss(se->asym.iss))) ) 
		continue;	/* not interesting */
	    DisplaySe(se, vmode, true, true, true);
	    if (amode.df == dfNil)
		*vmode = amode;
	    printf("\n");
	} /* for */
    } /* if */
} /* ListRegisters */
